/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.proxy;

import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Controller;
import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.client.ClientEvents;
import com.mrcrayfish.vehicle.client.ControllerEvents;
import com.mrcrayfish.vehicle.client.EntityRaytracer;
import com.mrcrayfish.vehicle.client.HeldVehicleEvents;
import com.mrcrayfish.vehicle.client.audio.MovingSoundHorn;
import com.mrcrayfish.vehicle.client.audio.MovingSoundHornRiding;
import com.mrcrayfish.vehicle.client.audio.MovingSoundVehicle;
import com.mrcrayfish.vehicle.client.audio.MovingSoundVehicleRiding;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.client.render.JackRenderer;
import com.mrcrayfish.vehicle.client.render.RenderBoatWrapper;
import com.mrcrayfish.vehicle.client.render.RenderEntityVehicle;
import com.mrcrayfish.vehicle.client.render.RenderHelicopterWrapper;
import com.mrcrayfish.vehicle.client.render.RenderLandVehicleWrapper;
import com.mrcrayfish.vehicle.client.render.RenderMotorcycleWrapper;
import com.mrcrayfish.vehicle.client.render.RenderPlaneWrapper;
import com.mrcrayfish.vehicle.client.render.RenderVehicleWrapper;
import com.mrcrayfish.vehicle.client.render.VehicleRenderRegistry;
import com.mrcrayfish.vehicle.client.render.tileentity.FluidExtractorRenderer;
import com.mrcrayfish.vehicle.client.render.tileentity.FuelDrumRenderer;
import com.mrcrayfish.vehicle.client.render.tileentity.GasPumpRenderer;
import com.mrcrayfish.vehicle.client.render.tileentity.GasPumpTankRenderer;
import com.mrcrayfish.vehicle.client.render.tileentity.VehicleCrateRenderer;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderATV;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderAluminumBoat;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderBath;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderBumperCar;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderCouch;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderCouchHelicopter;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderDuneBuggy;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderFertilizerTrailer;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderFluidTrailer;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderGoKart;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderGolfCart;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderJetSki;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderLawnMower;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderMiniBike;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderMiniBus;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderMoped;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderOffRoader;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderSeederTrailer;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderShoppingCart;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderSmartCar;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderSpeedBoat;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderSportsPlane;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderStorageTrailer;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderTractor;
import com.mrcrayfish.vehicle.client.render.vehicle.RenderVehicleTrailer;
import com.mrcrayfish.vehicle.client.screen.EditVehicleScreen;
import com.mrcrayfish.vehicle.client.screen.FluidExtractorScreen;
import com.mrcrayfish.vehicle.client.screen.FluidMixerScreen;
import com.mrcrayfish.vehicle.client.screen.StorageScreen;
import com.mrcrayfish.vehicle.client.screen.WorkstationScreen;
import com.mrcrayfish.vehicle.common.entity.HeldVehicleDataHandler;
import com.mrcrayfish.vehicle.common.entity.SyncedPlayerData;
import com.mrcrayfish.vehicle.common.inventory.IStorage;
import com.mrcrayfish.vehicle.entity.EntityJack;
import com.mrcrayfish.vehicle.entity.HelicopterEntity;
import com.mrcrayfish.vehicle.entity.PlaneEntity;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.trailer.FertilizerTrailerEntity;
import com.mrcrayfish.vehicle.entity.trailer.FluidTrailerEntity;
import com.mrcrayfish.vehicle.entity.trailer.SeederTrailerEntity;
import com.mrcrayfish.vehicle.entity.trailer.StorageTrailerEntity;
import com.mrcrayfish.vehicle.entity.trailer.VehicleEntityTrailer;
import com.mrcrayfish.vehicle.entity.vehicle.ATVEntity;
import com.mrcrayfish.vehicle.entity.vehicle.AluminumBoatEntity;
import com.mrcrayfish.vehicle.entity.vehicle.BathEntity;
import com.mrcrayfish.vehicle.entity.vehicle.BumperCarEntity;
import com.mrcrayfish.vehicle.entity.vehicle.CouchEntity;
import com.mrcrayfish.vehicle.entity.vehicle.DuneBuggyEntity;
import com.mrcrayfish.vehicle.entity.vehicle.GoKartEntity;
import com.mrcrayfish.vehicle.entity.vehicle.GolfCartEntity;
import com.mrcrayfish.vehicle.entity.vehicle.JetSkiEntity;
import com.mrcrayfish.vehicle.entity.vehicle.LawnMowerEntity;
import com.mrcrayfish.vehicle.entity.vehicle.MiniBikeEntity;
import com.mrcrayfish.vehicle.entity.vehicle.MiniBusEntity;
import com.mrcrayfish.vehicle.entity.vehicle.MopedEntity;
import com.mrcrayfish.vehicle.entity.vehicle.OffRoaderEntity;
import com.mrcrayfish.vehicle.entity.vehicle.ShoppingCartEntity;
import com.mrcrayfish.vehicle.entity.vehicle.SmartCarEntity;
import com.mrcrayfish.vehicle.entity.vehicle.SofacopterEntity;
import com.mrcrayfish.vehicle.entity.vehicle.SpeedBoatEntity;
import com.mrcrayfish.vehicle.entity.vehicle.SportsPlaneEntity;
import com.mrcrayfish.vehicle.entity.vehicle.TractorEntity;
import com.mrcrayfish.vehicle.init.ModContainers;
import com.mrcrayfish.vehicle.init.ModEntities;
import com.mrcrayfish.vehicle.item.KeyItem;
import com.mrcrayfish.vehicle.item.PartItem;
import com.mrcrayfish.vehicle.item.SprayCanItem;
import com.mrcrayfish.vehicle.proxy.Proxy;
import com.mrcrayfish.vehicle.tileentity.FluidExtractorTileEntity;
import com.mrcrayfish.vehicle.tileentity.FuelDrumTileEntity;
import com.mrcrayfish.vehicle.tileentity.GasPumpTankTileEntity;
import com.mrcrayfish.vehicle.tileentity.GasPumpTileEntity;
import com.mrcrayfish.vehicle.tileentity.JackTileEntity;
import com.mrcrayfish.vehicle.tileentity.VehicleCrateTileEntity;
import com.mrcrayfish.vehicle.util.FluidUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientProxy
implements Proxy {
    public static final KeyBinding KEY_HORN = new KeyBinding("key.vehicle.horn", 72, "key.categories.vehicle");
    public static final KeyBinding KEY_CYCLE_SEATS = new KeyBinding("key.vehicle.cycle_seats", 67, "key.categories.vehicle");
    public static boolean controllableLoaded = false;
    private static final WeakHashMap<UUID, Map<SoundType, ITickableSound>> SOUND_TRACKER = new WeakHashMap();

    @Override
    public void setupClient() {
        this.registerVehicleRender(ATVEntity.class, (EntityType)ModEntities.ATV.get(), new RenderLandVehicleWrapper(new RenderATV()));
        this.registerVehicleRender(DuneBuggyEntity.class, (EntityType)ModEntities.DUNE_BUGGY.get(), new RenderLandVehicleWrapper(new RenderDuneBuggy()));
        this.registerVehicleRender(GoKartEntity.class, (EntityType)ModEntities.GO_KART.get(), new RenderLandVehicleWrapper(new RenderGoKart()));
        this.registerVehicleRender(ShoppingCartEntity.class, (EntityType)ModEntities.SHOPPING_CART.get(), new RenderLandVehicleWrapper(new RenderShoppingCart()));
        this.registerVehicleRender(MiniBikeEntity.class, (EntityType)ModEntities.MINI_BIKE.get(), new RenderMotorcycleWrapper(new RenderMiniBike()));
        this.registerVehicleRender(BumperCarEntity.class, (EntityType)ModEntities.BUMPER_CAR.get(), new RenderLandVehicleWrapper(new RenderBumperCar()));
        this.registerVehicleRender(JetSkiEntity.class, (EntityType)ModEntities.JET_SKI.get(), new RenderBoatWrapper(new RenderJetSki()));
        this.registerVehicleRender(SpeedBoatEntity.class, (EntityType)ModEntities.SPEED_BOAT.get(), new RenderBoatWrapper(new RenderSpeedBoat()));
        this.registerVehicleRender(AluminumBoatEntity.class, (EntityType)ModEntities.ALUMINUM_BOAT.get(), new RenderBoatWrapper(new RenderAluminumBoat()));
        this.registerVehicleRender(SmartCarEntity.class, (EntityType)ModEntities.SMART_CAR.get(), new RenderLandVehicleWrapper(new RenderSmartCar()));
        this.registerVehicleRender(LawnMowerEntity.class, (EntityType)ModEntities.LAWN_MOWER.get(), new RenderLandVehicleWrapper(new RenderLawnMower()));
        this.registerVehicleRender(MopedEntity.class, (EntityType)ModEntities.MOPED.get(), new RenderMotorcycleWrapper(new RenderMoped()));
        this.registerVehicleRender(SportsPlaneEntity.class, (EntityType)ModEntities.SPORTS_PLANE.get(), new RenderPlaneWrapper(new RenderSportsPlane()));
        this.registerVehicleRender(GolfCartEntity.class, (EntityType)ModEntities.GOLF_CART.get(), new RenderLandVehicleWrapper(new RenderGolfCart()));
        this.registerVehicleRender(OffRoaderEntity.class, (EntityType)ModEntities.OFF_ROADER.get(), new RenderLandVehicleWrapper(new RenderOffRoader()));
        this.registerVehicleRender(TractorEntity.class, (EntityType)ModEntities.TRACTOR.get(), new RenderLandVehicleWrapper(new RenderTractor()));
        this.registerVehicleRender(MiniBusEntity.class, (EntityType)ModEntities.MINI_BUS.get(), new RenderLandVehicleWrapper(new RenderMiniBus()));
        this.registerVehicleRender(VehicleEntityTrailer.class, (EntityType)ModEntities.VEHICLE_TRAILER.get(), new RenderVehicleWrapper(new RenderVehicleTrailer()));
        this.registerVehicleRender(StorageTrailerEntity.class, (EntityType)ModEntities.STORAGE_TRAILER.get(), new RenderVehicleWrapper(new RenderStorageTrailer()));
        this.registerVehicleRender(FluidTrailerEntity.class, (EntityType)ModEntities.FLUID_TRAILER.get(), new RenderVehicleWrapper(new RenderFluidTrailer()));
        this.registerVehicleRender(SeederTrailerEntity.class, (EntityType)ModEntities.SEEDER.get(), new RenderVehicleWrapper(new RenderSeederTrailer()));
        this.registerVehicleRender(FertilizerTrailerEntity.class, (EntityType)ModEntities.FERTILIZER.get(), new RenderVehicleWrapper(new RenderFertilizerTrailer()));
        if (ModList.get().isLoaded("cfm")) {
            this.registerVehicleRender(CouchEntity.class, (EntityType)ModEntities.SOFA.get(), new RenderLandVehicleWrapper(new RenderCouch()));
            this.registerVehicleRender(BathEntity.class, (EntityType)ModEntities.BATH.get(), new RenderPlaneWrapper(new RenderBath()));
            this.registerVehicleRender(SofacopterEntity.class, (EntityType)ModEntities.SOFACOPTER.get(), new RenderHelicopterWrapper(new RenderCouchHelicopter()));
        }
        RenderingRegistry.registerEntityRenderingHandler(EntityJack.class, JackRenderer::new);
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        MinecraftForge.EVENT_BUS.register((Object)new HeldVehicleEvents());
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClientRegistry.bindTileEntitySpecialRenderer(FluidExtractorTileEntity.class, (TileEntityRenderer)new FluidExtractorRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(FuelDrumTileEntity.class, (TileEntityRenderer)new FuelDrumRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(VehicleCrateTileEntity.class, (TileEntityRenderer)new VehicleCrateRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(JackTileEntity.class, (TileEntityRenderer)new com.mrcrayfish.vehicle.client.render.tileentity.JackRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(GasPumpTileEntity.class, (TileEntityRenderer)new GasPumpRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(GasPumpTankTileEntity.class, (TileEntityRenderer)new GasPumpTankRenderer());
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_HORN);
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_CYCLE_SEATS);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.FLUID_EXTRACTOR.get()), FluidExtractorScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.FLUID_MIXER.get()), FluidMixerScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.EDIT_VEHICLE.get()), EditVehicleScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.WORKSTATION.get()), WorkstationScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.STORAGE.get()), StorageScreen::new);
        IItemColor color = (stack, index) -> {
            if (index == 0 && stack.func_77942_o() && stack.func_77978_p().func_150297_b("Color", 3)) {
                return stack.func_77978_p().func_74762_e("Color");
            }
            return 0xFFFFFF;
        };
        ForgeRegistries.ITEMS.forEach(item -> {
            if (item instanceof SprayCanItem || item instanceof KeyItem || item instanceof PartItem && ((PartItem)((Object)item)).isColored()) {
                Minecraft.func_71410_x().getItemColors().func_199877_a(color, new IItemProvider[]{item});
            }
        });
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor) -> CompletableFuture.runAsync(() -> {
            FluidUtils.clearCacheFluidColor();
            EntityRaytracer.clearDataForReregistration();
        }));
        if (ModList.get().isLoaded("controllable")) {
            controllableLoaded = true;
            MinecraftForge.EVENT_BUS.register((Object)new ControllerEvents());
        }
    }

    private <T extends VehicleEntity, R extends AbstractRenderVehicle<T>> void registerVehicleRender(Class<T> clazz, EntityType<T> type, RenderVehicleWrapper<T, R> wrapper) {
        RenderingRegistry.registerEntityRenderingHandler(clazz, manager -> new RenderEntityVehicle(manager, wrapper));
        VehicleRenderRegistry.registerRenderWrapper(type, wrapper);
    }

    @Override
    public void playVehicleSound(PlayerEntity player, PoweredVehicleEntity vehicle) {
        Minecraft.func_71410_x().func_212871_a_(() -> {
            Object sound;
            Map soundMap = SOUND_TRACKER.computeIfAbsent(vehicle.func_110124_au(), uuid -> new HashMap());
            if (vehicle.getRidingSound() != null && player.equals((Object)Minecraft.func_71410_x().field_71439_g) && ((sound = (ITickableSound)soundMap.get((Object)SoundType.ENGINE_RIDING)) == null || sound.func_147667_k() || !Minecraft.func_71410_x().func_147118_V().func_215294_c((ISound)sound))) {
                sound = new MovingSoundVehicleRiding(player, vehicle);
                soundMap.put(SoundType.ENGINE_RIDING, sound);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
            }
            if (!(vehicle.getMovingSound() == null || player.equals((Object)Minecraft.func_71410_x().field_71439_g) || (sound = (ITickableSound)soundMap.get((Object)SoundType.ENGINE)) != null && !sound.func_147667_k() && Minecraft.func_71410_x().func_147118_V().func_215294_c((ISound)sound))) {
                sound = new MovingSoundVehicle(vehicle);
                soundMap.put(SoundType.ENGINE, sound);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new MovingSoundVehicle(vehicle));
            }
            if (!(vehicle.getHornSound() == null || player.equals((Object)Minecraft.func_71410_x().field_71439_g) || (sound = (ITickableSound)soundMap.get((Object)SoundType.HORN)) != null && !sound.func_147667_k() && Minecraft.func_71410_x().func_147118_V().func_215294_c((ISound)sound))) {
                sound = new MovingSoundHorn(vehicle);
                soundMap.put(SoundType.HORN, sound);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
            }
            if (vehicle.getHornRidingSound() != null && player.equals((Object)Minecraft.func_71410_x().field_71439_g) && ((sound = (ITickableSound)soundMap.get((Object)SoundType.HORN_RIDING)) == null || sound.func_147667_k() || !Minecraft.func_71410_x().func_147118_V().func_215294_c((ISound)sound))) {
                sound = new MovingSoundHornRiding(player, vehicle);
                soundMap.put(SoundType.HORN_RIDING, sound);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
            }
        });
    }

    @Override
    public void playSound(SoundEvent soundEvent, BlockPos pos, float volume, float pitch) {
        SimpleSound sound = new SimpleSound(soundEvent, SoundCategory.BLOCKS, volume, pitch, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
        Minecraft.func_71410_x().func_213165_a(() -> ClientProxy.lambda$playSound$7((ISound)sound));
    }

    @Override
    public void playSound(SoundEvent soundEvent, float volume, float pitch) {
        Minecraft.func_71410_x().func_213165_a(() -> Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)soundEvent, (float)volume, (float)pitch)));
    }

    public void onFogDensity(EntityViewRenderEvent.FogDensity event) {
    }

    @Override
    public void syncStorageInventory(int entityId, CompoundNBT compound) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        Entity entity = world.func_73045_a(entityId);
        if (entity instanceof IStorage) {
            IStorage wrapper = (IStorage)entity;
            wrapper.getInventory().read(compound);
        }
    }

    @Override
    public PoweredVehicleEntity.AccelerationDirection getAccelerationDirection(LivingEntity entity) {
        Controller controller;
        if (controllableLoaded && (controller = Controllable.getController()) != null) {
            if (((Boolean)Config.CLIENT.useTriggers.get()).booleanValue()) {
                if (controller.getRTriggerValue() != 0.0f && controller.getLTriggerValue() == 0.0f) {
                    return PoweredVehicleEntity.AccelerationDirection.FORWARD;
                }
                if (controller.getLTriggerValue() != 0.0f && controller.getRTriggerValue() == 0.0f) {
                    return PoweredVehicleEntity.AccelerationDirection.REVERSE;
                }
            } else {
                if (controller.getButtonsStates().getState(0)) {
                    return PoweredVehicleEntity.AccelerationDirection.FORWARD;
                }
                if (controller.getButtonsStates().getState(1)) {
                    return PoweredVehicleEntity.AccelerationDirection.REVERSE;
                }
            }
        }
        return PoweredVehicleEntity.AccelerationDirection.fromEntity(entity);
    }

    @Override
    public PoweredVehicleEntity.TurnDirection getTurnDirection(LivingEntity entity) {
        Controller controller;
        if (controllableLoaded && (controller = Controllable.getController()) != null) {
            if (controller.getLThumbStickXValue() > 0.0f) {
                return PoweredVehicleEntity.TurnDirection.RIGHT;
            }
            if (controller.getLThumbStickXValue() < 0.0f) {
                return PoweredVehicleEntity.TurnDirection.LEFT;
            }
            if (controller.getButtonsStates().getState(16)) {
                return PoweredVehicleEntity.TurnDirection.RIGHT;
            }
            if (controller.getButtonsStates().getState(15)) {
                return PoweredVehicleEntity.TurnDirection.LEFT;
            }
        }
        if (entity.field_70702_br < 0.0f) {
            return PoweredVehicleEntity.TurnDirection.RIGHT;
        }
        if (entity.field_70702_br > 0.0f) {
            return PoweredVehicleEntity.TurnDirection.LEFT;
        }
        return PoweredVehicleEntity.TurnDirection.FORWARD;
    }

    @Override
    public float getTargetTurnAngle(PoweredVehicleEntity vehicle, boolean drifting) {
        PoweredVehicleEntity.TurnDirection direction = vehicle.getTurnDirection();
        if (vehicle.func_184179_bs() != null) {
            float turnNormal;
            Controller controller;
            if (controllableLoaded && (controller = Controllable.getController()) != null && (turnNormal = controller.getLThumbStickXValue()) != 0.0f) {
                float newTurnAngle = vehicle.turnAngle + ((float)vehicle.getMaxTurnAngle() * -turnNormal - vehicle.turnAngle) * 0.15f;
                if (Math.abs(newTurnAngle) > (float)vehicle.getMaxTurnAngle()) {
                    return vehicle.getMaxTurnAngle() * direction.getDir();
                }
                return newTurnAngle;
            }
            if (direction != PoweredVehicleEntity.TurnDirection.FORWARD) {
                float newTurnAngle;
                float amount = direction.getDir() * vehicle.getTurnSensitivity();
                if (drifting) {
                    amount *= 0.45f;
                }
                if (Math.abs(newTurnAngle = vehicle.turnAngle + amount) > (float)vehicle.getMaxTurnAngle()) {
                    return vehicle.getMaxTurnAngle() * direction.getDir();
                }
                return newTurnAngle;
            }
        }
        if (drifting) {
            return vehicle.turnAngle * 0.95f;
        }
        return vehicle.turnAngle * 0.75f;
    }

    @Override
    public boolean isDrifting() {
        Controller controller;
        if (controllableLoaded && (controller = Controllable.getController()) != null && controller.getButtonsStates().getState(10)) {
            return true;
        }
        return Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
    }

    @Override
    public boolean isHonking() {
        Controller controller;
        if (controllableLoaded && (controller = Controllable.getController()) != null && controller.isButtonPressed(8)) {
            return true;
        }
        return KEY_HORN.func_151470_d();
    }

    @Override
    public PlaneEntity.FlapDirection getFlapDirection() {
        Controller controller;
        boolean flapUp = Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
        boolean flapDown = Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151470_d();
        if (controllableLoaded && (controller = Controllable.getController()) != null) {
            flapUp |= controller.getButtonsStates().getState(10);
            flapDown |= controller.getButtonsStates().getState(9);
        }
        return PlaneEntity.FlapDirection.fromInput(flapUp, flapDown);
    }

    @Override
    public HelicopterEntity.AltitudeChange getAltitudeChange() {
        Controller controller;
        boolean flapUp = Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
        boolean flapDown = Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151470_d();
        if (controllableLoaded && (controller = Controllable.getController()) != null) {
            flapUp |= controller.getButtonsStates().getState(10);
            flapDown |= controller.getButtonsStates().getState(9);
        }
        return HelicopterEntity.AltitudeChange.fromInput(flapUp, flapDown);
    }

    @Override
    public float getTravelDirection(HelicopterEntity vehicle) {
        Controller controller;
        if (controllableLoaded && (controller = Controllable.getController()) != null) {
            float xAxis = controller.getLThumbStickXValue();
            float yAxis = controller.getLThumbStickYValue();
            if (xAxis != 0.0f || yAxis != 0.0f) {
                float angle = (float)Math.toDegrees(Math.atan2(-xAxis, yAxis)) + 180.0f;
                return vehicle.field_70177_z + angle;
            }
        }
        PoweredVehicleEntity.AccelerationDirection accelerationDirection = vehicle.getAcceleration();
        PoweredVehicleEntity.TurnDirection turnDirection = vehicle.getTurnDirection();
        if (vehicle.func_184179_bs() != null) {
            if (accelerationDirection == PoweredVehicleEntity.AccelerationDirection.FORWARD) {
                return vehicle.field_70177_z + (float)turnDirection.getDir() * -45.0f;
            }
            if (accelerationDirection == PoweredVehicleEntity.AccelerationDirection.REVERSE) {
                return vehicle.field_70177_z + 180.0f + (float)turnDirection.getDir() * 45.0f;
            }
            return vehicle.field_70177_z + (float)turnDirection.getDir() * -90.0f;
        }
        return vehicle.field_70177_z;
    }

    @Override
    public float getTravelSpeed(HelicopterEntity helicopter) {
        Controller controller;
        if (controllableLoaded && (controller = Controllable.getController()) != null) {
            float xAxis = controller.getLThumbStickXValue();
            float yAxis = controller.getLThumbStickYValue();
            if (xAxis != 0.0f || yAxis != 0.0f) {
                return (float)Math.min(1.0, Math.sqrt(Math.pow(xAxis, 2.0) + Math.pow(yAxis, 2.0)));
            }
        }
        return helicopter.getAcceleration() != PoweredVehicleEntity.AccelerationDirection.NONE || helicopter.getTurnDirection() != PoweredVehicleEntity.TurnDirection.FORWARD ? 1.0f : 0.0f;
    }

    @Override
    public float getPower(PoweredVehicleEntity vehicle) {
        Controller controller;
        if (controllableLoaded && ((Boolean)Config.CLIENT.useTriggers.get()).booleanValue() && (controller = Controllable.getController()) != null) {
            PoweredVehicleEntity.AccelerationDirection accelerationDirection = vehicle.getAcceleration();
            if (accelerationDirection == PoweredVehicleEntity.AccelerationDirection.FORWARD) {
                return controller.getRTriggerValue();
            }
            if (accelerationDirection == PoweredVehicleEntity.AccelerationDirection.REVERSE) {
                return controller.getLTriggerValue();
            }
        }
        return 1.0f;
    }

    @Override
    public void syncEntityFluid(int entityId, FluidStack stack) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        Entity entity = world.func_73045_a(entityId);
        if (entity == null) {
            return;
        }
        LazyOptional optional = entity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        optional.ifPresent(handler -> {
            if (handler instanceof FluidTank) {
                FluidTank tank = (FluidTank)handler;
                tank.setFluid(stack);
            }
        });
    }

    @Override
    public boolean canApplyVehicleYaw(Entity passenger) {
        if (passenger.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
            return (Boolean)Config.CLIENT.rotateCameraWithVehicle.get();
        }
        return false;
    }

    @Override
    public void syncPlayerSeat(int entityId, int seatIndex, UUID uuid) {
        Entity entity;
        ClientPlayerEntity clientPlayer = Minecraft.func_71410_x().field_71439_g;
        if (clientPlayer != null && (entity = clientPlayer.field_70170_p.func_73045_a(entityId)) instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)entity;
            vehicle.getSeatTracker().setSeatIndex(seatIndex, uuid);
        }
    }

    @Override
    public void syncHeldVehicle(int entityId, CompoundNBT compound) {
        Entity entity;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && (entity = world.func_73045_a(entityId)) instanceof PlayerEntity) {
            HeldVehicleDataHandler.setHeldVehicle((PlayerEntity)entity, compound);
        }
    }

    @Override
    public void syncPlayerData(int entityId, int trailer, Optional<BlockPos> gasPumpPos) {
        Entity entity;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && (entity = world.func_73045_a(entityId)) instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            SyncedPlayerData.setTrailer(player, trailer);
            SyncedPlayerData.setGasPumpPos(player, gasPumpPos);
        }
    }

    @Override
    public void syncTrailer(int entityId, int trailer) {
        Entity entity;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && (entity = world.func_73045_a(entityId)) instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            SyncedPlayerData.setTrailer(player, trailer);
        }
    }

    @Override
    public void syncGasPumpPos(int entityId, Optional<BlockPos> gasPumpPos) {
        Entity entity;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && (entity = world.func_73045_a(entityId)) instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            SyncedPlayerData.setGasPumpPos(player, gasPumpPos);
        }
    }

    private static /* synthetic */ void lambda$playSound$7(ISound sound) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a(sound);
    }

    private static enum SoundType {
        ENGINE,
        ENGINE_RIDING,
        HORN,
        HORN_RIDING;

    }
}

