/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mrcrayfish.vehicle.common.ItemLookup;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.LightUtil;
import org.lwjgl.opengl.GL11;

public class RenderUtil {
    public static void drawTexturedModalRect(double x, double y, int textureX, int textureY, double width, double height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x, y + height, 0.0).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)((double)textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + height, 0.0).func_187315_a((double)((float)((double)textureX + width) * 0.00390625f), (double)((float)((double)textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y, 0.0).func_187315_a((double)((float)((double)textureX + width) * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b(x + 0.0, y, 0.0).func_187315_a((double)((float)textureX * 0.00390625f), (double)((float)textureY * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawGradientRectHorizontal(int left, int top, int right, int bottom, int leftColor, int rightColor) {
        float redStart = (float)(leftColor >> 24 & 0xFF) / 255.0f;
        float greenStart = (float)(leftColor >> 16 & 0xFF) / 255.0f;
        float blueStart = (float)(leftColor >> 8 & 0xFF) / 255.0f;
        float alphaStart = (float)(leftColor & 0xFF) / 255.0f;
        float redEnd = (float)(rightColor >> 24 & 0xFF) / 255.0f;
        float greenEnd = (float)(rightColor >> 16 & 0xFF) / 255.0f;
        float blueEnd = (float)(rightColor >> 8 & 0xFF) / 255.0f;
        float alphaEnd = (float)(rightColor & 0xFF) / 255.0f;
        GlStateManager.disableTexture();
        GlStateManager.enableBlend();
        GlStateManager.disableAlphaTest();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)right, (double)top, 0.0).func_181666_a(greenEnd, blueEnd, alphaEnd, redEnd).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)top, 0.0).func_181666_a(greenStart, blueStart, alphaStart, redStart).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)bottom, 0.0).func_181666_a(greenStart, blueStart, alphaStart, redStart).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, 0.0).func_181666_a(greenEnd, blueEnd, alphaEnd, redEnd).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.shadeModel((int)7424);
        GlStateManager.disableBlend();
        GlStateManager.enableAlphaTest();
        GlStateManager.enableTexture();
    }

    public static void scissor(int x, int y, int width, int height) {
        Minecraft mc = Minecraft.func_71410_x();
        int scale = (int)mc.field_195558_d.func_198100_s();
        GL11.glScissor((int)(x * scale), (int)(mc.field_195558_d.func_198083_n() - y * scale - height * scale), (int)Math.max(0, width * scale), (int)Math.max(0, height * scale));
    }

    public static IBakedModel getModel(ItemStack stack) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
    }

    public static void renderColoredModel(IBakedModel model, ItemCameraTransforms.TransformType transformType, boolean leftHanded, int color) {
        GlStateManager.pushMatrix();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        Minecraft.func_71410_x().func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174936_b(false, false);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableRescaleNormal();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.pushMatrix();
        model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)transformType, (boolean)leftHanded);
        if (!model.func_188618_c()) {
            RenderUtil.renderModel(model, ItemStack.field_190927_a, color);
        }
        GlStateManager.cullFace((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.popMatrix();
        GlStateManager.disableRescaleNormal();
        GlStateManager.disableBlend();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        Minecraft.func_71410_x().func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174935_a();
        GlStateManager.popMatrix();
    }

    public static void renderDamagedVehicleModel(IBakedModel model, ItemCameraTransforms.TransformType transformType, boolean leftHanded, int stage, int color) {
        GlStateManager.pushMatrix();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableRescaleNormal();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.pushMatrix();
        model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)transformType, (boolean)leftHanded);
        if (!model.func_188618_c()) {
            Minecraft mc = Minecraft.func_71410_x();
            RenderUtil.renderModel(model, ItemStack.field_190927_a, color);
        }
        GlStateManager.cullFace((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.popMatrix();
        GlStateManager.disableRescaleNormal();
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
    }

    public static void renderModel(IBakedModel model, ItemCameraTransforms.TransformType transformType, boolean leftHanded, ItemStack stack) {
        GlStateManager.pushMatrix();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        Minecraft.func_71410_x().func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174936_b(false, false);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableRescaleNormal();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.pushMatrix();
        model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)transformType, (boolean)leftHanded);
        if (!model.func_188618_c()) {
            RenderUtil.renderModel(model, stack, -1);
        }
        GlStateManager.cullFace((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.popMatrix();
        GlStateManager.disableRescaleNormal();
        GlStateManager.disableBlend();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        Minecraft.func_71410_x().func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174935_a();
        GlStateManager.popMatrix();
    }

    public static void renderModel(ItemStack stack, ItemCameraTransforms.TransformType transformType, boolean leftHanded, IBakedModel model) {
        if (!stack.func_190926_b()) {
            boolean tridentFlag;
            GlStateManager.pushMatrix();
            boolean isGui = transformType == ItemCameraTransforms.TransformType.GUI;
            boolean bl = tridentFlag = isGui || transformType == ItemCameraTransforms.TransformType.GROUND || transformType == ItemCameraTransforms.TransformType.FIXED;
            if (stack.func_77973_b() == Items.field_203184_eO && tridentFlag) {
                model = Minecraft.func_71410_x().func_209506_al().func_174953_a(new ModelResourceLocation("minecraft:trident#inventory"));
            }
            ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)transformType, (boolean)leftHanded);
            GlStateManager.translated((double)-0.5, (double)-0.5, (double)-0.5);
            if (!model.func_188618_c() && (stack.func_77973_b() != Items.field_203184_eO || tridentFlag)) {
                RenderUtil.renderModel(model, stack, -1);
            } else {
                stack.func_77973_b().getTileEntityItemStackRenderer().func_179022_a(stack);
            }
            GlStateManager.popMatrix();
        }
    }

    public static void renderModel(IBakedModel model, ItemStack stack, int color) {
        GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        Random random = new Random();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            RenderUtil.renderQuads(buffer, model.func_200117_a(null, direction, random), stack, color);
        }
        random.setSeed(42L);
        RenderUtil.renderQuads(buffer, model.func_200117_a(null, null, random), stack, color);
        tessellator.func_78381_a();
    }

    private static void renderQuads(BufferBuilder renderer, List<BakedQuad> quads, ItemStack stack, int color) {
        boolean useItemColor = !stack.func_190926_b() && color == -1;
        for (BakedQuad quad : quads) {
            int tintColor = -1;
            if (quad.func_178212_b()) {
                tintColor = useItemColor ? Minecraft.func_71410_x().getItemColors().func_186728_a(stack, quad.func_178211_c()) : color;
                tintColor |= 0xFF000000;
            }
            LightUtil.renderQuadColor((BufferBuilder)renderer, (BakedQuad)quad, (int)tintColor);
        }
    }

    @Nullable
    public static IBakedModel getWheelModel(PoweredVehicleEntity entity) {
        ItemStack stack = ItemLookup.getWheel(entity);
        if (!stack.func_190926_b()) {
            return RenderUtil.getModel(stack);
        }
        return null;
    }

    @Nullable
    public static IBakedModel getEngineModel(PoweredVehicleEntity entity) {
        ItemStack stack = ItemLookup.getEngine(entity);
        if (!stack.func_190926_b()) {
            return RenderUtil.getModel(stack);
        }
        return null;
    }
}

