/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.vehicle.client.EntityRaytracer;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.client.render.Axis;
import com.mrcrayfish.vehicle.client.render.RenderVehicleWrapper;
import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.entity.BoatEntity;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.math.RayTraceResult;

public class RenderBoatWrapper<T extends BoatEntity, R extends AbstractRenderVehicle<T>>
extends RenderVehicleWrapper<T, R> {
    public RenderBoatWrapper(R renderVehicle) {
        super(renderVehicle);
    }

    @Override
    public void render(T entity, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, float partialTicks, int light) {
        if (!entity.func_70089_S()) {
            return;
        }
        matrixStack.func_227860_a_();
        VehicleProperties properties = ((VehicleEntity)((Object)entity)).getProperties();
        PartPosition bodyPosition = properties.getBodyPosition();
        matrixStack.func_227863_a_(Axis.POSITIVE_X.func_229187_a_((float)bodyPosition.getRotX()));
        matrixStack.func_227863_a_(Axis.POSITIVE_Y.func_229187_a_((float)bodyPosition.getRotY()));
        matrixStack.func_227863_a_(Axis.POSITIVE_Z.func_229187_a_((float)bodyPosition.getRotZ()));
        float currentSpeedNormal = (((BoatEntity)((Object)entity)).prevCurrentSpeed + (((BoatEntity)((Object)entity)).currentSpeed - ((BoatEntity)((Object)entity)).prevCurrentSpeed) * partialTicks) / ((PoweredVehicleEntity)((Object)entity)).getMaxSpeed();
        float turnAngleNormal = (((BoatEntity)((Object)entity)).prevTurnAngle + (((BoatEntity)((Object)entity)).turnAngle - ((BoatEntity)((Object)entity)).prevTurnAngle) * partialTicks) / (float)((PoweredVehicleEntity)((Object)entity)).getMaxTurnAngle();
        matrixStack.func_227863_a_(Axis.POSITIVE_Z.func_229187_a_(turnAngleNormal * currentSpeedNormal * -15.0f));
        matrixStack.func_227863_a_(Axis.POSITIVE_X.func_229187_a_(-8.0f * Math.min(1.0f, currentSpeedNormal)));
        matrixStack.func_227861_a_(bodyPosition.getX(), bodyPosition.getY(), bodyPosition.getZ());
        matrixStack.func_227861_a_(0.0, 0.5, 0.0);
        matrixStack.func_227861_a_(0.0, -0.5, 0.0);
        matrixStack.func_227862_a_((float)bodyPosition.getScale(), (float)bodyPosition.getScale(), (float)bodyPosition.getScale());
        matrixStack.func_227861_a_(0.0, 0.5, 0.0);
        matrixStack.func_227861_a_(0.0, (double)properties.getAxleOffset() * 0.0625, 0.0);
        matrixStack.func_227861_a_(0.0, (double)properties.getWheelOffset() * 0.0625, 0.0);
        this.renderVehicle.render(entity, matrixStack, renderTypeBuffer, partialTicks, light);
        if (((PoweredVehicleEntity)((Object)entity)).shouldRenderEngine() && ((PoweredVehicleEntity)((Object)entity)).hasEngine()) {
            this.renderEngine((PoweredVehicleEntity)((Object)entity), properties.getEnginePosition(), RenderUtil.getEngineModel(entity), matrixStack, renderTypeBuffer, light);
        }
        if (((PoweredVehicleEntity)((Object)entity)).shouldRenderFuelPort() && ((PoweredVehicleEntity)((Object)entity)).requiresFuel()) {
            PoweredVehicleEntity.FuelPortType fuelPortType = ((PoweredVehicleEntity)((Object)entity)).getFuelPortType();
            EntityRaytracer.RayTraceResultRotated result = EntityRaytracer.getContinuousInteraction();
            if (result != null && result.func_216346_c() == RayTraceResult.Type.ENTITY && result.func_216348_a() == entity && result.equalsContinuousInteraction(EntityRaytracer.FUNCTION_FUELING)) {
                this.renderPart(properties.getFuelPortPosition(), fuelPortType.getOpenModel().getModel(), matrixStack, renderTypeBuffer, ((VehicleEntity)((Object)entity)).getColor(), light, OverlayTexture.field_229196_a_);
                if (this.renderVehicle.shouldRenderFuelLid()) {
                    // empty if block
                }
                ((PoweredVehicleEntity)((Object)entity)).playFuelPortOpenSound();
            } else {
                this.renderPart(properties.getFuelPortPosition(), fuelPortType.getClosedModel().getModel(), matrixStack, renderTypeBuffer, ((VehicleEntity)((Object)entity)).getColor(), light, OverlayTexture.field_229196_a_);
                ((PoweredVehicleEntity)((Object)entity)).playFuelPortCloseSound();
            }
        }
        if (((PoweredVehicleEntity)((Object)entity)).isKeyNeeded()) {
            this.renderPart(properties.getKeyPortPosition(), this.renderVehicle.getKeyHoleModel().getModel(), matrixStack, renderTypeBuffer, ((VehicleEntity)((Object)entity)).getColor(), light, OverlayTexture.field_229196_a_);
            if (!((PoweredVehicleEntity)((Object)entity)).getKeyStack().func_190926_b()) {
                this.renderKey(properties.getKeyPosition(), ((PoweredVehicleEntity)((Object)entity)).getKeyStack(), RenderUtil.getModel(((PoweredVehicleEntity)((Object)entity)).getKeyStack()), matrixStack, renderTypeBuffer, -1, light, OverlayTexture.field_229196_a_);
            }
        }
        matrixStack.func_227865_b_();
    }
}

