/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.vehicle.client.EntityRaytracer;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.client.render.RenderVehicleWrapper;
import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.entity.PlaneEntity;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.math.RayTraceResult;

public class RenderPlaneWrapper<T extends PlaneEntity, R extends AbstractRenderVehicle<T>>
extends RenderVehicleWrapper<T, R> {
    public RenderPlaneWrapper(R renderVehicle) {
        super(renderVehicle);
    }

    @Override
    public void render(T entity, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, float partialTicks, int light) {
        if (!entity.func_70089_S()) {
            return;
        }
        matrixStack.func_227860_a_();
        VehicleProperties properties = ((VehicleEntity)((Object)entity)).getProperties();
        PartPosition bodyPosition = properties.getBodyPosition();
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)bodyPosition.getRotX()));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)bodyPosition.getRotY()));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)bodyPosition.getRotZ()));
        matrixStack.func_227861_a_(0.0, 0.5, 0.0);
        float bodyPitch = ((PlaneEntity)((Object)entity)).prevBodyRotationX + (((PlaneEntity)((Object)entity)).bodyRotationX - ((PlaneEntity)((Object)entity)).prevBodyRotationX) * partialTicks;
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-bodyPitch));
        float bodyRoll = ((PlaneEntity)((Object)entity)).prevBodyRotationZ + (((PlaneEntity)((Object)entity)).bodyRotationZ - ((PlaneEntity)((Object)entity)).prevBodyRotationZ) * partialTicks;
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-bodyRoll));
        matrixStack.func_227861_a_(0.0, -0.5, 0.0);
        matrixStack.func_227861_a_(bodyPosition.getX(), bodyPosition.getY(), bodyPosition.getZ());
        matrixStack.func_227862_a_((float)bodyPosition.getScale(), (float)bodyPosition.getScale(), (float)bodyPosition.getScale());
        matrixStack.func_227861_a_(0.0, 0.5, 0.0);
        matrixStack.func_227861_a_(0.0, (double)properties.getAxleOffset() * 0.0625, 0.0);
        matrixStack.func_227861_a_(0.0, (double)properties.getWheelOffset() * 0.0625, 0.0);
        this.renderVehicle.render(entity, matrixStack, renderTypeBuffer, partialTicks, light);
        if (((PoweredVehicleEntity)((Object)entity)).shouldRenderEngine() && ((PoweredVehicleEntity)((Object)entity)).hasEngine()) {
            IBakedModel engineModel = RenderUtil.getEngineModel(entity);
            this.renderEngine((PoweredVehicleEntity)((Object)entity), properties.getEnginePosition(), engineModel, matrixStack, renderTypeBuffer, light);
        }
        if (((PoweredVehicleEntity)((Object)entity)).shouldRenderFuelPort() && ((PoweredVehicleEntity)((Object)entity)).requiresFuel()) {
            PoweredVehicleEntity.FuelPortType fuelPortType = ((PoweredVehicleEntity)((Object)entity)).getFuelPortType();
            EntityRaytracer.RayTraceResultRotated result = EntityRaytracer.getContinuousInteraction();
            if (result != null && result.func_216346_c() == RayTraceResult.Type.ENTITY && result.func_216348_a() == entity && result.equalsContinuousInteraction(EntityRaytracer.FUNCTION_FUELING)) {
                this.renderPart(properties.getFuelPortPosition(), fuelPortType.getOpenModel().getModel(), matrixStack, renderTypeBuffer, ((VehicleEntity)((Object)entity)).getColor(), light, OverlayTexture.field_229196_a_);
                if (this.renderVehicle.shouldRenderFuelLid()) {
                    // empty if block
                }
                ((PoweredVehicleEntity)((Object)entity)).playFuelPortOpenSound();
            } else {
                this.renderPart(properties.getFuelPortPosition(), fuelPortType.getClosedModel().getModel(), matrixStack, renderTypeBuffer, ((VehicleEntity)((Object)entity)).getColor(), light, OverlayTexture.field_229196_a_);
                ((PoweredVehicleEntity)((Object)entity)).playFuelPortCloseSound();
            }
        }
        if (((PoweredVehicleEntity)((Object)entity)).isKeyNeeded()) {
            this.renderPart(properties.getKeyPortPosition(), this.renderVehicle.getKeyHoleModel().getModel(), matrixStack, renderTypeBuffer, ((VehicleEntity)((Object)entity)).getColor(), light, OverlayTexture.field_229196_a_);
            if (!((PoweredVehicleEntity)((Object)entity)).getKeyStack().func_190926_b()) {
                this.renderKey(properties.getKeyPosition(), ((PoweredVehicleEntity)((Object)entity)).getKeyStack(), RenderUtil.getModel(((PoweredVehicleEntity)((Object)entity)).getKeyStack()), matrixStack, renderTypeBuffer, -1, light, OverlayTexture.field_229196_a_);
            }
        }
        matrixStack.func_227865_b_();
    }
}

