/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.util.RenderUtil;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;

public class RenderVehicleWrapper<T extends VehicleEntity, R extends AbstractRenderVehicle<T>> {
    protected final R renderVehicle;

    public RenderVehicleWrapper(R renderVehicle) {
        this.renderVehicle = renderVehicle;
    }

    public R getRenderVehicle() {
        return this.renderVehicle;
    }

    public void render(T entity, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, float partialTicks, int light) {
        if (!entity.func_70089_S()) {
            return;
        }
        matrixStack.func_227860_a_();
        VehicleProperties properties = ((VehicleEntity)((Object)entity)).getProperties();
        PartPosition bodyPosition = properties.getBodyPosition();
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)bodyPosition.getRotX()));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)bodyPosition.getRotY()));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)bodyPosition.getRotZ()));
        if (((VehicleEntity)((Object)entity)).canTowTrailer()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            Vec3d towBarOffset = properties.getTowBarPosition();
            matrixStack.func_227861_a_(towBarOffset.field_72450_a * 0.0625, towBarOffset.field_72448_b * 0.0625 + 0.5, -towBarOffset.field_72449_c * 0.0625);
            RenderUtil.renderColoredModel(SpecialModels.TOW_BAR.getModel(), ItemCameraTransforms.TransformType.NONE, false, matrixStack, renderTypeBuffer, -1, light, OverlayTexture.field_229196_a_);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227861_a_(bodyPosition.getX(), bodyPosition.getY(), bodyPosition.getZ());
        matrixStack.func_227862_a_((float)bodyPosition.getScale(), (float)bodyPosition.getScale(), (float)bodyPosition.getScale());
        matrixStack.func_227861_a_(0.0, 0.5, 0.0);
        matrixStack.func_227861_a_(0.0, (double)properties.getAxleOffset() * 0.0625, 0.0);
        matrixStack.func_227861_a_(0.0, (double)properties.getWheelOffset() * 0.0625, 0.0);
        ((AbstractRenderVehicle)this.renderVehicle).render(entity, matrixStack, renderTypeBuffer, partialTicks, light);
        matrixStack.func_227865_b_();
    }

    public void applyPreRotations(T entity, MatrixStack stack, float partialTicks) {
    }

    protected void renderPart(@Nullable PartPosition position, IBakedModel model, MatrixStack matrixStack, IRenderTypeBuffer buffer, int color, int lightTexture, int overlayTexture) {
        if (position == null) {
            return;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(position.getX() * 0.0625, position.getY() * 0.0625, position.getZ() * 0.0625);
        matrixStack.func_227861_a_(0.0, -0.5, 0.0);
        matrixStack.func_227862_a_((float)position.getScale(), (float)position.getScale(), (float)position.getScale());
        matrixStack.func_227861_a_(0.0, 0.5, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)position.getRotX()));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)position.getRotY()));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)position.getRotZ()));
        RenderUtil.renderColoredModel(model, ItemCameraTransforms.TransformType.NONE, false, matrixStack, buffer, color, lightTexture, overlayTexture);
        matrixStack.func_227865_b_();
    }

    protected void renderKey(@Nullable PartPosition position, ItemStack stack, IBakedModel model, MatrixStack matrixStack, IRenderTypeBuffer buffer, int color, int lightTexture, int overlayTexture) {
        if (position == null) {
            return;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(position.getX() * 0.0625, position.getY() * 0.0625, position.getZ() * 0.0625);
        matrixStack.func_227861_a_(0.0, -0.25, 0.0);
        matrixStack.func_227862_a_((float)position.getScale(), (float)position.getScale(), (float)position.getScale());
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)position.getRotX()));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)position.getRotY()));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)position.getRotZ()));
        matrixStack.func_227861_a_(0.0, 0.0, -0.05);
        RenderUtil.renderModel(stack, ItemCameraTransforms.TransformType.NONE, false, matrixStack, buffer, lightTexture, overlayTexture, model);
        matrixStack.func_227865_b_();
    }

    protected void renderEngine(PoweredVehicleEntity entity, @Nullable PartPosition position, IBakedModel model, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light) {
        matrixStack.func_227860_a_();
        if (entity.isEnginePowered() && entity.func_184179_bs() != null) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(0.5f * (float)(entity.field_70173_aa % 2)));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(0.5f * (float)(entity.field_70173_aa % 2)));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-0.5f * (float)(entity.field_70173_aa % 2)));
        }
        this.renderPart(position, model, matrixStack, buffer, -1, light, OverlayTexture.field_229196_a_);
        matrixStack.func_227865_b_();
    }
}

