/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.vehicle;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.AbstractRenderTrailer;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.trailer.FluidTrailerEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.world.ILightReader;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class RenderFluidTrailer
extends AbstractRenderTrailer<FluidTrailerEntity> {
    @Override
    public void render(FluidTrailerEntity entity, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, float partialTicks, int light) {
        this.renderDamagedPart((VehicleEntity)entity, SpecialModels.FLUID_TRAILER.getModel(), matrixStack, renderTypeBuffer, light);
        this.renderWheel(entity, matrixStack, renderTypeBuffer, false, -0.71875f, -0.5f, -0.15625f, 2.0f, partialTicks, light);
        this.renderWheel(entity, matrixStack, renderTypeBuffer, true, 0.71875f, -0.5f, -0.15625f, 2.0f, partialTicks, light);
        float height = 9.9f * ((float)entity.getTank().getFluidAmount() / (float)entity.getTank().getCapacity()) * 0.0625f;
        this.drawFluid(entity, entity.getTank(), matrixStack, renderTypeBuffer, -0.3875f, -0.1875f, -0.99f, 0.7625f, height, 1.67f, light);
    }

    private void drawFluid(FluidTrailerEntity entity, FluidTank tank, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, float x, float y, float z, float width, float height, float depth, int light) {
        Fluid fluid = tank.getFluid().getFluid();
        if (fluid == Fluids.field_204541_a) {
            return;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(fluid.getFluid().getAttributes().getStillTexture());
        int waterColor = fluid.getAttributes().getColor((ILightReader)entity.func_130014_f_(), entity.func_180425_c());
        float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(waterColor & 0xFF) / 255.0f;
        float minU = sprite.func_94209_e();
        float maxU = Math.min(minU + (sprite.func_94212_f() - minU) * width, sprite.func_94212_f());
        float minV = sprite.func_94206_g();
        float maxV = Math.min(minV + (sprite.func_94210_h() - minV) * height, sprite.func_94210_h());
        IVertexBuilder buffer = renderTypeBuffer.getBuffer(RenderType.func_228647_g_());
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(matrix, x + width, y, z).func_227885_a_(red - 0.25f, green - 0.25f, blue - 0.25f, 1.0f).func_225583_a_(maxU, minV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x, y, z).func_227885_a_(red - 0.25f, green - 0.25f, blue - 0.25f, 1.0f).func_225583_a_(minU, minV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x, y + height, z).func_227885_a_(red - 0.25f, green - 0.25f, blue - 0.25f, 1.0f).func_225583_a_(minU, maxV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y + height, z).func_227885_a_(red - 0.25f, green - 0.25f, blue - 0.25f, 1.0f).func_225583_a_(maxU, maxV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x, y, z + depth).func_227885_a_(red - 0.25f, green - 0.25f, blue - 0.25f, 1.0f).func_225583_a_(maxU, minV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y, z + depth).func_227885_a_(red - 0.25f, green - 0.25f, blue - 0.25f, 1.0f).func_225583_a_(minU, minV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y + height, z + depth).func_227885_a_(red - 0.25f, green - 0.25f, blue - 0.25f, 1.0f).func_225583_a_(minU, maxV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x, y + height, z + depth).func_227885_a_(red - 0.25f, green - 0.25f, blue - 0.25f, 1.0f).func_225583_a_(maxU, maxV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        maxU = Math.min(minU + (sprite.func_94212_f() - minU) * depth, sprite.func_94212_f());
        maxV = Math.min(minV + (sprite.func_94210_h() - minV) * width, sprite.func_94210_h());
        buffer.func_227888_a_(matrix, x, y + height, z).func_227885_a_(red, green, blue, 1.0f).func_225583_a_(maxU, minV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x, y + height, z + depth).func_227885_a_(red, green, blue, 1.0f).func_225583_a_(minU, minV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y + height, z + depth).func_227885_a_(red, green, blue, 1.0f).func_225583_a_(minU, maxV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y + height, z).func_227885_a_(red, green, blue, 1.0f).func_225583_a_(maxU, maxV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
    }
}

