/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.vehicle;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.client.render.Axis;
import com.mrcrayfish.vehicle.common.ItemLookup;
import com.mrcrayfish.vehicle.common.Seat;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.entity.vehicle.MiniBikeEntity;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.Vec3d;

public class RenderMiniBike
extends AbstractRenderVehicle<MiniBikeEntity> {
    @Override
    public void render(MiniBikeEntity entity, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, float partialTicks, int light) {
        this.renderDamagedPart((VehicleEntity)entity, SpecialModels.MINI_BIKE_BODY.getModel(), matrixStack, renderTypeBuffer, light);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 0.65625);
        matrixStack.func_227863_a_(Axis.POSITIVE_X.func_229187_a_(-22.5f));
        float wheelScale = 1.65f;
        float wheelAngle = entity.prevRenderWheelAngle + (entity.renderWheelAngle - entity.prevRenderWheelAngle) * partialTicks;
        float wheelAngleNormal = wheelAngle / 45.0f;
        float turnRotation = wheelAngleNormal * 25.0f;
        matrixStack.func_227863_a_(Axis.POSITIVE_Y.func_229187_a_(turnRotation));
        matrixStack.func_227863_a_(Axis.POSITIVE_X.func_229187_a_(22.5f));
        matrixStack.func_227861_a_(0.0, 0.0, -0.65625);
        this.renderDamagedPart((VehicleEntity)entity, SpecialModels.MINI_BIKE_HANDLES.getModel(), matrixStack, renderTypeBuffer, light);
        if (entity.hasWheels()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, -0.39375, 0.8125);
            float frontWheelSpin = entity.prevFrontWheelRotation + (entity.frontWheelRotation - entity.prevFrontWheelRotation) * partialTicks;
            if (entity.isMoving()) {
                matrixStack.func_227863_a_(Axis.POSITIVE_X.func_229187_a_(-frontWheelSpin));
            }
            matrixStack.func_227862_a_(wheelScale, wheelScale, wheelScale);
            matrixStack.func_227863_a_(Axis.POSITIVE_Y.func_229187_a_(180.0f));
            RenderUtil.renderColoredModel(RenderUtil.getModel(ItemLookup.getWheel(entity)), ItemCameraTransforms.TransformType.NONE, false, matrixStack, renderTypeBuffer, -1, light, OverlayTexture.field_229196_a_);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }

    @Override
    public void applyPlayerModel(MiniBikeEntity entity, PlayerEntity player, PlayerModel model, float partialTicks) {
        float wheelAngle = entity.prevRenderWheelAngle + (entity.renderWheelAngle - entity.prevRenderWheelAngle) * partialTicks;
        float wheelAngleNormal = wheelAngle / 45.0f;
        float turnRotation = wheelAngleNormal * 8.0f;
        model.field_178723_h.field_78795_f = (float)Math.toRadians(-55.0f - turnRotation);
        model.field_178724_i.field_78795_f = (float)Math.toRadians(-55.0f + turnRotation);
        model.field_178721_j.field_78795_f = (float)Math.toRadians(-65.0);
        model.field_178721_j.field_78796_g = (float)Math.toRadians(30.0);
        model.field_178722_k.field_78795_f = (float)Math.toRadians(-65.0);
        model.field_178722_k.field_78796_g = (float)Math.toRadians(-30.0);
    }

    @Override
    public void applyPlayerRender(MiniBikeEntity entity, PlayerEntity player, float partialTicks, MatrixStack matrixStack, IVertexBuilder builder) {
        int index = entity.getSeatTracker().getSeatIndex(player.func_110124_au());
        if (index != -1) {
            VehicleProperties properties = entity.getProperties();
            Seat seat = properties.getSeats().get(index);
            Vec3d seatVec = seat.getPosition().func_72441_c(0.0, (double)(properties.getAxleOffset() + properties.getWheelOffset()), 0.0).func_186678_a(properties.getBodyPosition().getScale()).func_186678_a(0.0625);
            double scale = 1.0666666666666667;
            double offsetX = seatVec.field_72450_a * scale;
            double offsetY = (seatVec.field_72448_b + player.func_70033_W()) * scale + 1.5;
            double offsetZ = -seatVec.field_72449_c * scale;
            matrixStack.func_227861_a_(offsetX, offsetY, offsetZ);
            float currentSpeedNormal = (entity.prevCurrentSpeed + (entity.currentSpeed - entity.prevCurrentSpeed) * partialTicks) / entity.getMaxSpeed();
            float turnAngleNormal = (entity.prevTurnAngle + (entity.turnAngle - entity.prevTurnAngle) * partialTicks) / 45.0f;
            matrixStack.func_227863_a_(Axis.POSITIVE_Z.func_229187_a_(turnAngleNormal * currentSpeedNormal * 20.0f));
            matrixStack.func_227861_a_(-offsetX, -offsetY, -offsetZ);
        }
    }
}

