/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.vehicle.client.render.Axis;
import com.mrcrayfish.vehicle.client.render.RenderVehicleWrapper;
import com.mrcrayfish.vehicle.client.render.VehicleRenderRegistry;
import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.entity.EngineType;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.inventory.container.EditVehicleContainer;
import com.mrcrayfish.vehicle.util.CommonUtils;
import com.mrcrayfish.vehicle.util.RenderUtil;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;

public class EditVehicleScreen
extends ContainerScreen<EditVehicleContainer> {
    private static final ResourceLocation GUI_TEXTURES = new ResourceLocation("vehicle:textures/gui/edit_vehicle.png");
    private final PlayerInventory playerInventory;
    private final IInventory vehicleInventory;
    private final PoweredVehicleEntity vehicle;
    private boolean showHelp = true;
    private int windowZoom = 10;
    private int windowX;
    private int windowY;
    private float windowRotationX;
    private float windowRotationY;
    private boolean mouseGrabbed;
    private int mouseGrabbedButton;
    private int mouseClickedX;
    private int mouseClickedY;

    public EditVehicleScreen(EditVehicleContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.playerInventory = playerInventory;
        this.vehicleInventory = container.getVehicleInventory();
        this.vehicle = container.getVehicle();
        this.field_147000_g = 184;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_110434_K().func_110577_a(GUI_TEXTURES);
        int left = (this.width - this.field_146999_f) / 2;
        int top = (this.height - this.field_147000_g) / 2;
        this.blit(left, top, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.vehicle.getEngineType() != EngineType.NONE) {
            if (this.vehicleInventory.func_70301_a(0).func_190926_b()) {
                this.blit(left + 8, top + 17, 176, 0, 16, 16);
            }
        } else if (this.vehicleInventory.func_70301_a(0).func_190926_b()) {
            this.blit(left + 8, top + 17, 176, 32, 16, 16);
        }
        if (this.vehicle.canChangeWheels()) {
            if (this.vehicleInventory.func_70301_a(1).func_190926_b()) {
                this.blit(left + 8, top + 35, 176, 16, 16, 16);
            }
        } else if (this.vehicleInventory.func_70301_a(1).func_190926_b()) {
            this.blit(left + 8, top + 35, 176, 32, 16, 16);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.field_71466_p.func_211126_b(this.title.func_150254_d(), 8.0f, 6.0f, 0x404040);
        minecraft.field_71466_p.func_211126_b(this.playerInventory.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        RenderVehicleWrapper<?, ?> wrapper = VehicleRenderRegistry.getRenderWrapper((EntityType<? extends VehicleEntity>)this.vehicle.func_200600_R());
        if (wrapper != null) {
            int startX = (this.width - this.field_146999_f) / 2;
            int startY = (this.height - this.field_147000_g) / 2;
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)96.0f, (float)78.0f, (float)1050.0f);
            RenderSystem.scalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
            GL11.glEnable((int)3089);
            RenderUtil.scissor(startX + 26, startY + 17, 142, 70);
            MatrixStack matrixStack = new MatrixStack();
            matrixStack.func_227861_a_(0.0, 0.0, 1000.0);
            matrixStack.func_227861_a_((double)(this.windowX - (this.mouseGrabbed && this.mouseGrabbedButton == 0 ? mouseX - this.mouseClickedX : 0)), 0.0, 0.0);
            matrixStack.func_227861_a_(0.0, (double)(this.windowY - (this.mouseGrabbed && this.mouseGrabbedButton == 0 ? mouseY - this.mouseClickedY : 0)), 0.0);
            Quaternion quaternion = Axis.POSITIVE_X.func_229187_a_(-10.0f);
            quaternion.func_195890_a(Axis.POSITIVE_X.func_229187_a_(this.windowRotationY - (float)(this.mouseGrabbed && this.mouseGrabbedButton == 1 ? mouseY - this.mouseClickedY : 0)));
            quaternion.func_195890_a(Axis.POSITIVE_Y.func_229187_a_(this.windowRotationX + (float)(this.mouseGrabbed && this.mouseGrabbedButton == 1 ? mouseX - this.mouseClickedX : 0)));
            quaternion.func_195890_a(Axis.POSITIVE_Y.func_229187_a_(135.0f));
            matrixStack.func_227863_a_(quaternion);
            matrixStack.func_227862_a_((float)this.windowZoom / 10.0f, (float)this.windowZoom / 10.0f, (float)this.windowZoom / 10.0f);
            matrixStack.func_227862_a_(22.0f, 22.0f, 22.0f);
            VehicleProperties properties = VehicleProperties.getProperties(this.vehicle.func_200600_R());
            PartPosition position = PartPosition.DEFAULT;
            if (properties != null) {
                position = properties.getDisplayPosition();
            }
            matrixStack.func_227862_a_((float)position.getScale(), (float)position.getScale(), (float)position.getScale());
            matrixStack.func_227863_a_(Axis.POSITIVE_X.func_229187_a_((float)position.getRotX()));
            matrixStack.func_227863_a_(Axis.POSITIVE_Y.func_229187_a_((float)position.getRotY()));
            matrixStack.func_227863_a_(Axis.POSITIVE_Z.func_229187_a_((float)position.getRotZ()));
            matrixStack.func_227861_a_(position.getX(), position.getY(), position.getZ());
            EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
            renderManager.func_178633_a(false);
            renderManager.func_229089_a_(quaternion);
            IRenderTypeBuffer.Impl renderTypeBuffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            wrapper.render(this.vehicle, matrixStack, (IRenderTypeBuffer)renderTypeBuffer, Minecraft.func_71410_x().func_184121_ak(), 0xF000F0);
            renderTypeBuffer.func_228461_a_();
            renderManager.func_178633_a(true);
            GL11.glDisable((int)3089);
            RenderSystem.popMatrix();
        }
        if (this.showHelp) {
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            minecraft.field_71466_p.func_211126_b(I18n.func_135052_a((String)"container.edit_vehicle.window_help", (Object[])new Object[0]), 56.0f, 38.0f, Color.WHITE.getRGB());
            RenderSystem.popMatrix();
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        int startX = (this.width - this.field_146999_f) / 2;
        int startY = (this.height - this.field_147000_g) / 2;
        if (CommonUtils.isMouseWithin((int)mouseX, (int)mouseY, startX + 26, startY + 17, 142, 70)) {
            if (scroll < 0.0 && this.windowZoom > 0) {
                this.showHelp = false;
                --this.windowZoom;
            } else if (scroll > 0.0) {
                this.showHelp = false;
                ++this.windowZoom;
            }
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int startX = (this.width - this.field_146999_f) / 2;
        int startY = (this.height - this.field_147000_g) / 2;
        if (CommonUtils.isMouseWithin((int)mouseX, (int)mouseY, startX + 26, startY + 17, 142, 70) && !this.mouseGrabbed && (button == 0 || button == 1)) {
            this.mouseGrabbed = true;
            this.mouseGrabbedButton = button == 1 ? 1 : 0;
            this.mouseClickedX = (int)mouseX;
            this.mouseClickedY = (int)mouseY;
            this.showHelp = false;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.mouseGrabbed) {
            if (this.mouseGrabbedButton == 0 && button == 0) {
                this.mouseGrabbed = false;
                this.windowX = (int)((double)this.windowX - (mouseX - (double)this.mouseClickedX));
                this.windowY = (int)((double)this.windowY - (mouseY - (double)this.mouseClickedY));
            } else if (this.mouseGrabbedButton == 1 && button == 1) {
                this.mouseGrabbed = false;
                this.windowRotationX = (float)((double)this.windowRotationX + (mouseX - (double)this.mouseClickedX));
                this.windowRotationY = (float)((double)this.windowRotationY - (mouseY - (double)this.mouseClickedY));
            }
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        int startX = (this.width - this.field_146999_f) / 2;
        int startY = (this.height - this.field_147000_g) / 2;
        if (this.vehicleInventory.func_70301_a(0).func_190926_b() && CommonUtils.isMouseWithin(mouseX, mouseY, startX + 7, startY + 16, 18, 18)) {
            if (this.vehicle.getEngineType() != EngineType.NONE) {
                this.renderTooltip(Collections.singletonList("Engine"), mouseX, mouseY, this.minecraft.field_71466_p);
            } else {
                this.renderTooltip(Arrays.asList("Engine", TextFormatting.GRAY + "Not applicable"), mouseX, mouseY, this.minecraft.field_71466_p);
            }
        }
        if (this.vehicleInventory.func_70301_a(1).func_190926_b() && CommonUtils.isMouseWithin(mouseX, mouseY, startX + 7, startY + 34, 18, 18)) {
            if (this.vehicle.canChangeWheels()) {
                this.renderTooltip(Collections.singletonList("Wheels"), mouseX, mouseY, this.minecraft.field_71466_p);
            } else {
                this.renderTooltip(Arrays.asList("Wheels", TextFormatting.GRAY + "Not applicable"), mouseX, mouseY, this.minecraft.field_71466_p);
            }
        }
    }
}

