/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity.vehicle;

import com.google.common.collect.Lists;
import com.mrcrayfish.vehicle.client.EntityRaytracer;
import com.mrcrayfish.vehicle.common.inventory.IAttachableChest;
import com.mrcrayfish.vehicle.common.inventory.StorageInventory;
import com.mrcrayfish.vehicle.entity.EngineType;
import com.mrcrayfish.vehicle.entity.MotorcycleEntity;
import com.mrcrayfish.vehicle.init.ModSounds;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageAttachChest;
import com.mrcrayfish.vehicle.network.message.MessageOpenStorage;
import com.mrcrayfish.vehicle.util.InventoryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class MopedEntity
extends MotorcycleEntity
implements EntityRaytracer.IEntityRaytraceable,
IAttachableChest {
    private static final DataParameter<Boolean> CHEST = EntityDataManager.func_187226_a(MopedEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final EntityRaytracer.RayTracePart CHEST_BOX = new EntityRaytracer.RayTracePart(new AxisAlignedBB(-0.31875, 0.7945, -0.978125, 0.31875, 1.4195, -0.34375));
    private static final EntityRaytracer.RayTracePart TRAY_BOX = new EntityRaytracer.RayTracePart(MopedEntity.createScaledBoundingBox(-0.25, 0.6, -0.28125, 0.25, 0.6625, -0.78125, 1.2));
    private static final Map<EntityRaytracer.RayTracePart, EntityRaytracer.TriangleRayTraceList> interactionBoxMapStatic = (Map)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> {
        HashMap<EntityRaytracer.RayTracePart, EntityRaytracer.TriangleRayTraceList> map = new HashMap<EntityRaytracer.RayTracePart, EntityRaytracer.TriangleRayTraceList>();
        map.put(CHEST_BOX, EntityRaytracer.boxToTriangles(CHEST_BOX.getBox(), null));
        map.put(TRAY_BOX, EntityRaytracer.boxToTriangles(TRAY_BOX.getBox(), null));
        return map;
    });
    private StorageInventory inventory;

    public MopedEntity(EntityType<? extends MopedEntity> type, World worldIn) {
        super(type, worldIn);
        this.setMaxSpeed(12.0f);
        this.setTurnSensitivity(15);
        this.setMaxTurnAngle(45);
        this.setFuelCapacity(12000.0f);
        this.setFuelConsumption(0.225f);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CHEST, (Object)false);
    }

    @Override
    public SoundEvent getMovingSound() {
        return (SoundEvent)ModSounds.MOPED_ENGINE_MONO.get();
    }

    @Override
    public SoundEvent getRidingSound() {
        return (SoundEvent)ModSounds.MOPED_ENGINE_STEREO.get();
    }

    @Override
    public EngineType getEngineType() {
        return EngineType.SMALL_MOTOR;
    }

    @Override
    public float getMinEnginePitch() {
        return 0.5f;
    }

    @Override
    public float getMaxEnginePitch() {
        return 1.2f;
    }

    @Override
    public boolean canBeColored() {
        return true;
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Chest", 1)) {
            this.setChest(compound.func_74767_n("Chest"));
            if (compound.func_150297_b("Inventory", 9)) {
                this.initInventory();
                InventoryUtil.readInventoryToNBT(compound, "Inventory", this.inventory);
            }
        }
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Chest", this.hasChest());
        if (this.hasChest() && this.inventory != null) {
            InventoryUtil.writeInventoryToNBT(compound, "Inventory", (IInventory)this.inventory);
        }
    }

    @Override
    public boolean hasChest() {
        return (Boolean)this.field_70180_af.func_187225_a(CHEST);
    }

    public void setChest(boolean chest) {
        this.field_70180_af.func_187227_b(CHEST, (Object)chest);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean processHit(EntityRaytracer.RayTraceResultRotated result, boolean rightClick) {
        if (rightClick) {
            EntityRaytracer.RayTracePart partHit = result.getPartHit();
            if (partHit == CHEST_BOX && this.hasChest()) {
                PacketHandler.instance.sendToServer((Object)new MessageOpenStorage(this.func_145782_y()));
                Minecraft.func_71410_x().field_71439_g.func_184609_a(Hand.MAIN_HAND);
                return true;
            }
            if (partHit == TRAY_BOX && !this.hasChest()) {
                PacketHandler.instance.sendToServer((Object)new MessageAttachChest(this.func_145782_y()));
                return true;
            }
        }
        return EntityRaytracer.IEntityRaytraceable.super.processHit(result, rightClick);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Map<EntityRaytracer.RayTracePart, EntityRaytracer.TriangleRayTraceList> getStaticInteractionBoxMap() {
        return interactionBoxMapStatic;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<EntityRaytracer.RayTracePart> getApplicableInteractionBoxes() {
        ArrayList boxes = Lists.newArrayList();
        if (this.hasChest()) {
            boxes.add(CHEST_BOX);
        } else {
            boxes.add(TRAY_BOX);
        }
        return boxes;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInteractionBoxes(Tessellator tessellator, BufferBuilder buffer) {
    }

    private void initInventory() {
        StorageInventory original = this.inventory;
        this.inventory = new StorageInventory(this, 27);
        if (original != null) {
            for (int i = 0; i < original.func_70302_i_(); ++i) {
                ItemStack stack = original.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                this.inventory.func_70299_a(i, stack.func_77946_l());
            }
        }
    }

    @Override
    protected void onVehicleDestroyed(LivingEntity entity) {
        super.onVehicleDestroyed(entity);
        if (this.hasChest() && this.inventory != null) {
            InventoryHelper.func_180176_a((World)this.field_70170_p, (Entity)this, (IInventory)this.inventory);
        }
    }

    @Override
    @Nullable
    public StorageInventory getInventory() {
        if (this.hasChest() && this.inventory == null) {
            this.initInventory();
        }
        return this.inventory;
    }

    @Override
    public void attachChest(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae)) {
            CompoundNBT blockEntityTag;
            this.setChest(true);
            this.initInventory();
            CompoundNBT itemTag = stack.func_77978_p();
            if (itemTag != null && !(blockEntityTag = itemTag.func_74775_l("BlockEntityTag")).isEmpty() && blockEntityTag.func_150297_b("Items", 9)) {
                NonNullList chestInventory = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
                ItemStackHelper.func_191283_b((CompoundNBT)blockEntityTag, (NonNullList)chestInventory);
                for (int i = 0; i < chestInventory.size(); ++i) {
                    this.inventory.func_70299_a(i, (ItemStack)chestInventory.get(i));
                }
            }
        }
    }

    @Override
    public void removeChest() {
        if (this.inventory != null) {
            Vec3d target = new Vec3d(0.0, 0.75, -0.75).func_178785_b(-(this.field_70177_z - this.additionalYaw) * ((float)Math.PI / 180)).func_178787_e(this.func_174791_d());
            InventoryUtil.dropInventoryItems(this.field_70170_p, target.field_72450_a, target.field_72448_b, target.field_72449_c, (IInventory)this.inventory);
            this.inventory = null;
            this.setChest(false);
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, target.field_72450_a, target.field_72448_b, target.field_72449_c, new ItemStack((IItemProvider)Blocks.field_150486_ae)));
        }
    }

    @Override
    public boolean isLockable() {
        return false;
    }

    @Override
    public ITextComponent getStorageName() {
        return this.func_145748_c_();
    }

    @Override
    public void func_174889_b(PlayerEntity player) {
        Vec3d target = new Vec3d(0.0, 0.75, -0.75).func_178785_b(-(this.field_70177_z - this.additionalYaw) * ((float)Math.PI / 180)).func_178787_e(this.func_174791_d());
        this.field_70170_p.func_184148_a(null, target.field_72450_a, target.field_72448_b, target.field_72449_c, SoundEvents.field_187657_V, this.func_184176_by(), 0.5f, 0.9f);
    }
}

