/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity.vehicle;

import com.mrcrayfish.vehicle.client.EntityRaytracer;
import com.mrcrayfish.vehicle.entity.EngineType;
import com.mrcrayfish.vehicle.entity.PlaneEntity;
import com.mrcrayfish.vehicle.init.ModSounds;
import net.minecraft.entity.EntityType;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class SportsPlaneEntity
extends PlaneEntity
implements EntityRaytracer.IEntityRaytraceable {
    public float wheelSpeed;
    public float wheelRotation;
    public float prevWheelRotation;
    public float propellerSpeed;
    public float propellerRotation;
    public float prevPropellerRotation;

    public SportsPlaneEntity(EntityType<? extends SportsPlaneEntity> type, World worldIn) {
        super(type, worldIn);
        this.setAccelerationSpeed(0.5f);
        this.setMaxSpeed(25.0f);
        this.setMaxTurnAngle(25);
        this.setTurnSensitivity(2);
        this.setFuelCapacity(75000.0f);
        this.setFuelConsumption(1.0f);
    }

    @Override
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_186662_g(1.5);
    }

    @Override
    public void updateVehicle() {
        this.prevWheelRotation = this.wheelRotation;
        this.prevPropellerRotation = this.propellerRotation;
        this.wheelSpeed = this.field_70122_E ? this.currentSpeed / 30.0f : (this.wheelSpeed *= 0.95f);
        this.wheelRotation -= 90.0f * this.wheelSpeed;
        if (this.canDrive() && this.func_184179_bs() != null) {
            this.propellerSpeed += 1.0f;
            if (this.propellerSpeed > 120.0f) {
                this.propellerSpeed = 120.0f;
            }
        } else {
            this.propellerSpeed *= 0.95f;
        }
        this.propellerRotation += this.propellerSpeed;
    }

    @Override
    public SoundEvent getMovingSound() {
        return (SoundEvent)ModSounds.SPORTS_PLANE_ENGINE_MONO.get();
    }

    @Override
    public SoundEvent getRidingSound() {
        return (SoundEvent)ModSounds.SPORTS_PLANE_ENGINE_STEREO.get();
    }

    @Override
    public EngineType getEngineType() {
        return EngineType.LARGE_MOTOR;
    }

    @Override
    public boolean canBeColored() {
        return true;
    }

    @Override
    protected float getModifiedAccelerationSpeed() {
        return super.getModifiedAccelerationSpeed() * (this.propellerSpeed / 120.0f);
    }

    @Override
    public boolean canMountTrailer() {
        return false;
    }
}

