/*
 * Decompiled with CFR 0.152.
 */
package genandnic.walljump;

import genandnic.walljump.client.PlayerDoubleJump;
import genandnic.walljump.client.PlayerSpeedBoost;
import genandnic.walljump.client.PlayerWallJump;
import genandnic.walljump.proxy.ClientProxy;
import net.minecraftforge.common.config.Config;

@Config(modid="walljump")
public class WallJumpConfig {
    @Config.Ignore
    public static boolean isRemote = false;
    @Config.Comment(value={"Allows you to climb up without alternating walls"})
    public static boolean allowReClinging = false;
    @Config.Comment(value={"Automatically turn the player when wall clinging"})
    public static boolean autoRotation = false;
    @Config.Comment(value={"A list of blocks that cannot be clinged to"})
    public static String[] blacklistedBlocks = new String[]{"minecraft:block"};
    @Config.RangeDouble(min=0.0, max=3.0)
    @Config.Comment(value={"Elytra speed boost; set to 0.0 to disable"})
    public static double elytraSpeedBoost = 0.0;
    @Config.Comment(value={"Enable Wall-Jump enchantments in the enchanting table"})
    public static boolean enableEnchantments = true;
    @Config.RangeDouble(min=0.0, max=3.0)
    @Config.Comment(value={"Exhaustion gained per wall jump"})
    public static double exhaustionWallJump = 0.75;
    @Config.Comment(value={"Turns the blacklisted block list into a whitelist"})
    public static boolean invertBlockBlacklist = false;
    @Config.RangeDouble(min=3.0)
    @Config.Comment(value={"Minimum distance for fall damage; set to 3.0 to disable"})
    public static double minFallDistance = 7.5;
    @Config.Comment(value={"Play a rush of wind as you fall to your doom"})
    public static boolean playFallSound = true;
    @Config.RangeDouble(min=0.0, max=3.0)
    @Config.Comment(value={"Sprint speed boost; set to 0.0 to disable"})
    public static double sprintSpeedBoost = 0.0;
    @Config.Comment(value={"Walk up steps even while airborne, also jump over fences"})
    public static boolean stepAssist = true;
    @Config.Comment(value={"Allows you to jump in mid-air"})
    public static boolean useDoubleJump = false;
    @Config.Comment(value={"Allows you to wall cling and wall jump"})
    public static boolean useWallJump = true;
    @Config.RangeDouble(min=0.0, max=1.0)
    @Config.Comment(value={"Distance jumped during a wall jump"})
    public static double wallJumpBoost = 0.55;
    @Config.RangeInt(min=0)
    @Config.Comment(value={"Ticks wall clinged before a wall slide"})
    public static int wallSlideDelay = 15;

    public static void loadLocalConfig() {
        isRemote = false;
        ClientProxy.minFallDistance = minFallDistance;
        PlayerWallJump.useWallJump = useWallJump;
        PlayerWallJump.allowReClinging = allowReClinging;
        PlayerWallJump.wallJumpBoost = (float)wallJumpBoost;
        PlayerWallJump.wallSlideDelay = wallSlideDelay;
        PlayerDoubleJump.useDoubleJump = useDoubleJump;
        PlayerSpeedBoost.sprintSpeedBoost = (float)sprintSpeedBoost;
        PlayerSpeedBoost.elytraSpeedBoost = (float)elytraSpeedBoost;
    }
}

