/*
 * Decompiled with CFR 0.152.
 */
package genandnic.walljump;

import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber
public class Config {
    static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading event) {
    }

    @SubscribeEvent
    public static void onReload(ModConfig.ConfigReloading event) {
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue allowReClinging;
        public final ForgeConfigSpec.BooleanValue autoRotation;
        public final ForgeConfigSpec.DoubleValue elytraSpeedBoost;
        public final ForgeConfigSpec.DoubleValue exhaustionWallJump;
        public final ForgeConfigSpec.DoubleValue minFallDistance;
        public final ForgeConfigSpec.BooleanValue playFallSound;
        public final ForgeConfigSpec.DoubleValue sprintSpeedBoost;
        public final ForgeConfigSpec.BooleanValue stepAssist;
        public final ForgeConfigSpec.BooleanValue useDoubleJump;
        public final ForgeConfigSpec.BooleanValue useWallJump;
        public final ForgeConfigSpec.DoubleValue wallJumpHeight;
        public final ForgeConfigSpec.IntValue wallSlideDelay;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common configuration settings").push("common");
            this.allowReClinging = builder.comment("Allows you to climb up without alternating walls").define("allowReClinging", false);
            this.autoRotation = builder.comment("Automatically turn the player when wall clinging").define("autoRotation", false);
            this.elytraSpeedBoost = builder.comment("Elytra speed boost; set to 0.0 to disable").defineInRange("elytraSpeedBoost", 0.0, 0.0, 3.0);
            this.exhaustionWallJump = builder.comment("Exhaustion gained per wall jump").defineInRange("exhaustionWallJump", 0.75, 0.0, 3.0);
            this.minFallDistance = builder.comment("Minimum distance for fall damage; set to 3.0 to disable").defineInRange("minFallDistance", 7.5, 3.0, 256.0);
            this.playFallSound = builder.comment("Play a rush of wind as you fall to your doom").define("playFallSound", true);
            this.sprintSpeedBoost = builder.comment("Sprint speed boost; set to 0.0 to disable").defineInRange("sprintSpeedBoost", 0.0, 0.0, 3.0);
            this.stepAssist = builder.comment("Walk up steps even while airborne, also jump over fences").define("stepAssist", true);
            this.useDoubleJump = builder.comment("Allows you to jump in mid-air").define("useDoubleJump", false);
            this.useWallJump = builder.comment("Allows you to wall cling and wall jump").define("useWallJump", true);
            this.wallJumpHeight = builder.defineInRange("wallJumpHeight", 0.55, 0.5, 1.0);
            this.wallSlideDelay = builder.comment("Ticks wall clinged before starting wall slide").defineInRange("wallSlideDelay", 15, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

