/*
 * Decompiled with CFR 0.152.
 */
package genandnic.walljump.client;

import genandnic.walljump.Config;
import genandnic.walljump.WallJump;
import genandnic.walljump.network.PacketHandler;
import genandnic.walljump.network.message.MessageFallDistance;
import genandnic.walljump.network.message.MessageWallJump;
import genandnic.walljump.proxy.ClientProxy;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WallJumpLogic {
    public static int ticksWallClinged;
    private static int ticksKeyDown;
    private static double clingX;
    private static double clingZ;
    private static double lastJumpY;
    private static Set<Direction> walls;
    private static Set<Direction> staleWalls;

    public static void doWallJump(AbstractClientPlayerEntity pl) {
        if (!WallJumpLogic.canWallJump((PlayerEntity)pl)) {
            return;
        }
        if (pl.func_233570_aj_() || pl.field_71075_bZ.field_75100_b || pl.func_70090_H()) {
            ticksWallClinged = 0;
            clingX = Double.NaN;
            clingZ = Double.NaN;
            lastJumpY = Double.MAX_VALUE;
            staleWalls.clear();
            return;
        }
        WallJumpLogic.updateWalls(pl);
        int n = ticksKeyDown = ClientProxy.KEY_WALLJUMP.func_151470_d() ? ticksKeyDown + 1 : 0;
        if (ticksWallClinged < 1) {
            if (ticksKeyDown > 0 && ticksKeyDown < 4 && !walls.isEmpty() && WallJumpLogic.canWallCling(pl)) {
                pl.field_70721_aZ = 2.5f;
                if (((Boolean)Config.COMMON.autoRotation.get()).booleanValue()) {
                    pl.field_70177_z = WallJumpLogic.getClingDirection().func_176734_d().func_185119_l();
                }
                ticksWallClinged = 1;
                clingX = pl.func_213303_ch().field_72450_a;
                clingZ = pl.func_213303_ch().field_72449_c;
                WallJumpLogic.playHitSound((Entity)pl, WallJumpLogic.getWallPos(pl));
                WallJumpLogic.spawnWallParticle((Entity)pl, WallJumpLogic.getWallPos(pl));
            }
            return;
        }
        if (!ClientProxy.KEY_WALLJUMP.func_151470_d() || pl.func_233570_aj_() || pl.func_70090_H() || walls.isEmpty() || pl.func_71024_bL().func_75116_a() < 1) {
            ticksWallClinged = 0;
            if (!(pl.field_191988_bg == 0.0f && pl.field_70702_br == 0.0f || pl.func_233570_aj_() || walls.isEmpty())) {
                pl.field_70143_R = 0.0f;
                PacketHandler.instance.sendToServer((Object)new MessageWallJump());
                WallJumpLogic.wallJump(pl, ((Double)Config.COMMON.wallJumpHeight.get()).floatValue());
                staleWalls = new HashSet<Direction>(walls);
            }
            return;
        }
        if (((Boolean)Config.COMMON.autoRotation.get()).booleanValue()) {
            pl.field_70177_z = WallJumpLogic.getClingDirection().func_176734_d().func_185119_l();
        }
        pl.func_70107_b(clingX, pl.func_213303_ch().field_72448_b, clingZ);
        Double motionY = pl.func_213322_ci().field_72448_b;
        if (motionY > 0.0) {
            motionY = 0.0;
        } else if (motionY < -0.6) {
            motionY = motionY + 0.2;
            WallJumpLogic.spawnWallParticle((Entity)pl, WallJumpLogic.getWallPos(pl));
        } else if (ticksWallClinged++ > (Integer)Config.COMMON.wallSlideDelay.get()) {
            motionY = -0.1;
            WallJumpLogic.spawnWallParticle((Entity)pl, WallJumpLogic.getWallPos(pl));
        } else {
            motionY = 0.0;
        }
        if (pl.field_70143_R > 2.0f) {
            pl.field_70143_R = 0.0f;
            PacketHandler.instance.sendToServer((Object)new MessageFallDistance((float)(motionY * motionY * 8.0)));
        }
        pl.func_213293_j(0.0, motionY.doubleValue(), 0.0);
    }

    private static boolean canWallJump(PlayerEntity pl) {
        if (((Boolean)Config.COMMON.useWallJump.get()).booleanValue()) {
            return true;
        }
        ItemStack stack = pl.func_184582_a(EquipmentSlotType.FEET);
        if (!stack.func_190926_b()) {
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
            return enchantments.containsKey(WallJump.WALLJUMP_ENCHANT);
        }
        return false;
    }

    private static boolean canWallCling(AbstractClientPlayerEntity pl) {
        if (pl.func_70617_f_() || pl.func_213322_ci().field_72448_b > 0.1 || pl.func_71024_bL().func_75116_a() < 1) {
            return false;
        }
        if (ClientProxy.collidesWithBlock(pl.field_70170_p, pl.func_174813_aQ().func_72317_d(0.0, -0.8, 0.0))) {
            return false;
        }
        if (((Boolean)Config.COMMON.allowReClinging.get()).booleanValue() || pl.func_213303_ch().field_72448_b < lastJumpY - 1.0) {
            return true;
        }
        return !staleWalls.containsAll(walls);
    }

    private static void updateWalls(AbstractClientPlayerEntity pl) {
        Vector3d pos = pl.func_213303_ch();
        AxisAlignedBB box = new AxisAlignedBB(pos.field_72450_a - 0.001, pos.field_72448_b, pos.field_72449_c - 0.001, pos.field_72450_a + 0.001, pos.field_72448_b + (double)pl.func_70047_e(), pos.field_72449_c + 0.001);
        double dist = (double)(pl.func_213311_cf() / 2.0f) + (ticksWallClinged > 0 ? 0.1 : 0.06);
        AxisAlignedBB[] axes = new AxisAlignedBB[]{box.func_72321_a(0.0, 0.0, dist), box.func_72321_a(-dist, 0.0, 0.0), box.func_72321_a(0.0, 0.0, -dist), box.func_72321_a(dist, 0.0, 0.0)};
        int i = 0;
        Direction direction = Direction.UP;
        walls = new HashSet<Direction>();
        for (AxisAlignedBB axis : axes) {
            direction = Direction.func_176731_b((int)i++);
            if (!ClientProxy.collidesWithBlock(pl.field_70170_p, axis)) continue;
            walls.add(direction);
            pl.field_70123_F = true;
        }
    }

    private static Direction getClingDirection() {
        return walls.isEmpty() ? Direction.UP : walls.iterator().next();
    }

    private static BlockPos getWallPos(AbstractClientPlayerEntity player) {
        BlockPos pos = player.func_233580_cy_().func_177972_a(WallJumpLogic.getClingDirection());
        return player.field_70170_p.func_180495_p(pos).func_185904_a().func_76220_a() ? pos : pos.func_177972_a(Direction.UP);
    }

    private static void wallJump(AbstractClientPlayerEntity pl, float up) {
        float strafe = Math.signum(pl.field_70702_br) * up * up;
        float forward = Math.signum(pl.field_191988_bg) * up * up;
        float f = 1.0f / MathHelper.func_76129_c((float)(strafe * strafe + up * up + forward * forward));
        strafe *= f;
        forward *= f;
        float f1 = MathHelper.func_76126_a((float)(pl.field_70177_z * ((float)Math.PI / 180))) * 0.45f;
        float f2 = MathHelper.func_76134_b((float)(pl.field_70177_z * ((float)Math.PI / 180))) * 0.45f;
        int jumpBoostLevel = 0;
        EffectInstance jumpBoostEffect = pl.func_70660_b(Effect.func_188412_a((int)8));
        if (jumpBoostEffect != null) {
            jumpBoostLevel = jumpBoostEffect.func_76458_c() + 1;
        }
        Vector3d motion = pl.func_213322_ci();
        pl.func_213293_j(motion.field_72450_a + (double)(strafe * f2 - forward * f1), (double)up + (double)jumpBoostLevel * 0.125, motion.field_72449_c + (double)(forward * f2 + strafe * f1));
        lastJumpY = pl.func_213303_ch().field_72448_b;
        WallJumpLogic.playBreakSound((Entity)pl, WallJumpLogic.getWallPos(pl));
        WallJumpLogic.spawnWallParticle((Entity)pl, WallJumpLogic.getWallPos(pl));
    }

    private static void playHitSound(Entity entity, BlockPos pos) {
        BlockState state = entity.field_70170_p.func_180495_p(pos);
        SoundType soundtype = state.func_177230_c().getSoundType(state, (IWorldReader)entity.field_70170_p, pos, entity);
        entity.func_184185_a(soundtype.func_185846_f(), soundtype.func_185843_a() * 0.25f, soundtype.func_185847_b());
    }

    private static void playBreakSound(Entity entity, BlockPos pos) {
        BlockState state = entity.field_70170_p.func_180495_p(pos);
        SoundType soundtype = state.func_177230_c().getSoundType(state, (IWorldReader)entity.field_70170_p, pos, entity);
        entity.func_184185_a(soundtype.func_185842_g(), soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b());
    }

    private static <Vec3i> void spawnWallParticle(Entity entity, BlockPos blockPos) {
        BlockState state = entity.field_70170_p.func_180495_p(blockPos);
        if (state.func_185901_i() != BlockRenderType.INVISIBLE) {
            Vector3d pos = entity.func_213303_ch();
            Vector3i motion = WallJumpLogic.getClingDirection().func_176730_m();
            entity.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, state).setPos(blockPos), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, (double)motion.func_177958_n() * -1.0, -1.0, (double)motion.func_177952_p() * -1.0);
        }
    }

    static {
        lastJumpY = Double.MAX_VALUE;
        walls = new HashSet<Direction>();
        staleWalls = new HashSet<Direction>();
    }
}

