/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.SelectionCommands;
import com.sk89q.worldedit.command.argument.SelectorChoice;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.internal.annotation.MultiDirection;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandPart;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class SelectionCommandsRegistration
implements CommandRegistration<SelectionCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<BlockVector3> blockVector3_Key = Key.of(BlockVector3.class);
    private static final Key<BlockVector2> blockVector2_Key = Key.of(BlockVector2.class);
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<BlockVector3> blockVector3_multiDirection_Key = Key.of(BlockVector3.class, MultiDirection.class);
    private static final Key<Mask> mask_Key = Key.of(Mask.class);
    private static final Key<SelectorChoice> selectorChoice_Key = Key.of(SelectorChoice.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private static final Key<EditSession> editSession_Key = Key.of(EditSession.class);
    private CommandManager commandManager;
    private SelectionCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument coordinatesPart = CommandParts.arg(TranslatableComponent.of("coordinates"), TextComponent.of("Coordinates to set position 1 to")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"")).ofTypes((Collection<Key<?>>)ImmutableList.of(blockVector3_Key)).build();
    private final CommandArgument coordinatesPart2 = CommandParts.arg(TranslatableComponent.of("coordinates"), TextComponent.of("Coordinates to set position 2 to")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"")).ofTypes((Collection<Key<?>>)ImmutableList.of(blockVector3_Key)).build();
    private final CommandArgument coordinatesPart3 = CommandParts.arg(TranslatableComponent.of("coordinates"), TextComponent.of("The chunk to select")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"")).ofTypes((Collection<Key<?>>)ImmutableList.of(blockVector2_Key)).build();
    private final NoArgCommandFlag expandSelectionPart = CommandParts.flag('s', TextComponent.of("Expand your selection to encompass all chunks that are part of it")).build();
    private final NoArgCommandFlag useChunkCoordinatesPart = CommandParts.flag('c', TextComponent.of("Use chunk coordinates instead of block coordinates")).build();
    private final NoArgCommandFlag navWandPart = CommandParts.flag('n', TextComponent.of("Get a navigation wand")).build();
    private final CommandArgument amountPart = CommandParts.arg(TranslatableComponent.of("amount"), TextComponent.of("Amount to contract the selection by")).defaultsTo((Iterable<String>)ImmutableList.of()).ofTypes((Collection<Key<?>>)ImmutableList.of(integer_Key)).build();
    private final CommandArgument reverseAmountPart = CommandParts.arg(TranslatableComponent.of("reverseAmount"), TextComponent.of("Amount to contract the selection by in the other direction")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"0")).ofTypes((Collection<Key<?>>)ImmutableList.of(integer_Key)).build();
    private final CommandArgument directionPart = CommandParts.arg(TranslatableComponent.of("direction"), TextComponent.of("Direction to contract")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"me")).ofTypes((Collection<Key<?>>)ImmutableList.of(blockVector3_multiDirection_Key)).build();
    private final CommandArgument amountPart2 = CommandParts.arg(TranslatableComponent.of("amount"), TextComponent.of("Amount to shift the selection by")).defaultsTo((Iterable<String>)ImmutableList.of()).ofTypes((Collection<Key<?>>)ImmutableList.of(integer_Key)).build();
    private final CommandArgument amountPart3 = CommandParts.arg(TranslatableComponent.of("amount"), TextComponent.of("Amount to expand the selection by in all directions")).defaultsTo((Iterable<String>)ImmutableList.of()).ofTypes((Collection<Key<?>>)ImmutableList.of(integer_Key)).build();
    private final NoArgCommandFlag onlyHorizontalPart = CommandParts.flag('h', TextComponent.of("Only expand horizontally")).build();
    private final NoArgCommandFlag onlyVerticalPart = CommandParts.flag('v', TextComponent.of("Only expand vertically")).build();
    private final CommandArgument amountPart4 = CommandParts.arg(TranslatableComponent.of("amount"), TextComponent.of("Amount to contract the selection by in all directions")).defaultsTo((Iterable<String>)ImmutableList.of()).ofTypes((Collection<Key<?>>)ImmutableList.of(integer_Key)).build();
    private final NoArgCommandFlag onlyHorizontalPart2 = CommandParts.flag('h', TextComponent.of("Only contract horizontally")).build();
    private final NoArgCommandFlag onlyVerticalPart2 = CommandParts.flag('v', TextComponent.of("Only contract vertically")).build();
    private final NoArgCommandFlag clipboardInfoPart = CommandParts.flag('c', TextComponent.of("Get clipboard info instead")).build();
    private final CommandArgument maskPart = CommandParts.arg(TranslatableComponent.of("mask"), TextComponent.of("The mask of blocks to match")).defaultsTo((Iterable<String>)ImmutableList.of()).ofTypes((Collection<Key<?>>)ImmutableList.of(mask_Key)).build();
    private final NoArgCommandFlag clipboardDistrPart = CommandParts.flag('c', TextComponent.of("Get the distribution of the clipboard instead")).build();
    private final NoArgCommandFlag separateStatesPart = CommandParts.flag('d', TextComponent.of("Separate blocks by state")).build();
    private final ArgAcceptingCommandFlag pagePart = CommandParts.flag('p', TextComponent.of("Gets page from a previous distribution.")).withRequiredArg().argNamed(TranslatableComponent.of("page")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"")).ofTypes((Collection<Key<?>>)ImmutableList.of(integer_Key)).build();
    private final CommandArgument selectorPart = CommandParts.arg(TranslatableComponent.of("selector"), TextComponent.of("Selector to switch to")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"")).ofTypes((Collection<Key<?>>)ImmutableList.of(selectorChoice_Key)).build();
    private final NoArgCommandFlag setDefaultSelectorPart = CommandParts.flag('d', TextComponent.of("Set default selector")).build();

    private SelectionCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static SelectionCommandsRegistration builder() {
        return new SelectionCommandsRegistration();
    }

    public SelectionCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public SelectionCommandsRegistration containerInstance(SelectionCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public SelectionCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public SelectionCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    @Override
    public void build() {
        this.commandManager.register("/pos1", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Set position 1"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.coordinatesPart));
            b.action(this::_pos1);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "pos1", Player.class, LocalSession.class, BlockVector3.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/pos2", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Set position 2"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.coordinatesPart2));
            b.action(this::_pos2);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "pos2", Player.class, LocalSession.class, BlockVector3.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/hpos1", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Set position 1 to targeted block"));
            b.parts((Collection<CommandPart>)ImmutableList.of());
            b.action(this::_hpos1);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "hpos1", Player.class, LocalSession.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/hpos2", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Set position 2 to targeted block"));
            b.parts((Collection<CommandPart>)ImmutableList.of());
            b.action(this::_hpos2);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "hpos2", Player.class, LocalSession.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/chunk", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Set the selection to your current chunk."));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.coordinatesPart3, (Object)this.expandSelectionPart, (Object)this.useChunkCoordinatesPart));
            b.action(this::_chunk);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "chunk", Player.class, LocalSession.class, BlockVector2.class, Boolean.TYPE, Boolean.TYPE);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/wand", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Get the wand object"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.navWandPart));
            b.action(this::_wand);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "wand", Player.class, LocalSession.class, Boolean.TYPE);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("toggleeditwand", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Remind the user that the wand is now a tool and can be unbound with /none."));
            b.parts((Collection<CommandPart>)ImmutableList.of());
            b.action(this::toggleeditwand);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "toggleWand", Player.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/contract", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Contract the selection area"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.amountPart, (Object)this.reverseAmountPart, (Object)this.directionPart));
            b.action(this::_contract);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "contract", Player.class, LocalSession.class, Integer.TYPE, Integer.TYPE, List.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/shift", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Shift the selection area"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.amountPart2, (Object)this.directionPart));
            b.action(this::_shift);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "shift", Player.class, LocalSession.class, Integer.TYPE, List.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/outset", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Outset the selection area"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.amountPart3, (Object)this.onlyHorizontalPart, (Object)this.onlyVerticalPart));
            b.action(this::_outset);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "outset", Player.class, LocalSession.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/inset", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Inset the selection area"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.amountPart4, (Object)this.onlyHorizontalPart2, (Object)this.onlyVerticalPart2));
            b.action(this::_inset);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "inset", Player.class, LocalSession.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/size", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Get information about the selection"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.clipboardInfoPart));
            b.action(this::_size);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "size", Player.class, LocalSession.class, Boolean.TYPE);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/count", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Counts the number of blocks matching a mask"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.maskPart));
            b.action(this::_count);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "count", Player.class, LocalSession.class, EditSession.class, Mask.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/distr", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Get the distribution of blocks in the selection"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.clipboardDistrPart, (Object)this.separateStatesPart, (Object)this.pagePart));
            b.action(this::_distr);
            Method commandMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "distr", Player.class, LocalSession.class, Boolean.TYPE, Boolean.TYPE, Integer.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/sel", b -> {
            b.aliases((Collection<String>)ImmutableList.of((Object)";", (Object)"/desel", (Object)"/deselect"));
            b.description(TextComponent.of("Choose a region selector"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.selectorPart, (Object)this.setDefaultSelectorPart));
            b.action(this::_sel);
        });
    }

    private int _pos1(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "pos1", Player.class, LocalSession.class, BlockVector3.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.pos1(this.player(parameters), this.session(parameters), this.coordinates(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _pos2(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "pos2", Player.class, LocalSession.class, BlockVector3.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.pos2(this.player(parameters), this.session(parameters), this.coordinates2(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _hpos1(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "hpos1", Player.class, LocalSession.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.hpos1(this.player(parameters), this.session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _hpos2(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "hpos2", Player.class, LocalSession.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.hpos2(this.player(parameters), this.session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _chunk(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "chunk", Player.class, LocalSession.class, BlockVector2.class, Boolean.TYPE, Boolean.TYPE);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.chunk(this.player(parameters), this.session(parameters), this.coordinates3(parameters), this.expandSelection(parameters), this.useChunkCoordinates(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _wand(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "wand", Player.class, LocalSession.class, Boolean.TYPE);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.wand(this.player(parameters), this.session(parameters), this.navWand(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int toggleeditwand(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "toggleWand", Player.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.toggleWand(this.player(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _contract(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "contract", Player.class, LocalSession.class, Integer.TYPE, Integer.TYPE, List.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.contract(this.player(parameters), this.session(parameters), this.amount(parameters), this.reverseAmount(parameters), this.direction(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _shift(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "shift", Player.class, LocalSession.class, Integer.TYPE, List.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.shift(this.player(parameters), this.session(parameters), this.amount2(parameters), this.direction(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _outset(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "outset", Player.class, LocalSession.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.outset(this.player(parameters), this.session(parameters), this.amount3(parameters), this.onlyHorizontal(parameters), this.onlyVertical(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _inset(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "inset", Player.class, LocalSession.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.inset(this.player(parameters), this.session(parameters), this.amount4(parameters), this.onlyHorizontal2(parameters), this.onlyVertical2(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _size(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "size", Player.class, LocalSession.class, Boolean.TYPE);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.size(this.player(parameters), this.session(parameters), this.clipboardInfo(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _count(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "count", Player.class, LocalSession.class, EditSession.class, Mask.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.count(this.player(parameters), this.session(parameters), this.editSession(parameters), this.mask(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _distr(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "distr", Player.class, LocalSession.class, Boolean.TYPE, Boolean.TYPE, Integer.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.distr(this.player(parameters), this.session(parameters), this.clipboardDistr(parameters), this.separateStates(parameters), this.page(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int _sel(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SelectionCommands.class, "select", Player.class, LocalSession.class, SelectorChoice.class, Boolean.TYPE);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.select(this.player(parameters), this.session(parameters), this.selector(parameters), this.setDefaultSelector(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private Player player(CommandParameters parameters) {
        return RegistrationUtil.requireOptional(player_Key, "player", parameters.injectedValue(player_Key));
    }

    private LocalSession session(CommandParameters parameters) {
        return RegistrationUtil.requireOptional(localSession_Key, "session", parameters.injectedValue(localSession_Key));
    }

    private BlockVector3 coordinates2(CommandParameters parameters) {
        return this.coordinatesPart2.value(parameters).asSingle(blockVector3_Key);
    }

    private boolean separateStates(CommandParameters parameters) {
        return this.separateStatesPart.in(parameters);
    }

    private BlockVector2 coordinates3(CommandParameters parameters) {
        return this.coordinatesPart3.value(parameters).asSingle(blockVector2_Key);
    }

    private int amount3(CommandParameters parameters) {
        return this.amountPart3.value(parameters).asSingle(integer_Key);
    }

    private boolean onlyHorizontal2(CommandParameters parameters) {
        return this.onlyHorizontalPart2.in(parameters);
    }

    private boolean onlyVertical2(CommandParameters parameters) {
        return this.onlyVerticalPart2.in(parameters);
    }

    private SelectorChoice selector(CommandParameters parameters) {
        return this.selectorPart.value(parameters).asSingle(selectorChoice_Key);
    }

    private int amount2(CommandParameters parameters) {
        return this.amountPart2.value(parameters).asSingle(integer_Key);
    }

    private boolean clipboardInfo(CommandParameters parameters) {
        return this.clipboardInfoPart.in(parameters);
    }

    private boolean setDefaultSelector(CommandParameters parameters) {
        return this.setDefaultSelectorPart.in(parameters);
    }

    private int reverseAmount(CommandParameters parameters) {
        return this.reverseAmountPart.value(parameters).asSingle(integer_Key);
    }

    private boolean onlyHorizontal(CommandParameters parameters) {
        return this.onlyHorizontalPart.in(parameters);
    }

    private BlockVector3 coordinates(CommandParameters parameters) {
        return this.coordinatesPart.value(parameters).asSingle(blockVector3_Key);
    }

    private Integer page(CommandParameters parameters) {
        return this.pagePart.value(parameters).asSingle(integer_Key);
    }

    private int amount(CommandParameters parameters) {
        return this.amountPart.value(parameters).asSingle(integer_Key);
    }

    private EditSession editSession(CommandParameters parameters) {
        return RegistrationUtil.requireOptional(editSession_Key, "editSession", parameters.injectedValue(editSession_Key));
    }

    private boolean onlyVertical(CommandParameters parameters) {
        return this.onlyVerticalPart.in(parameters);
    }

    private int amount4(CommandParameters parameters) {
        return this.amountPart4.value(parameters).asSingle(integer_Key);
    }

    private boolean useChunkCoordinates(CommandParameters parameters) {
        return this.useChunkCoordinatesPart.in(parameters);
    }

    private Mask mask(CommandParameters parameters) {
        return this.maskPart.value(parameters).asSingle(mask_Key);
    }

    private List<BlockVector3> direction(CommandParameters parameters) {
        return this.directionPart.value(parameters).asMultiple(blockVector3_multiDirection_Key);
    }

    private boolean clipboardDistr(CommandParameters parameters) {
        return this.clipboardDistrPart.in(parameters);
    }

    private boolean expandSelection(CommandParameters parameters) {
        return this.expandSelectionPart.in(parameters);
    }

    private boolean navWand(CommandParameters parameters) {
        return this.navWandPart.in(parameters);
    }
}

