/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.SnapshotCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Method;
import java.time.ZonedDateTime;
import java.util.Collection;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandPart;
import org.enginehub.piston.part.CommandParts;

public final class SnapshotCommandsRegistration
implements CommandRegistration<SnapshotCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<ZonedDateTime> zonedDateTime_Key = Key.of(ZonedDateTime.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private CommandManager commandManager;
    private SnapshotCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final ArgAcceptingCommandFlag pagePart = CommandParts.flag('p', TextComponent.of("Page of results to return")).withRequiredArg().argNamed(TranslatableComponent.of("page")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"1")).ofTypes((Collection<Key<?>>)ImmutableList.of(integer_Key)).build();
    private final CommandArgument namePart = CommandParts.arg(TranslatableComponent.of("name"), TextComponent.of("Snapeshot to use")).defaultsTo((Iterable<String>)ImmutableList.of()).ofTypes((Collection<Key<?>>)ImmutableList.of(string_Key)).build();
    private final CommandArgument indexPart = CommandParts.arg(TranslatableComponent.of("index"), TextComponent.of("The list ID to select")).defaultsTo((Iterable<String>)ImmutableList.of()).ofTypes((Collection<Key<?>>)ImmutableList.of(integer_Key)).build();
    private final CommandArgument datePart = CommandParts.arg(TranslatableComponent.of("date"), TextComponent.of("The soonest date that may be used")).defaultsTo((Iterable<String>)ImmutableList.of()).ofTypes((Collection<Key<?>>)ImmutableList.of(zonedDateTime_Key)).build();

    private SnapshotCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static SnapshotCommandsRegistration builder() {
        return new SnapshotCommandsRegistration();
    }

    public SnapshotCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public SnapshotCommandsRegistration containerInstance(SnapshotCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public SnapshotCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public SnapshotCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    @Override
    public void build() {
        this.commandManager.register("list", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("List snapshots"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.pagePart));
            b.action(this::list);
            Method commandMethod = RegistrationUtil.getCommandMethod(SnapshotCommands.class, "list", Player.class, Integer.TYPE);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("use", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Choose a snapshot to use"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.namePart));
            b.action(this::use);
            Method commandMethod = RegistrationUtil.getCommandMethod(SnapshotCommands.class, "use", Player.class, LocalSession.class, String.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("sel", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Choose the snapshot based on the list id"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.indexPart));
            b.action(this::sel);
            Method commandMethod = RegistrationUtil.getCommandMethod(SnapshotCommands.class, "sel", Player.class, LocalSession.class, Integer.TYPE);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("before", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Choose the nearest snapshot before a date"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.datePart));
            b.action(this::before);
            Method commandMethod = RegistrationUtil.getCommandMethod(SnapshotCommands.class, "before", Player.class, LocalSession.class, ZonedDateTime.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("after", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Choose the nearest snapshot after a date"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.datePart));
            b.action(this::after);
            Method commandMethod = RegistrationUtil.getCommandMethod(SnapshotCommands.class, "after", Player.class, LocalSession.class, ZonedDateTime.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int list(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SnapshotCommands.class, "list", Player.class, Integer.TYPE);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.list(this.player(parameters), this.page(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int use(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SnapshotCommands.class, "use", Player.class, LocalSession.class, String.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.use(this.player(parameters), this.session(parameters), this.name(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int sel(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SnapshotCommands.class, "sel", Player.class, LocalSession.class, Integer.TYPE);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.sel(this.player(parameters), this.session(parameters), this.index(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int before(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SnapshotCommands.class, "before", Player.class, LocalSession.class, ZonedDateTime.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.before(this.player(parameters), this.session(parameters), this.date(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int after(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SnapshotCommands.class, "after", Player.class, LocalSession.class, ZonedDateTime.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.after(this.player(parameters), this.session(parameters), this.date(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private ZonedDateTime date(CommandParameters parameters) {
        return this.datePart.value(parameters).asSingle(zonedDateTime_Key);
    }

    private Player player(CommandParameters parameters) {
        return RegistrationUtil.requireOptional(player_Key, "player", parameters.injectedValue(player_Key));
    }

    private String name(CommandParameters parameters) {
        return this.namePart.value(parameters).asSingle(string_Key);
    }

    private LocalSession session(CommandParameters parameters) {
        return RegistrationUtil.requireOptional(localSession_Key, "session", parameters.injectedValue(localSession_Key));
    }

    private int page(CommandParameters parameters) {
        return this.pagePart.value(parameters).asSingle(integer_Key);
    }

    private int index(CommandParameters parameters) {
        return this.indexPart.value(parameters).asSingle(integer_Key);
    }
}

