/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.fabric;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.fabric.FabricPlayer;
import com.sk89q.worldedit.fabric.FabricWorld;
import com.sk89q.worldedit.fabric.NBTConverter;
import com.sk89q.worldedit.fabric.PropertyAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.registry.state.BooleanProperty;
import com.sk89q.worldedit.registry.state.DirectionalProperty;
import com.sk89q.worldedit.registry.state.EnumProperty;
import com.sk89q.worldedit.registry.state.IntegerProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3542;

public final class FabricAdapter {
    private FabricAdapter() {
    }

    public static World adapt(class_1937 world) {
        return new FabricWorld(world);
    }

    public static class_1959 adapt(BiomeType biomeType) {
        return (class_1959)class_2378.field_11153.method_10223(new class_2960(biomeType.getId()));
    }

    public static BiomeType adapt(class_1959 biome) {
        return BiomeTypes.get(class_2378.field_11153.method_10221((Object)biome).toString());
    }

    public static Vector3 adapt(class_243 vector) {
        return Vector3.at(vector.field_1352, vector.field_1351, vector.field_1350);
    }

    public static BlockVector3 adapt(class_2338 pos) {
        return BlockVector3.at(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public static class_243 toVec3(BlockVector3 vector) {
        return new class_243((double)vector.getBlockX(), (double)vector.getBlockY(), (double)vector.getBlockZ());
    }

    public static class_2350 adapt(Direction face) {
        switch (face) {
            case NORTH: {
                return class_2350.field_11043;
            }
            case SOUTH: {
                return class_2350.field_11035;
            }
            case WEST: {
                return class_2350.field_11039;
            }
            case EAST: {
                return class_2350.field_11034;
            }
            case DOWN: {
                return class_2350.field_11033;
            }
        }
        return class_2350.field_11036;
    }

    public static Direction adaptEnumFacing(class_2350 face) {
        switch (face) {
            case field_11043: {
                return Direction.NORTH;
            }
            case field_11035: {
                return Direction.SOUTH;
            }
            case field_11039: {
                return Direction.WEST;
            }
            case field_11034: {
                return Direction.EAST;
            }
            case field_11033: {
                return Direction.DOWN;
            }
        }
        return Direction.UP;
    }

    public static class_2338 toBlockPos(BlockVector3 vector) {
        return new class_2338(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    public static Property<?> adaptProperty(class_2769<?> property) {
        if (property instanceof class_2746) {
            return new BooleanProperty(property.method_11899(), (List<Boolean>)ImmutableList.copyOf((Collection)((class_2746)property).method_11898()));
        }
        if (property instanceof class_2758) {
            return new IntegerProperty(property.method_11899(), (List<Integer>)ImmutableList.copyOf((Collection)((class_2758)property).method_11898()));
        }
        if (property instanceof class_2753) {
            return new DirectionalProperty(property.method_11899(), ((class_2753)property).method_11898().stream().map(FabricAdapter::adaptEnumFacing).collect(Collectors.toList()));
        }
        if (property instanceof class_2754) {
            return new EnumProperty(property.method_11899(), ((class_2754)property).method_11898().stream().map(x -> ((class_3542)x).method_15434()).collect(Collectors.toList()));
        }
        return new PropertyAdapter(property);
    }

    public static Map<Property<?>, Object> adaptProperties(BlockType block, Map<class_2769<?>, Comparable<?>> mcProps) {
        TreeMap props = new TreeMap(Comparator.comparing(Property::getName));
        for (Map.Entry<class_2769<?>, Comparable<?>> prop : mcProps.entrySet()) {
            Object value = prop.getValue();
            if (prop.getKey() instanceof class_2753) {
                value = FabricAdapter.adaptEnumFacing((class_2350)value);
            } else if (prop.getKey() instanceof class_2754) {
                value = ((class_3542)value).method_15434();
            }
            props.put(block.getProperty(prop.getKey().method_11899()), value);
        }
        return props;
    }

    private static class_2680 applyProperties(class_2689<class_2248, class_2680> stateContainer, class_2680 newState, Map<Property<?>, Object> states) {
        for (Map.Entry<Property<?>, Object> state : states.entrySet()) {
            class_2769 property = stateContainer.method_11663(state.getKey().getName());
            Comparable value = (Comparable)state.getValue();
            if (property instanceof class_2753) {
                Direction dir = (Direction)((Object)value);
                value = FabricAdapter.adapt(dir);
            } else if (property instanceof class_2754) {
                String enumName = (String)((Object)value);
                value = (Comparable)((Object)((class_2754)property).method_11900((String)((Object)value)).orElseGet(() -> {
                    throw new IllegalStateException("Enum property " + property.method_11899() + " does not contain " + enumName);
                }));
            }
            newState = (class_2680)newState.method_11657(property, value);
        }
        return newState;
    }

    public static class_2680 adapt(BlockState blockState) {
        class_2248 mcBlock = FabricAdapter.adapt(blockState.getBlockType());
        class_2680 newState = mcBlock.method_9564();
        Map<Property<?>, Object> states = blockState.getStates();
        return FabricAdapter.applyProperties((class_2689<class_2248, class_2680>)mcBlock.method_9595(), newState, states);
    }

    public static BlockState adapt(class_2680 blockState) {
        BlockType blockType = FabricAdapter.adapt(blockState.method_11614());
        return blockType.getState(FabricAdapter.adaptProperties(blockType, blockState.method_11656()));
    }

    public static class_2248 adapt(BlockType blockType) {
        return (class_2248)class_2378.field_11146.method_10223(new class_2960(blockType.getId()));
    }

    public static BlockType adapt(class_2248 block) {
        return BlockTypes.get(class_2378.field_11146.method_10221((Object)block).toString());
    }

    public static class_1792 adapt(ItemType itemType) {
        return (class_1792)class_2378.field_11142.method_10223(new class_2960(itemType.getId()));
    }

    public static ItemType adapt(class_1792 item) {
        return ItemTypes.get(class_2378.field_11142.method_10221((Object)item).toString());
    }

    public static class_1799 adapt(BaseItemStack baseItemStack) {
        class_2487 fabricCompound = null;
        if (baseItemStack.getNbtData() != null) {
            fabricCompound = NBTConverter.toNative(baseItemStack.getNbtData());
        }
        class_1799 itemStack = new class_1799((class_1935)FabricAdapter.adapt(baseItemStack.getType()), baseItemStack.getAmount());
        itemStack.method_7980(fabricCompound);
        return itemStack;
    }

    public static BaseItemStack adapt(class_1799 itemStack) {
        Tag tagTag;
        CompoundTag tag = NBTConverter.fromNative(itemStack.method_7953(new class_2487()));
        tag = tag.getValue().isEmpty() ? null : ((tagTag = (Tag)tag.getValue().get("tag")) instanceof CompoundTag ? (CompoundTag)tagTag : null);
        return new BaseItemStack(FabricAdapter.adapt(itemStack.method_7909()), tag, itemStack.method_7947());
    }

    public static FabricPlayer adaptPlayer(class_3222 player) {
        Preconditions.checkNotNull((Object)player);
        return new FabricPlayer(player);
    }
}

