/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.fabric;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.entity.metadata.EntityProperties;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.fabric.FabricAdapter;
import com.sk89q.worldedit.fabric.FabricEntityProperties;
import com.sk89q.worldedit.fabric.NBTConverter;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.NullWorld;
import com.sk89q.worldedit.world.entity.EntityTypes;
import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

class FabricEntity
implements Entity {
    private final WeakReference<class_1297> entityRef;

    FabricEntity(class_1297 entity) {
        Preconditions.checkNotNull((Object)entity);
        this.entityRef = new WeakReference<class_1297>(entity);
    }

    @Override
    public BaseEntity getState() {
        class_1297 entity = (class_1297)this.entityRef.get();
        if (entity != null) {
            class_2960 id = class_2378.field_11145.method_10221((Object)entity.method_5864());
            class_2487 tag = new class_2487();
            entity.method_5647(tag);
            return new BaseEntity(EntityTypes.get(id.toString()), NBTConverter.fromNative(tag));
        }
        return null;
    }

    @Override
    public Location getLocation() {
        class_1297 entity = (class_1297)this.entityRef.get();
        if (entity != null) {
            Vector3 position = Vector3.at(entity.field_5987, entity.field_6010, entity.field_6035);
            float yaw = entity.field_6031;
            float pitch = entity.field_5965;
            return new Location((Extent)FabricAdapter.adapt(entity.field_6002), position, yaw, pitch);
        }
        return new Location(NullWorld.getInstance());
    }

    @Override
    public boolean setLocation(Location location) {
        return false;
    }

    @Override
    public Extent getExtent() {
        class_1297 entity = (class_1297)this.entityRef.get();
        if (entity != null) {
            return FabricAdapter.adapt(entity.field_6002);
        }
        return NullWorld.getInstance();
    }

    @Override
    public boolean remove() {
        class_1297 entity = (class_1297)this.entityRef.get();
        if (entity != null) {
            entity.method_5650();
        }
        return true;
    }

    @Override
    @Nullable
    public <T> T getFacet(Class<? extends T> cls) {
        class_1297 entity = (class_1297)this.entityRef.get();
        if (entity != null) {
            if (EntityProperties.class.isAssignableFrom(cls)) {
                return (T)new FabricEntityProperties(entity);
            }
            return null;
        }
        return null;
    }
}

