/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.fabric;

import com.mojang.brigadier.CommandDispatcher;
import com.sk89q.worldedit.command.util.PermissionCondition;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.AbstractPlatform;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.MultiUserPlatform;
import com.sk89q.worldedit.extension.platform.Preference;
import com.sk89q.worldedit.fabric.CommandWrapper;
import com.sk89q.worldedit.fabric.FabricConfiguration;
import com.sk89q.worldedit.fabric.FabricDataFixer;
import com.sk89q.worldedit.fabric.FabricPlayer;
import com.sk89q.worldedit.fabric.FabricRegistries;
import com.sk89q.worldedit.fabric.FabricWorld;
import com.sk89q.worldedit.fabric.FabricWorldEdit;
import com.sk89q.worldedit.world.DataFixer;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.registry.Registries;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_155;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;

class FabricPlatform
extends AbstractPlatform
implements MultiUserPlatform {
    private final FabricWorldEdit mod;
    private final MinecraftServer server;
    private final FabricDataFixer dataFixer;
    private boolean hookingEvents = false;

    FabricPlatform(FabricWorldEdit mod, MinecraftServer server) {
        this.mod = mod;
        this.server = server;
        this.dataFixer = new FabricDataFixer(this.getDataVersion());
    }

    boolean isHookingEvents() {
        return this.hookingEvents;
    }

    @Override
    public Registries getRegistries() {
        return FabricRegistries.getInstance();
    }

    @Override
    public int getDataVersion() {
        return class_155.method_16673().getWorldVersion();
    }

    @Override
    public DataFixer getDataFixer() {
        return this.dataFixer;
    }

    @Override
    public boolean isValidMobType(String type) {
        return class_2378.field_11145.method_10250(new class_2960(type));
    }

    @Override
    public void reload() {
        this.getConfiguration().load();
    }

    @Override
    public int schedule(long delay, long period, Runnable task) {
        return -1;
    }

    @Override
    public List<? extends World> getWorlds() {
        Iterable worlds = this.server.method_3738();
        ArrayList<FabricWorld> ret = new ArrayList<FabricWorld>();
        for (class_3218 world : worlds) {
            ret.add(new FabricWorld((class_1937)world));
        }
        return ret;
    }

    @Override
    @Nullable
    public Player matchPlayer(Player player) {
        if (player instanceof FabricPlayer) {
            return player;
        }
        class_3222 entity = this.server.method_3760().method_14566(player.getName());
        return entity != null ? new FabricPlayer(entity) : null;
    }

    @Override
    @Nullable
    public World matchWorld(World world) {
        if (world instanceof FabricWorld) {
            return world;
        }
        for (class_3218 ws : this.server.method_3738()) {
            if (!ws.method_8401().method_150().equals(world.getName())) continue;
            return new FabricWorld((class_1937)ws);
        }
        return null;
    }

    @Override
    public void registerCommands(CommandManager manager) {
        if (this.server == null) {
            return;
        }
        class_2170 mcMan = this.server.method_3734();
        for (Command command : manager.getAllCommands().collect(Collectors.toList())) {
            CommandWrapper.register((CommandDispatcher<class_2168>)mcMan.method_9235(), command);
            Set perms = command.getCondition().as(PermissionCondition.class).map(PermissionCondition::getPermissions).orElseGet(Collections::emptySet);
            if (perms.isEmpty()) continue;
            perms.forEach(FabricWorldEdit.inst.getPermissionsProvider()::registerPermission);
        }
    }

    @Override
    public void registerGameHooks() {
        this.hookingEvents = true;
    }

    @Override
    public FabricConfiguration getConfiguration() {
        return this.mod.getConfig();
    }

    @Override
    public String getVersion() {
        return this.mod.getInternalVersion();
    }

    @Override
    public String getPlatformName() {
        return "Fabric-Official";
    }

    @Override
    public String getPlatformVersion() {
        return this.mod.getInternalVersion();
    }

    @Override
    public Map<Capability, Preference> getCapabilities() {
        EnumMap<Capability, Preference> capabilities = new EnumMap<Capability, Preference>(Capability.class);
        capabilities.put(Capability.CONFIGURATION, Preference.PREFER_OTHERS);
        capabilities.put(Capability.WORLDEDIT_CUI, Preference.NORMAL);
        capabilities.put(Capability.GAME_HOOKS, Preference.NORMAL);
        capabilities.put(Capability.PERMISSIONS, Preference.NORMAL);
        capabilities.put(Capability.USER_COMMANDS, Preference.NORMAL);
        capabilities.put(Capability.WORLD_EDITING, Preference.PREFERRED);
        return capabilities;
    }

    @Override
    public Collection<Actor> getConnectedUsers() {
        ArrayList<Actor> users = new ArrayList<Actor>();
        class_3324 scm = this.server.method_3760();
        for (class_3222 entity : scm.method_14571()) {
            if (entity == null) continue;
            users.add(new FabricPlayer(entity));
        }
        return users;
    }
}

