/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.formatting.text;

import com.sk89q.worldedit.util.formatting.text.AbstractComponent;
import com.sk89q.worldedit.util.formatting.text.BuildableComponent;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.ComponentBuilder;
import com.sk89q.worldedit.util.formatting.text.event.ClickEvent;
import com.sk89q.worldedit.util.formatting.text.event.HoverEvent;
import com.sk89q.worldedit.util.formatting.text.format.Style;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import com.sk89q.worldedit.util.formatting.text.format.TextDecoration;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class AbstractComponentBuilder<C extends BuildableComponent<C, B>, B extends ComponentBuilder<C, B>>
implements ComponentBuilder<C, B> {
    protected List<Component> children = AbstractComponent.EMPTY_COMPONENT_LIST;
    private @Nullable Style style;
    private @MonotonicNonNull Style.Builder styleB;

    protected AbstractComponentBuilder() {
    }

    protected AbstractComponentBuilder(@NonNull C component) {
        this.children = new ArrayList<Component>(component.children());
        if (component.hasStyling()) {
            this.style = component.style();
        }
    }

    @Override
    public @NonNull B append(@NonNull Component component) {
        if (this.children == AbstractComponent.EMPTY_COMPONENT_LIST) {
            this.children = new ArrayList<Component>();
        }
        this.children.add(component);
        return (B)this;
    }

    @Override
    public @NonNull B append(@NonNull Iterable<? extends Component> components) {
        if (this.children == AbstractComponent.EMPTY_COMPONENT_LIST) {
            this.children = new ArrayList<Component>();
        }
        components.forEach(this.children::add);
        return (B)this;
    }

    @Override
    public @NonNull B applyDeep(@NonNull Consumer<? super ComponentBuilder<?, ?>> consumer) {
        this.apply(consumer);
        if (this.children == AbstractComponent.EMPTY_COMPONENT_LIST) {
            return (B)this;
        }
        ListIterator<Component> it = this.children.listIterator();
        while (it.hasNext()) {
            Component child = it.next();
            if (!(child instanceof BuildableComponent)) continue;
            Object childBuilder = ((BuildableComponent)child).toBuilder();
            childBuilder.applyDeep(consumer);
            it.set((Component)childBuilder.build());
        }
        return (B)this;
    }

    @Override
    public @NonNull B mapChildren(@NonNull Function<BuildableComponent<?, ?>, ? extends BuildableComponent<?, ?>> function) {
        if (this.children == AbstractComponent.EMPTY_COMPONENT_LIST) {
            return (B)this;
        }
        ListIterator<Component> it = this.children.listIterator();
        while (it.hasNext()) {
            BuildableComponent<?, ?> mappedChild;
            Component child = it.next();
            if (!(child instanceof BuildableComponent) || child == (mappedChild = function.apply((BuildableComponent)child))) continue;
            it.set(mappedChild);
        }
        return (B)this;
    }

    @Override
    public @NonNull B mapChildrenDeep(@NonNull Function<BuildableComponent<?, ?>, ? extends BuildableComponent<?, ?>> function) {
        if (this.children == AbstractComponent.EMPTY_COMPONENT_LIST) {
            return (B)this;
        }
        ListIterator<Component> it = this.children.listIterator();
        while (it.hasNext()) {
            Component child = it.next();
            if (!(child instanceof BuildableComponent)) continue;
            BuildableComponent<?, ?> mappedChild = function.apply((BuildableComponent)child);
            if (mappedChild.children().isEmpty()) {
                if (child == mappedChild) continue;
                it.set(mappedChild);
                continue;
            }
            Object builder = mappedChild.toBuilder();
            builder.mapChildrenDeep(function);
            it.set((Component)builder.build());
        }
        return (B)this;
    }

    @Override
    public @NonNull B style(@NonNull Style style) {
        this.style = style;
        return (B)this;
    }

    @Override
    public @NonNull B color(@Nullable TextColor color) {
        this.styleBuilder().color(color);
        return (B)this;
    }

    @Override
    public @NonNull B colorIfAbsent(@Nullable TextColor color) {
        this.styleBuilder().colorIfAbsent(color);
        return (B)this;
    }

    @Override
    public @NonNull B decoration(@NonNull TextDecoration decoration, @NonNull TextDecoration.State state) {
        this.styleBuilder().decoration(decoration, state);
        return (B)this;
    }

    @Override
    public @NonNull B clickEvent(@Nullable ClickEvent event) {
        this.styleBuilder().clickEvent(event);
        return (B)this;
    }

    @Override
    public @NonNull B hoverEvent(@Nullable HoverEvent event) {
        this.styleBuilder().hoverEvent(event);
        return (B)this;
    }

    @Override
    public @NonNull B insertion(@Nullable String insertion) {
        this.styleBuilder().insertion(insertion);
        return (B)this;
    }

    @Override
    public @NonNull B resetStyle() {
        this.style = null;
        this.styleB = null;
        return (B)this;
    }

    private @NonNull Style.Builder styleBuilder() {
        if (this.styleB == null) {
            if (this.style != null) {
                this.styleB = this.style.toBuilder();
                this.style = null;
            } else {
                this.styleB = Style.builder();
            }
        }
        return this.styleB;
    }

    protected @NonNull Style buildStyle() {
        if (this.styleB != null) {
            return this.styleB.build();
        }
        if (this.style != null) {
            return this.style;
        }
        return Style.empty();
    }
}

