/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.paste;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.sk89q.worldedit.util.net.HttpRequest;
import com.sk89q.worldedit.util.paste.Paster;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EngineHubPaste
implements Paster {
    private static final Pattern URL_PATTERN = Pattern.compile("https?://.+$");
    private static final Gson GSON = new Gson();

    @Override
    public Callable<URL> paste(String content) {
        return new PasteTask(content);
    }

    private static final class PasteTask
    implements Callable<URL> {
        private final String content;

        private PasteTask(String content) {
            this.content = content;
        }

        @Override
        public URL call() throws IOException, InterruptedException {
            HttpRequest.Form form = HttpRequest.Form.create();
            form.add("content", this.content);
            form.add("from", "enginehub");
            URL url = HttpRequest.url("http://paste.enginehub.org/paste");
            String result = HttpRequest.post(url).bodyForm(form).execute().expectResponseCode(200).returnContent().asString("UTF-8").trim();
            Map object = (Map)GSON.fromJson(result, new TypeToken<Map<Object, Object>>(){}.getType());
            if (object != null) {
                String urlString = String.valueOf(object.get("url"));
                Matcher m = URL_PATTERN.matcher(urlString);
                if (m.matches()) {
                    return new URL(urlString);
                }
            }
            throw new IOException("Failed to save paste; instead, got: " + result);
        }
    }
}

