/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.fabric;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.Files;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.fabric.FabricAdapter;
import com.sk89q.worldedit.fabric.FabricEntity;
import com.sk89q.worldedit.fabric.MutableBiomeArray;
import com.sk89q.worldedit.fabric.NBTConverter;
import com.sk89q.worldedit.fabric.WorldEditFakePlayer;
import com.sk89q.worldedit.internal.Constants;
import com.sk89q.worldedit.internal.block.BlockStateIdAccess;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.world.AbstractWorld;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.item.ItemTypes;
import com.sk89q.worldedit.world.weather.WeatherType;
import com.sk89q.worldedit.world.weather.WeatherTypes;
import java.io.File;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2802;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_29;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_31;
import net.minecraft.class_3207;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3829;
import net.minecraft.class_3864;
import net.minecraft.class_3949;
import net.minecraft.class_3965;
import net.minecraft.class_4548;
import net.minecraft.class_4640;
import net.minecraft.server.MinecraftServer;

public class FabricWorld
extends AbstractWorld {
    private static final Random random = new Random();
    private static final int UPDATE = 1;
    private static final int NOTIFY = 2;
    private final WeakReference<class_1937> worldRef;
    private static final LoadingCache<class_3218, WorldEditFakePlayer> fakePlayers = CacheBuilder.newBuilder().weakKeys().softValues().build(CacheLoader.from(WorldEditFakePlayer::new));

    FabricWorld(class_1937 world) {
        Preconditions.checkNotNull((Object)world);
        this.worldRef = new WeakReference<class_1937>(world);
    }

    public class_1937 getWorldChecked() throws WorldEditException {
        class_1937 world = (class_1937)this.worldRef.get();
        if (world != null) {
            return world;
        }
        throw new WorldReferenceLostException("The reference to the world was lost (i.e. the world may have been unloaded)");
    }

    public class_1937 getWorld() {
        class_1937 world = (class_1937)this.worldRef.get();
        if (world != null) {
            return world;
        }
        throw new RuntimeException("The reference to the world was lost (i.e. the world may have been unloaded)");
    }

    @Override
    public String getName() {
        return this.getWorld().method_8401().method_150();
    }

    @Override
    public String getId() {
        return this.getWorld().method_8401().method_150().replace(" ", "_").toLowerCase(Locale.ROOT) + this.getWorld().field_9247.method_12460().method_12489();
    }

    @Override
    public Path getStoragePath() {
        class_1937 world = this.getWorld();
        if (world instanceof class_3218) {
            return ((class_3218)world).method_17982().method_132().toPath();
        }
        return null;
    }

    @Override
    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 position, B block, boolean notifyAndLight) throws WorldEditException {
        CompoundTag tag;
        boolean successful;
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull(block);
        class_1937 world = this.getWorldChecked();
        int x = position.getBlockX();
        int y = position.getBlockY();
        int z = position.getBlockZ();
        class_2818 chunk = world.method_8497(x >> 4, z >> 4);
        class_2338 pos = new class_2338(x, y, z);
        class_2680 old = chunk.method_8320(pos);
        OptionalInt stateId = BlockStateIdAccess.getBlockStateId(block.toImmutableState());
        class_2680 newState = stateId.isPresent() ? class_2248.method_9531((int)stateId.getAsInt()) : FabricAdapter.adapt(block.toImmutableState());
        class_2680 successState = chunk.method_12010(pos, newState, false);
        boolean bl = successful = successState != null;
        if ((successful || old == newState) && block instanceof BaseBlock && (tag = ((BaseBlock)block).getNbtData()) != null) {
            class_2487 nativeTag = NBTConverter.toNative(tag);
            class_2586 tileEntity = this.getWorld().method_8500(pos).method_8321(pos);
            if (tileEntity != null) {
                tileEntity.method_11014(nativeTag);
                tileEntity.method_11009(world, pos);
                successful = true;
            }
        }
        if (successful && notifyAndLight) {
            world.method_8398().method_12130().method_15559(pos);
            world.method_16109(pos, old, newState);
            world.method_8413(pos, old, newState, 3);
            world.method_8408(pos, newState.method_11614());
            if (old.method_11584()) {
                world.method_8455(pos, newState.method_11614());
            }
        }
        return successful;
    }

    @Override
    public boolean notifyAndLightBlock(BlockVector3 position, BlockState previousType) throws WorldEditException {
        class_2338 pos = new class_2338(position.getX(), position.getY(), position.getZ());
        class_2680 state = this.getWorld().method_8320(pos);
        this.getWorld().method_8413(pos, FabricAdapter.adapt(previousType), state, 3);
        this.getWorld().method_8408(pos, state.method_11614());
        return true;
    }

    @Override
    public int getBlockLightLevel(BlockVector3 position) {
        Preconditions.checkNotNull((Object)position);
        return this.getWorld().method_22339(FabricAdapter.toBlockPos(position));
    }

    @Override
    public boolean clearContainerBlockContents(BlockVector3 position) {
        Preconditions.checkNotNull((Object)position);
        class_2586 tile = this.getWorld().method_8321(FabricAdapter.toBlockPos(position));
        if (tile instanceof class_3829) {
            ((class_3829)tile).method_5448();
            return true;
        }
        return false;
    }

    @Override
    public BiomeType getBiome(BlockVector2 position) {
        Preconditions.checkNotNull((Object)position);
        return FabricAdapter.adapt(this.getWorld().method_23753(new class_2338(position.getBlockX(), 0, position.getBlockZ())));
    }

    @Override
    public boolean setBiome(BlockVector2 position, BiomeType biome) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)biome);
        class_2791 chunk = this.getWorld().method_8402(position.getBlockX() >> 4, position.getBlockZ() >> 4, class_2806.field_12803, false);
        if (chunk == null) {
            return false;
        }
        MutableBiomeArray biomeArray = MutableBiomeArray.inject(chunk.method_12036());
        for (int i = 0; i < class_4548.field_20651; ++i) {
            biomeArray.setBiome(position.getX(), i, position.getZ(), FabricAdapter.adapt(biome));
        }
        chunk.method_12008(true);
        return true;
    }

    @Override
    public boolean useItem(BlockVector3 position, BaseItem item, Direction face) {
        WorldEditFakePlayer fakePlayer;
        class_1799 stack = FabricAdapter.adapt(new BaseItemStack(item.getType(), item.getNbtData(), 1));
        class_3218 world = (class_3218)this.getWorld();
        try {
            fakePlayer = (WorldEditFakePlayer)((Object)fakePlayers.get((Object)world));
        }
        catch (ExecutionException ignored) {
            return false;
        }
        fakePlayer.method_6122(class_1268.field_5808, stack);
        fakePlayer.method_5641(position.getBlockX(), position.getBlockY(), position.getBlockZ(), (float)face.toVector().toYaw(), (float)face.toVector().toPitch());
        class_2338 blockPos = FabricAdapter.toBlockPos(position);
        class_3965 rayTraceResult = new class_3965(FabricAdapter.toVec3(position), FabricAdapter.adapt(face), blockPos, false);
        class_1838 itemUseContext = new class_1838((class_1657)fakePlayer, class_1268.field_5808, rayTraceResult);
        class_1269 used = stack.method_7981(itemUseContext);
        if (used != class_1269.field_5812) {
            used = this.getWorld().method_8320(blockPos).method_11629((class_1937)world, (class_1657)fakePlayer, class_1268.field_5808, rayTraceResult);
        }
        if (used != class_1269.field_5812) {
            used = stack.method_7913((class_1937)world, (class_1657)fakePlayer, class_1268.field_5808).method_5467();
        }
        return used == class_1269.field_5812;
    }

    @Override
    public void dropItem(Vector3 position, BaseItemStack item) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)item);
        if (item.getType() == ItemTypes.AIR) {
            return;
        }
        class_1542 entity = new class_1542(this.getWorld(), position.getX(), position.getY(), position.getZ(), FabricAdapter.adapt(item));
        entity.method_6982(10);
        this.getWorld().method_8649((class_1297)entity);
    }

    @Override
    public void simulateBlockMine(BlockVector3 position) {
        class_2338 pos = FabricAdapter.toBlockPos(position);
        this.getWorld().method_22352(pos, true);
    }

    @Override
    public boolean regenerate(Region region, EditSession editSession) {
        class_2802 provider = this.getWorld().method_8398();
        if (!(provider instanceof class_3215)) {
            return false;
        }
        File saveFolder = Files.createTempDir();
        saveFolder.deleteOnExit();
        try {
            class_3218 originalWorld = (class_3218)this.getWorld();
            MinecraftServer server = originalWorld.method_8503();
            class_29 saveHandler = new class_29(saveFolder, originalWorld.method_17982().method_132().getName(), server, server.method_3855());
            class_3218 freshWorld = new class_3218(server, server.method_17191(), saveHandler, originalWorld.method_8401(), originalWorld.field_9247.method_12460(), originalWorld.method_16107(), (class_3949)new NoOpChunkStatusListener());
            CuboidRegion expandedPreGen = new CuboidRegion(region.getMinimumPoint().subtract(16, 0, 16), region.getMaximumPoint().add(16, 0, 16));
            for (BlockVector2 chunk : expandedPreGen.getChunks()) {
                freshWorld.method_8497(chunk.getBlockX(), chunk.getBlockZ());
            }
            FabricWorld from = new FabricWorld((class_1937)freshWorld);
            for (BlockVector3 vec : region) {
                editSession.setBlock(vec, from.getFullBlock(vec));
            }
        }
        catch (MaxChangedBlocksException e) {
            throw new RuntimeException(e);
        }
        finally {
            saveFolder.delete();
        }
        return true;
    }

    @Nullable
    private static class_2975<?, ?> createTreeFeatureGenerator(TreeGenerator.TreeType type) {
        switch (type) {
            case TREE: {
                return class_3031.field_13510.method_23397((class_3037)class_3864.field_21126);
            }
            case BIG_TREE: {
                return class_3031.field_13529.method_23397((class_3037)class_3864.field_21190);
            }
            case REDWOOD: {
                return class_3031.field_13510.method_23397((class_3037)class_3864.field_21185);
            }
            case TALL_REDWOOD: {
                return class_3031.field_13580.method_23397((class_3037)class_3864.field_21198);
            }
            case MEGA_REDWOOD: {
                return class_3031.field_13580.method_23397((class_3037)class_3864.field_21199);
            }
            case BIRCH: {
                return class_3031.field_13510.method_23397((class_3037)class_3864.field_21187);
            }
            case JUNGLE: {
                return class_3031.field_13558.method_23397((class_3037)class_3864.field_21200);
            }
            case SMALL_JUNGLE: {
                return class_3031.field_13510.method_23397((class_3037)class_3864.field_21167);
            }
            case SHORT_JUNGLE: {
                return new class_3207(class_4640::method_23426).method_23397((class_3037)class_3864.field_21183);
            }
            case JUNGLE_BUSH: {
                return class_3031.field_13537.method_23397((class_3037)class_3864.field_21196);
            }
            case SWAMP: {
                return class_3031.field_13510.method_23397((class_3037)class_3864.field_21189);
            }
            case ACACIA: {
                return class_3031.field_21218.method_23397((class_3037)class_3864.field_21186);
            }
            case DARK_OAK: {
                return class_3031.field_13532.method_23397((class_3037)class_3864.field_21197);
            }
            case TALL_BIRCH: {
                return class_3031.field_13510.method_23397((class_3037)class_3864.field_21188);
            }
            case RED_MUSHROOM: {
                return class_3031.field_13571.method_23397((class_3037)class_3864.field_21142);
            }
            case BROWN_MUSHROOM: {
                return class_3031.field_13531.method_23397((class_3037)class_3864.field_21143);
            }
            case RANDOM: {
                return FabricWorld.createTreeFeatureGenerator(TreeGenerator.TreeType.values()[ThreadLocalRandom.current().nextInt(TreeGenerator.TreeType.values().length)]);
            }
        }
        return null;
    }

    @Override
    public boolean generateTree(TreeGenerator.TreeType type, EditSession editSession, BlockVector3 position) {
        class_2975<?, ?> generator = FabricWorld.createTreeFeatureGenerator(type);
        class_3215 chunkManager = (class_3215)this.getWorld().method_8398();
        return generator != null && generator.method_12862((class_1936)this.getWorld(), chunkManager.method_12129(), random, FabricAdapter.toBlockPos(position));
    }

    @Override
    public void checkLoadedChunk(BlockVector3 pt) {
        this.getWorld().method_22350(FabricAdapter.toBlockPos(pt));
    }

    @Override
    public void fixAfterFastMode(Iterable<BlockVector2> chunks) {
        this.fixLighting(chunks);
    }

    @Override
    public void fixLighting(Iterable<BlockVector2> chunks) {
        class_1937 world = this.getWorld();
        for (BlockVector2 chunk : chunks) {
            world.method_8398().method_12130().method_15557(new class_1923(chunk.getBlockX(), chunk.getBlockZ()), true);
        }
    }

    @Override
    public boolean playEffect(Vector3 position, int type, int data) {
        this.getWorld().method_20290(type, FabricAdapter.toBlockPos(position.toBlockPoint()), data);
        return true;
    }

    @Override
    public WeatherType getWeather() {
        class_31 info = this.getWorld().method_8401();
        if (info.method_203()) {
            return WeatherTypes.THUNDER_STORM;
        }
        if (info.method_156()) {
            return WeatherTypes.RAIN;
        }
        return WeatherTypes.CLEAR;
    }

    @Override
    public long getRemainingWeatherDuration() {
        class_31 info = this.getWorld().method_8401();
        if (info.method_203()) {
            return info.method_145();
        }
        if (info.method_156()) {
            return info.method_190();
        }
        return info.method_155();
    }

    @Override
    public void setWeather(WeatherType weatherType) {
        this.setWeather(weatherType, 0L);
    }

    @Override
    public void setWeather(WeatherType weatherType, long duration) {
        class_31 info = this.getWorld().method_8401();
        if (weatherType == WeatherTypes.THUNDER_STORM) {
            info.method_167(0);
            info.method_147(true);
            info.method_173((int)duration);
        } else if (weatherType == WeatherTypes.RAIN) {
            info.method_167(0);
            info.method_157(true);
            info.method_164((int)duration);
        } else if (weatherType == WeatherTypes.CLEAR) {
            info.method_157(false);
            info.method_147(false);
            info.method_167((int)duration);
        }
    }

    @Override
    public int getMaxY() {
        return this.getWorld().method_8322() - 1;
    }

    @Override
    public BlockVector3 getSpawnPosition() {
        return FabricAdapter.adapt(this.getWorld().method_8395());
    }

    @Override
    public BlockState getBlock(BlockVector3 position) {
        class_2680 mcState = this.getWorld().method_8497(position.getBlockX() >> 4, position.getBlockZ() >> 4).method_8320(FabricAdapter.toBlockPos(position));
        BlockState matchingBlock = BlockStateIdAccess.getBlockStateById(class_2248.method_9507((class_2680)mcState));
        if (matchingBlock != null) {
            return matchingBlock;
        }
        return FabricAdapter.adapt(mcState);
    }

    @Override
    public BaseBlock getFullBlock(BlockVector3 position) {
        class_2338 pos = new class_2338(position.getBlockX(), position.getBlockY(), position.getBlockZ());
        class_2586 tile = ((class_2818)this.getWorld().method_22350(pos)).method_12201(pos, class_2818.class_2819.field_12859);
        if (tile != null) {
            class_2487 tag = new class_2487();
            tile.method_11007(tag);
            return this.getBlock(position).toBaseBlock(NBTConverter.fromNative(tag));
        }
        return this.getBlock(position).toBaseBlock();
    }

    @Override
    public int hashCode() {
        return this.getWorld().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof FabricWorld) {
            FabricWorld other = (FabricWorld)o;
            class_1937 otherWorld = (class_1937)other.worldRef.get();
            class_1937 thisWorld = (class_1937)this.worldRef.get();
            return otherWorld != null && otherWorld.equals(thisWorld);
        }
        if (o instanceof World) {
            return ((World)o).getName().equals(this.getName());
        }
        return false;
    }

    @Override
    public List<? extends Entity> getEntities(Region region) {
        class_1937 world = this.getWorld();
        if (!(world instanceof class_3218)) {
            return Collections.emptyList();
        }
        return ((class_3218)world).method_18198(null, entity -> true).stream().filter(e -> region.contains(FabricAdapter.adapt(e.method_5704()))).map(FabricEntity::new).collect(Collectors.toList());
    }

    @Override
    public List<? extends Entity> getEntities() {
        class_1937 world = this.getWorld();
        if (!(world instanceof class_3218)) {
            return Collections.emptyList();
        }
        return ((class_3218)world).method_18198(null, entity -> true).stream().map(FabricEntity::new).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity entity) {
        class_1937 world = this.getWorld();
        Optional entityType = class_1299.method_5898((String)entity.getType().getId());
        if (!entityType.isPresent()) {
            return null;
        }
        class_1297 createdEntity = ((class_1299)entityType.get()).method_5883(world);
        if (createdEntity != null) {
            CompoundTag nativeTag = entity.getNbtData();
            if (nativeTag != null) {
                class_2487 tag = NBTConverter.toNative(entity.getNbtData());
                for (String name : Constants.NO_COPY_ENTITY_NBT_FIELDS) {
                    tag.method_10551(name);
                }
                createdEntity.method_5651(tag);
            }
            createdEntity.method_5641(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            world.method_8649(createdEntity);
            return new FabricEntity(createdEntity);
        }
        return null;
    }

    private static class NoOpChunkStatusListener
    implements class_3949 {
        private NoOpChunkStatusListener() {
        }

        public void method_17669(class_1923 chunkPos) {
        }

        public void method_17670(class_1923 chunkPos, @Nullable class_2806 chunkStatus) {
        }

        public void method_17671() {
        }
    }

    private static final class WorldReferenceLostException
    extends WorldEditException {
        private WorldReferenceLostException(String message) {
            super(message);
        }
    }
}

