/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.internal.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.sk89q.worldedit.world.block.BlockState;
import java.util.BitSet;
import java.util.OptionalInt;
import javax.annotation.Nullable;

public final class BlockStateIdAccess {
    private static final BiMap<BlockState, Integer> ASSIGNED_IDS = HashBiMap.create((int)16384);
    private static final BitSet usedIds = new BitSet();

    public static OptionalInt getBlockStateId(BlockState holder) {
        Integer value = (Integer)ASSIGNED_IDS.get((Object)holder);
        return value == null ? OptionalInt.empty() : OptionalInt.of(value);
    }

    @Nullable
    public static BlockState getBlockStateById(int id) {
        return (BlockState)ASSIGNED_IDS.inverse().get((Object)id);
    }

    private static int provideUnusedWorldEditId() {
        return usedIds.nextClearBit(0);
    }

    public static void register(BlockState blockState, OptionalInt id) {
        int i = id.orElseGet(BlockStateIdAccess::provideUnusedWorldEditId);
        BlockState existing = (BlockState)ASSIGNED_IDS.inverse().get((Object)i);
        Preconditions.checkState((existing == null || existing == blockState ? 1 : 0) != 0, (String)"BlockState %s is using the same block ID (%s) as BlockState %s", (Object)blockState, (Object)i, (Object)existing);
        ASSIGNED_IDS.put((Object)blockState, (Object)i);
        usedIds.set(i);
    }

    public static void clear() {
        ASSIGNED_IDS.clear();
        usedIds.clear();
    }

    private BlockStateIdAccess() {
    }
}

