/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.collection;

import com.google.common.collect.AbstractIterator;
import com.sk89q.worldedit.math.BitMath;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.collection.SubBlockMap;
import com.sk89q.worldedit.world.block.BaseBlock;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class BlockMap
extends AbstractMap<BlockVector3, BaseBlock> {
    private static final long BITS_24 = BitMath.mask(24);
    private static final long BITS_20 = BitMath.mask(20);
    private static final int BITS_8 = BitMath.mask(8);
    private static final int BITS_6 = BitMath.mask(6);
    private static final long GROUP_X = BITS_20;
    private static final long GROUP_Z = BITS_20 << 20;
    private static final long GROUP_Y = BITS_24 << 40;
    private static final int INNER_X = BITS_6;
    private static final int INNER_Z = BITS_6 << 6;
    private static final int INNER_Y = BITS_8 << 12;
    private final Long2ObjectMap<SubBlockMap> maps = new Long2ObjectOpenHashMap(4, 1.0f);
    private Set<Map.Entry<BlockVector3, BaseBlock>> entrySet;
    private Collection<BaseBlock> values;

    public static BlockMap create() {
        return new BlockMap();
    }

    public static BlockMap copyOf(Map<? extends BlockVector3, ? extends BaseBlock> source) {
        return new BlockMap(source);
    }

    private static long toGroupKey(BlockVector3 location) {
        return (long)(location.getX() >>> 6) & BITS_20 | ((long)(location.getZ() >>> 6) & BITS_20) << 20 | ((long)(location.getY() >>> 8) & BITS_24) << 40;
    }

    private static int toInnerKey(BlockVector3 location) {
        return location.getX() & BITS_6 | (location.getZ() & BITS_6) << 6 | (location.getY() & BITS_8) << 12;
    }

    private static BlockVector3 reconstructLocation(long group, int inner) {
        int groupX = (int)((group & GROUP_X) << 6);
        int x = BitMath.fixSign(groupX | inner & INNER_X, 26);
        int groupZ = (int)((group & GROUP_Z) >>> 14);
        int z = BitMath.fixSign(groupZ | (inner & INNER_Z) >>> 6, 26);
        int groupY = (int)((group & GROUP_Y) >>> 32);
        int y = groupY | (inner & INNER_Y) >>> 12;
        return BlockVector3.at(x, y, z);
    }

    private BlockMap() {
    }

    private BlockMap(Map<? extends BlockVector3, ? extends BaseBlock> source) {
        this.putAll(source);
    }

    private SubBlockMap getOrCreateMap(long groupKey) {
        return (SubBlockMap)((Object)this.maps.computeIfAbsent(groupKey, k -> new SubBlockMap()));
    }

    private SubBlockMap getOrEmptyMap(long groupKey) {
        return (SubBlockMap)((Object)this.maps.getOrDefault(groupKey, (Object)SubBlockMap.EMPTY));
    }

    private <R> R cleanlyModifyMap(long groupKey, Function<Int2ObjectMap<BaseBlock>, R> func) {
        SubBlockMap map = (SubBlockMap)((Object)this.maps.get(groupKey));
        if (map != null) {
            R result = func.apply((Int2ObjectMap<BaseBlock>)map);
            if (map.isEmpty()) {
                this.maps.remove(groupKey);
            }
            return result;
        }
        map = new SubBlockMap();
        R result = func.apply((Int2ObjectMap<BaseBlock>)map);
        if (!map.isEmpty()) {
            this.maps.put(groupKey, (Object)map);
        }
        return result;
    }

    @Override
    public BaseBlock put(BlockVector3 key, BaseBlock value) {
        return this.getOrCreateMap(BlockMap.toGroupKey(key)).put(BlockMap.toInnerKey(key), value);
    }

    @Override
    public BaseBlock getOrDefault(Object key, BaseBlock defaultValue) {
        BlockVector3 vec = (BlockVector3)key;
        return (BaseBlock)this.getOrEmptyMap(BlockMap.toGroupKey(vec)).getOrDefault(BlockMap.toInnerKey(vec), defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super BlockVector3, ? super BaseBlock> action) {
        this.maps.forEach((groupKey, m) -> m.forEach((innerKey, block) -> action.accept(BlockMap.reconstructLocation(groupKey, innerKey), (BaseBlock)block)));
    }

    @Override
    public void replaceAll(BiFunction<? super BlockVector3, ? super BaseBlock, ? extends BaseBlock> function) {
        this.maps.forEach((groupKey, m) -> m.replaceAll((? super Integer innerKey, ? super BaseBlock block) -> (BaseBlock)function.apply(BlockMap.reconstructLocation(groupKey, innerKey), (BaseBlock)block)));
    }

    @Override
    public BaseBlock putIfAbsent(BlockVector3 key, BaseBlock value) {
        return (BaseBlock)this.getOrCreateMap(BlockMap.toGroupKey(key)).putIfAbsent(BlockMap.toInnerKey(key), value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        BlockVector3 vec = (BlockVector3)key;
        return this.cleanlyModifyMap(BlockMap.toGroupKey(vec), map -> map.remove(BlockMap.toInnerKey(vec), value));
    }

    @Override
    public boolean replace(BlockVector3 key, BaseBlock oldValue, BaseBlock newValue) {
        return this.cleanlyModifyMap(BlockMap.toGroupKey(key), map -> map.replace(BlockMap.toInnerKey(key), (Object)oldValue, (Object)newValue));
    }

    @Override
    public BaseBlock replace(BlockVector3 key, BaseBlock value) {
        return (BaseBlock)this.getOrCreateMap(BlockMap.toGroupKey(key)).replace(BlockMap.toInnerKey(key), value);
    }

    @Override
    public BaseBlock computeIfAbsent(BlockVector3 key, Function<? super BlockVector3, ? extends BaseBlock> mappingFunction) {
        return this.cleanlyModifyMap(BlockMap.toGroupKey(key), map -> (BaseBlock)map.computeIfAbsent(BlockMap.toInnerKey(key), ik -> (BaseBlock)mappingFunction.apply(key)));
    }

    @Override
    public BaseBlock computeIfPresent(BlockVector3 key, BiFunction<? super BlockVector3, ? super BaseBlock, ? extends BaseBlock> remappingFunction) {
        return this.cleanlyModifyMap(BlockMap.toGroupKey(key), map -> (BaseBlock)map.computeIfPresent(BlockMap.toInnerKey(key), (ik, block) -> (BaseBlock)remappingFunction.apply(key, (BaseBlock)block)));
    }

    @Override
    public BaseBlock compute(BlockVector3 key, BiFunction<? super BlockVector3, ? super BaseBlock, ? extends BaseBlock> remappingFunction) {
        return this.cleanlyModifyMap(BlockMap.toGroupKey(key), map -> (BaseBlock)map.compute(BlockMap.toInnerKey(key), (ik, block) -> (BaseBlock)remappingFunction.apply(key, (BaseBlock)block)));
    }

    @Override
    public BaseBlock merge(BlockVector3 key, BaseBlock value, BiFunction<? super BaseBlock, ? super BaseBlock, ? extends BaseBlock> remappingFunction) {
        return this.cleanlyModifyMap(BlockMap.toGroupKey(key), map -> (BaseBlock)map.merge(BlockMap.toInnerKey(key), (Object)value, remappingFunction));
    }

    @Override
    public Set<Map.Entry<BlockVector3, BaseBlock>> entrySet() {
        AbstractSet<Map.Entry<BlockVector3, BaseBlock>> es = this.entrySet;
        if (es == null) {
            this.entrySet = es = new AbstractSet<Map.Entry<BlockVector3, BaseBlock>>(){

                @Override
                public Iterator<Map.Entry<BlockVector3, BaseBlock>> iterator() {
                    return new AbstractIterator<Map.Entry<BlockVector3, BaseBlock>>(){
                        private final ObjectIterator<Long2ObjectMap.Entry<SubBlockMap>> primaryIterator;
                        private long currentGroupKey;
                        private ObjectIterator<Int2ObjectMap.Entry<BaseBlock>> secondaryIterator;
                        {
                            this.primaryIterator = Long2ObjectMaps.fastIterator((Long2ObjectMap)BlockMap.this.maps);
                        }

                        protected Map.Entry<BlockVector3, BaseBlock> computeNext() {
                            Int2ObjectMap.Entry next;
                            if (this.secondaryIterator == null || !this.secondaryIterator.hasNext()) {
                                if (!this.primaryIterator.hasNext()) {
                                    return (Map.Entry)this.endOfData();
                                }
                                next = (Long2ObjectMap.Entry)this.primaryIterator.next();
                                this.currentGroupKey = next.getLongKey();
                                this.secondaryIterator = Int2ObjectMaps.fastIterator((Int2ObjectMap)((Int2ObjectMap)next.getValue()));
                            }
                            next = (Int2ObjectMap.Entry)this.secondaryIterator.next();
                            return new LazyEntry(this.currentGroupKey, next.getIntKey(), (BaseBlock)next.getValue());
                        }
                    };
                }

                @Override
                public int size() {
                    return BlockMap.this.size();
                }
            };
        }
        return es;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.maps.values().stream().anyMatch(m -> m.containsValue(value));
    }

    @Override
    public boolean containsKey(Object key) {
        BlockVector3 vec = (BlockVector3)key;
        Map activeMap = (Map)this.maps.get(BlockMap.toGroupKey(vec));
        if (activeMap == null) {
            return false;
        }
        return activeMap.containsKey(BlockMap.toInnerKey(vec));
    }

    @Override
    public BaseBlock get(Object key) {
        BlockVector3 vec = (BlockVector3)key;
        Map activeMap = (Map)this.maps.get(BlockMap.toGroupKey(vec));
        if (activeMap == null) {
            return null;
        }
        return (BaseBlock)activeMap.get(BlockMap.toInnerKey(vec));
    }

    @Override
    public BaseBlock remove(Object key) {
        BlockVector3 vec = (BlockVector3)key;
        Map activeMap = (Map)this.maps.get(BlockMap.toGroupKey(vec));
        if (activeMap == null) {
            return null;
        }
        BaseBlock removed = (BaseBlock)activeMap.remove(BlockMap.toInnerKey(vec));
        if (activeMap.isEmpty()) {
            this.maps.remove(BlockMap.toGroupKey(vec));
        }
        return removed;
    }

    @Override
    public void putAll(Map<? extends BlockVector3, ? extends BaseBlock> m) {
        if (m instanceof BlockMap) {
            ((BlockMap)m).maps.forEach((groupKey, map) -> this.getOrCreateMap((long)groupKey).putAll((Map)((Object)map)));
        } else {
            super.putAll(m);
        }
    }

    @Override
    public void clear() {
        this.maps.clear();
    }

    @Override
    public int size() {
        return this.maps.values().stream().mapToInt(Map::size).sum();
    }

    @Override
    public Collection<BaseBlock> values() {
        AbstractCollection<BaseBlock> vs = this.values;
        if (vs == null) {
            this.values = vs = new AbstractCollection<BaseBlock>(){

                @Override
                public Iterator<BaseBlock> iterator() {
                    return BlockMap.this.maps.values().stream().flatMap(m -> m.values().stream()).iterator();
                }

                @Override
                public int size() {
                    return BlockMap.this.size();
                }
            };
        }
        return vs;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BlockMap) {
            return this.maps.equals(((BlockMap)o).maps);
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private final class LazyEntry
    implements Map.Entry<BlockVector3, BaseBlock> {
        private final long groupKey;
        private final int innerKey;
        private BlockVector3 lazyKey;
        private BaseBlock value;

        private LazyEntry(long groupKey, int innerKey, BaseBlock value) {
            this.groupKey = groupKey;
            this.innerKey = innerKey;
            this.value = value;
        }

        @Override
        public BlockVector3 getKey() {
            BlockVector3 result = this.lazyKey;
            if (result == null) {
                this.lazyKey = result = BlockMap.reconstructLocation(this.groupKey, this.innerKey);
            }
            return result;
        }

        @Override
        public BaseBlock getValue() {
            return this.value;
        }

        @Override
        public BaseBlock setValue(BaseBlock value) {
            this.value = value;
            return BlockMap.this.getOrCreateMap(this.groupKey).put(this.innerKey, value);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (o instanceof LazyEntry) {
                LazyEntry otherE = (LazyEntry)o;
                return otherE.groupKey == this.groupKey && otherE.innerKey == this.innerKey && Objects.equals(this.value, e.getValue());
            }
            return Objects.equals(this.getKey(), e.getKey()) && Objects.equals(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.getKey()) ^ Objects.hashCode(this.value);
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

