/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.collection;

import com.sk89q.worldedit.internal.block.BlockStateIdAccess;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import it.unimi.dsi.fastutil.ints.AbstractInt2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntMaps;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;

class SubBlockMap
extends AbstractInt2ObjectMap<BaseBlock> {
    static final SubBlockMap EMPTY = new SubBlockMap();
    private final Int2IntMap commonMap = new Int2IntOpenHashMap(64, 1.0f);
    private final Int2ObjectMap<BaseBlock> uncommonMap = new Int2ObjectOpenHashMap(1, 1.0f);

    SubBlockMap() {
        this.commonMap.defaultReturnValue(Integer.MIN_VALUE);
    }

    private static boolean hasInt(BlockState b) {
        return BlockStateIdAccess.getBlockStateId(b).isPresent();
    }

    private static boolean isUncommon(BaseBlock block) {
        return block.hasNbtData() || !SubBlockMap.hasInt(block.toImmutableState());
    }

    private static int assumeAsInt(BlockState b) {
        return BlockStateIdAccess.getBlockStateId(b).orElseThrow(() -> new IllegalStateException("Block state " + b + " did not have an ID"));
    }

    private static BaseBlock assumeAsBlock(int id) {
        if (id == Integer.MIN_VALUE) {
            return null;
        }
        BlockState state = BlockStateIdAccess.getBlockStateById(id);
        if (state == null) {
            throw new IllegalStateException("No state for ID " + id);
        }
        return state.toBaseBlock();
    }

    public int size() {
        return this.commonMap.size() + this.uncommonMap.size();
    }

    public ObjectSet<Int2ObjectMap.Entry<BaseBlock>> int2ObjectEntrySet() {
        return new AbstractObjectSet<Int2ObjectMap.Entry<BaseBlock>>(){

            public ObjectIterator<Int2ObjectMap.Entry<BaseBlock>> iterator() {
                return new ObjectIterator<Int2ObjectMap.Entry<BaseBlock>>(){
                    private final ObjectIterator<Int2IntMap.Entry> commonIter;
                    private final ObjectIterator<Int2ObjectMap.Entry<BaseBlock>> uncommonIter;
                    {
                        this.commonIter = Int2IntMaps.fastIterator((Int2IntMap)SubBlockMap.this.commonMap);
                        this.uncommonIter = Int2ObjectMaps.fastIterator((Int2ObjectMap)SubBlockMap.this.uncommonMap);
                    }

                    public boolean hasNext() {
                        return this.commonIter.hasNext() || this.uncommonIter.hasNext();
                    }

                    public Int2ObjectMap.Entry<BaseBlock> next() {
                        if (this.commonIter.hasNext()) {
                            Int2IntMap.Entry e = (Int2IntMap.Entry)this.commonIter.next();
                            return new AbstractInt2ObjectMap.BasicEntry(e.getIntKey(), (Object)SubBlockMap.assumeAsBlock(e.getIntValue()));
                        }
                        if (this.uncommonIter.hasNext()) {
                            return (Int2ObjectMap.Entry)this.uncommonIter.next();
                        }
                        throw new NoSuchElementException();
                    }
                };
            }

            public int size() {
                return SubBlockMap.this.size();
            }
        };
    }

    public BaseBlock get(int key) {
        int oldId = this.commonMap.get(key);
        if (oldId == Integer.MIN_VALUE) {
            return (BaseBlock)this.uncommonMap.get(key);
        }
        return SubBlockMap.assumeAsBlock(oldId);
    }

    public boolean containsKey(int k) {
        return this.commonMap.containsKey(k) || this.uncommonMap.containsKey(k);
    }

    public boolean containsValue(Object v) {
        BaseBlock block = (BaseBlock)v;
        if (SubBlockMap.isUncommon(block)) {
            return this.uncommonMap.containsValue((Object)block);
        }
        return this.commonMap.containsValue(SubBlockMap.assumeAsInt(block.toImmutableState()));
    }

    public BaseBlock put(int key, BaseBlock value) {
        if (SubBlockMap.isUncommon(value)) {
            BaseBlock old = (BaseBlock)this.uncommonMap.put(key, (Object)value);
            if (old == null) {
                int oldId = this.commonMap.remove(key);
                return SubBlockMap.assumeAsBlock(oldId);
            }
            return old;
        }
        int oldId = this.commonMap.put(key, SubBlockMap.assumeAsInt(value.toImmutableState()));
        return SubBlockMap.assumeAsBlock(oldId);
    }

    public BaseBlock remove(int key) {
        int removed = this.commonMap.remove(key);
        if (removed == Integer.MIN_VALUE) {
            return (BaseBlock)this.uncommonMap.remove(key);
        }
        return SubBlockMap.assumeAsBlock(removed);
    }

    public void replaceAll(BiFunction<? super Integer, ? super BaseBlock, ? extends BaseBlock> function) {
        BaseBlock value;
        Int2IntMap.Entry next;
        ObjectIterator iter = Int2IntMaps.fastIterator((Int2IntMap)this.commonMap);
        while (iter.hasNext()) {
            next = (Int2IntMap.Entry)iter.next();
            value = function.apply((Integer)next.getIntKey(), SubBlockMap.assumeAsBlock(next.getIntValue()));
            if (SubBlockMap.isUncommon(value)) {
                this.uncommonMap.put(next.getIntKey(), (Object)value);
                iter.remove();
                continue;
            }
            next.setValue(SubBlockMap.assumeAsInt(value.toImmutableState()));
        }
        iter = Int2ObjectMaps.fastIterator(this.uncommonMap);
        while (iter.hasNext()) {
            next = (Int2ObjectMap.Entry)iter.next();
            value = function.apply((Integer)next.getIntKey(), (BaseBlock)next.getValue());
            if (SubBlockMap.isUncommon(value)) {
                next.setValue((Object)value);
                continue;
            }
            this.commonMap.put(next.getIntKey(), SubBlockMap.assumeAsInt(value.toImmutableState()));
            iter.remove();
        }
    }
}

