/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.formatting.text.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class NameMap<T> {
    private final Map<String, T> byName;
    private final Map<T, String> byValue;

    private NameMap(Map<String, T> byName, Map<T, String> byValue) {
        this.byName = byName;
        this.byValue = byValue;
    }

    public static <T extends Enum<T>> @NonNull NameMap<T> create(T @NonNull [] constants, @NonNull Function<T, String> namer) {
        HashMap<String, T> byName = new HashMap<String, T>(constants.length);
        HashMap<T, String> byValue = new HashMap<T, String>(constants.length);
        for (T constant : constants) {
            String name = namer.apply(constant);
            byName.put(name, constant);
            byValue.put(constant, name);
        }
        return new NameMap(Collections.unmodifiableMap(byName), Collections.unmodifiableMap(byValue));
    }

    public @NonNull String name(@NonNull T value) {
        return this.byValue.get(value);
    }

    public @NonNull Optional<T> get(@NonNull String name) {
        return Optional.ofNullable(this.byName.get(name));
    }
}

