/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.item;

import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.registry.Keyed;
import com.sk89q.worldedit.registry.NamespacedRegistry;
import com.sk89q.worldedit.util.concurrency.LazyReference;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.registry.ItemMaterial;
import javax.annotation.Nullable;

public class ItemType
implements Keyed {
    public static final NamespacedRegistry<ItemType> REGISTRY = new NamespacedRegistry("item type");
    private String id;
    private String name;
    private final LazyReference<ItemMaterial> itemMaterial = LazyReference.from(() -> WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.GAME_HOOKS).getRegistries().getItemRegistry().getMaterial(this));

    public ItemType(String id) {
        if (!id.contains(":")) {
            id = "minecraft:" + id;
        }
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getName() {
        if (this.name == null) {
            this.name = WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.GAME_HOOKS).getRegistries().getItemRegistry().getName(this);
            if (this.name == null) {
                this.name = "";
            }
        }
        return this.name.isEmpty() ? this.getId() : this.name;
    }

    public boolean hasBlockType() {
        return this.getBlockType() != null;
    }

    @Nullable
    public BlockType getBlockType() {
        return BlockTypes.get(this.id);
    }

    public ItemMaterial getMaterial() {
        return this.itemMaterial.getValue();
    }

    public String toString() {
        return this.getId();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ItemType && this.id.equals(((ItemType)obj).id);
    }
}

