/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.sk89q.util.StringUtil;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extension.platform.AbstractPlayerActor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.forge.ForgeWorldEdit;
import com.sk89q.worldedit.forge.ThreadSafeCache;
import com.sk89q.worldedit.forge.WECUIPacketHandler;
import com.sk89q.worldedit.internal.LocalWorldAdapter;
import com.sk89q.worldedit.internal.cui.CUIEvent;
import com.sk89q.worldedit.session.SessionKey;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class ForgePlayer
extends AbstractPlayerActor {
    private final EntityPlayerMP player;

    protected ForgePlayer(EntityPlayerMP player) {
        this.player = player;
        ThreadSafeCache.getInstance().getOnlineIds().add(this.getUniqueId());
    }

    @Override
    public UUID getUniqueId() {
        return this.player.func_110124_au();
    }

    @Override
    public int getItemInHand() {
        ItemStack is = this.player.func_184586_b(EnumHand.MAIN_HAND);
        return is == null ? 0 : Item.func_150891_b((Item)is.func_77973_b());
    }

    @Override
    public String getName() {
        return this.player.func_70005_c_();
    }

    @Override
    public BaseEntity getState() {
        throw new UnsupportedOperationException("Cannot create a state from this object");
    }

    @Override
    public Location getLocation() {
        Vector position = new Vector(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v);
        return new Location((Extent)ForgeWorldEdit.inst.getWorld(this.player.field_70170_p), position, this.player.field_70177_z, this.player.field_70125_A);
    }

    @Override
    public WorldVector getPosition() {
        return new WorldVector((LocalWorld)LocalWorldAdapter.adapt(ForgeWorldEdit.inst.getWorld(this.player.field_70170_p)), this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v);
    }

    @Override
    public World getWorld() {
        return ForgeWorldEdit.inst.getWorld(this.player.field_70170_p);
    }

    @Override
    public double getPitch() {
        return this.player.field_70125_A;
    }

    @Override
    public double getYaw() {
        return this.player.field_70177_z;
    }

    @Override
    public void giveItem(int type, int amt) {
        this.player.field_71071_by.func_70441_a(new ItemStack(Item.func_150899_d((int)type), amt, 0));
    }

    @Override
    public void dispatchCUIEvent(CUIEvent event) {
        String[] params = event.getParameters();
        String send = event.getTypeId();
        if (params.length > 0) {
            send = send + "|" + StringUtil.joinString(params, "|");
        }
        PacketBuffer buffer = new PacketBuffer(Unpooled.copiedBuffer((byte[])send.getBytes(WECUIPacketHandler.UTF_8_CHARSET)));
        SPacketCustomPayload packet = new SPacketCustomPayload("WECUI", buffer);
        this.player.field_71135_a.func_147359_a((Packet)packet);
    }

    @Override
    public void printRaw(String msg) {
        for (String part : msg.split("\n")) {
            this.player.func_145747_a((ITextComponent)new TextComponentString(part));
        }
    }

    @Override
    public void printDebug(String msg) {
        this.sendColorized(msg, TextFormatting.GRAY);
    }

    @Override
    public void print(String msg) {
        this.sendColorized(msg, TextFormatting.LIGHT_PURPLE);
    }

    @Override
    public void printError(String msg) {
        this.sendColorized(msg, TextFormatting.RED);
    }

    private void sendColorized(String msg, TextFormatting formatting) {
        for (String part : msg.split("\n")) {
            TextComponentString component = new TextComponentString(part);
            component.func_150256_b().func_150238_a(formatting);
            this.player.func_145747_a((ITextComponent)component);
        }
    }

    @Override
    public void setPosition(Vector pos, float pitch, float yaw) {
        this.player.field_71135_a.func_147364_a(pos.getX(), pos.getY(), pos.getZ(), yaw, pitch);
    }

    @Override
    public String[] getGroups() {
        return new String[0];
    }

    @Override
    public BlockBag getInventoryBlockBag() {
        return null;
    }

    @Override
    public boolean hasPermission(String perm) {
        return ForgeWorldEdit.inst.getPermissionsProvider().hasPermission(this.player, perm);
    }

    @Override
    @Nullable
    public <T> T getFacet(Class<? extends T> cls) {
        return null;
    }

    @Override
    public SessionKey getSessionKey() {
        return new SessionKeyImpl(this.player.func_110124_au(), this.player.func_70005_c_());
    }

    private static class SessionKeyImpl
    implements SessionKey {
        private final UUID uuid;
        private final String name;

        private SessionKeyImpl(UUID uuid, String name) {
            this.uuid = uuid;
            this.name = name;
        }

        @Override
        public UUID getUniqueId() {
            return this.uuid;
        }

        @Override
        @Nullable
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isActive() {
            return ThreadSafeCache.getInstance().getOnlineIds().contains(this.uuid);
        }

        @Override
        public boolean isPersistent() {
            return true;
        }
    }
}

