/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.factory.ReplaceFactory;
import com.sk89q.worldedit.command.factory.TreeGeneratorFactory;
import com.sk89q.worldedit.command.tool.BrushTool;
import com.sk89q.worldedit.command.tool.brush.ButcherBrush;
import com.sk89q.worldedit.command.tool.brush.ClipboardBrush;
import com.sk89q.worldedit.command.tool.brush.CylinderBrush;
import com.sk89q.worldedit.command.tool.brush.GravityBrush;
import com.sk89q.worldedit.command.tool.brush.HollowCylinderBrush;
import com.sk89q.worldedit.command.tool.brush.HollowSphereBrush;
import com.sk89q.worldedit.command.tool.brush.OperationFactoryBrush;
import com.sk89q.worldedit.command.tool.brush.SmoothBrush;
import com.sk89q.worldedit.command.tool.brush.SphereBrush;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.CreatureButcher;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.function.Contextual;
import com.sk89q.worldedit.function.factory.Apply;
import com.sk89q.worldedit.function.factory.Deform;
import com.sk89q.worldedit.function.factory.Paint;
import com.sk89q.worldedit.function.mask.BlockTypeMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.pattern.BlockPattern;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.factory.RegionFactory;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.session.request.RequestExtent;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.world.block.BlockTypes;
import org.enginehub.piston.annotation.Command;

public class BrushCommands {
    private final WorldEdit worldEdit;

    public BrushCommands(WorldEdit worldEdit) {
        Preconditions.checkNotNull((Object)worldEdit);
        this.worldEdit = worldEdit;
    }

    @Command(name="sphere", aliases={"s"}, desc="Choose the sphere brush")
    @CommandPermissions(value={"worldedit.brush.sphere"})
    public void sphereBrush(Player player, LocalSession session, Pattern pattern, double radius, boolean hollow) throws WorldEditException {
        this.worldEdit.checkMaxBrushRadius(radius);
        BrushTool tool = session.getBrushTool(player.getItemInHand(HandSide.MAIN_HAND).getType());
        tool.setFill(pattern);
        tool.setSize(radius);
        if (hollow) {
            tool.setBrush(new HollowSphereBrush(), "worldedit.brush.sphere");
        } else {
            tool.setBrush(new SphereBrush(), "worldedit.brush.sphere");
        }
        player.print(String.format("Sphere brush shape equipped (%.0f).", radius));
    }

    @Command(name="cylinder", aliases={"cyl", "c"}, desc="Choose the cylinder brush")
    @CommandPermissions(value={"worldedit.brush.cylinder"})
    public void cylinderBrush(Player player, LocalSession session, Pattern pattern, double radius, int height, boolean hollow) throws WorldEditException {
        this.worldEdit.checkMaxBrushRadius(radius);
        this.worldEdit.checkMaxBrushRadius(height);
        BrushTool tool = session.getBrushTool(player.getItemInHand(HandSide.MAIN_HAND).getType());
        tool.setFill(pattern);
        tool.setSize(radius);
        if (hollow) {
            tool.setBrush(new HollowCylinderBrush(height), "worldedit.brush.cylinder");
        } else {
            tool.setBrush(new CylinderBrush(height), "worldedit.brush.cylinder");
        }
        player.print(String.format("Cylinder brush shape equipped (%.0f by %d).", radius, height));
    }

    @Command(name="clipboard", aliases={"copy"}, desc="Choose the clipboard brush")
    @CommandPermissions(value={"worldedit.brush.clipboard"})
    public void clipboardBrush(Player player, LocalSession session, boolean ignoreAir, boolean usingOrigin, boolean pasteEntities, boolean pasteBiomes, Mask sourceMask) throws WorldEditException {
        ClipboardHolder holder = session.getClipboard();
        Clipboard clipboard = holder.getClipboard();
        BlockVector3 size = clipboard.getDimensions();
        this.worldEdit.checkMaxBrushRadius((double)size.getBlockX() / 2.0 - 1.0);
        this.worldEdit.checkMaxBrushRadius((double)size.getBlockY() / 2.0 - 1.0);
        this.worldEdit.checkMaxBrushRadius((double)size.getBlockZ() / 2.0 - 1.0);
        BrushTool tool = session.getBrushTool(player.getItemInHand(HandSide.MAIN_HAND).getType());
        tool.setBrush(new ClipboardBrush(holder, ignoreAir, usingOrigin, pasteEntities, pasteBiomes, sourceMask), "worldedit.brush.clipboard");
        player.print("Clipboard brush shape equipped.");
    }

    @Command(name="smooth", desc="Choose the terrain softener brush", descFooter="Example: '/brush smooth 2 4 grass_block,dirt,stone'")
    @CommandPermissions(value={"worldedit.brush.smooth"})
    public void smoothBrush(Player player, LocalSession session, double radius, int iterations, Mask mask) throws WorldEditException {
        this.worldEdit.checkMaxBrushRadius(radius);
        BrushTool tool = session.getBrushTool(player.getItemInHand(HandSide.MAIN_HAND).getType());
        tool.setSize(radius);
        tool.setBrush(new SmoothBrush(iterations, mask), "worldedit.brush.smooth");
        player.print(String.format("Smooth brush equipped (%.0f x %dx, using %s).", radius, iterations, mask == null ? "any block" : "filter"));
    }

    @Command(name="extinguish", aliases={"ex"}, desc="Shortcut fire extinguisher brush")
    @CommandPermissions(value={"worldedit.brush.ex"})
    public void extinguishBrush(Player player, LocalSession session, double radius) throws WorldEditException {
        this.worldEdit.checkMaxBrushRadius(radius);
        BrushTool tool = session.getBrushTool(player.getItemInHand(HandSide.MAIN_HAND).getType());
        BlockPattern fill = new BlockPattern(BlockTypes.AIR.getDefaultState());
        tool.setFill(fill);
        tool.setSize(radius);
        tool.setMask(new BlockTypeMask((Extent)new RequestExtent(), BlockTypes.FIRE));
        tool.setBrush(new SphereBrush(), "worldedit.brush.ex");
        player.print(String.format("Extinguisher equipped (%.0f).", radius));
    }

    @Command(name="gravity", aliases={"grav"}, desc="Gravity brush, simulates the effect of gravity")
    @CommandPermissions(value={"worldedit.brush.gravity"})
    public void gravityBrush(Player player, LocalSession session, double radius, boolean fromMaxY) throws WorldEditException {
        this.worldEdit.checkMaxBrushRadius(radius);
        BrushTool tool = session.getBrushTool(player.getItemInHand(HandSide.MAIN_HAND).getType());
        tool.setSize(radius);
        tool.setBrush(new GravityBrush(fromMaxY), "worldedit.brush.gravity");
        player.print(String.format("Gravity brush equipped (%.0f).", radius));
    }

    @Command(name="butcher", aliases={"kill"}, desc="Butcher brush, kills mobs within a radius")
    @CommandPermissions(value={"worldedit.brush.butcher"})
    public void butcherBrush(Player player, LocalSession session, double radius, boolean killPets, boolean killNpcs, boolean killGolems, boolean killAnimals, boolean killAmbient, boolean killWithName, boolean killFriendly, boolean killArmorStands) throws WorldEditException {
        LocalConfiguration config = this.worldEdit.getConfiguration();
        double maxRadius = config.maxBrushRadius;
        if (player.hasPermission("worldedit.butcher")) {
            maxRadius = Math.max(config.maxBrushRadius, config.butcherMaxRadius);
        }
        if (radius > maxRadius) {
            player.printError("Maximum allowed brush radius: " + maxRadius);
            return;
        }
        CreatureButcher flags = new CreatureButcher(player);
        flags.or(63, killFriendly);
        flags.or(1, killPets, "worldedit.butcher.pets");
        flags.or(2, killNpcs, "worldedit.butcher.npcs");
        flags.or(8, killGolems, "worldedit.butcher.golems");
        flags.or(4, killAnimals, "worldedit.butcher.animals");
        flags.or(16, killAmbient, "worldedit.butcher.ambient");
        flags.or(32, killWithName, "worldedit.butcher.tagged");
        flags.or(64, killArmorStands, "worldedit.butcher.armorstands");
        BrushTool tool = session.getBrushTool(player.getItemInHand(HandSide.MAIN_HAND).getType());
        tool.setSize(radius);
        tool.setBrush(new ButcherBrush(flags), "worldedit.brush.butcher");
        player.print(String.format("Butcher brush equipped (%.0f).", radius));
    }

    @Command(name="deform", desc="Deform brush, applies an expression to an area")
    @CommandPermissions(value={"worldedit.brush.deform"})
    public void deform(Player player, LocalSession localSession, RegionFactory shape, double radius, String expression, boolean useRawCoords, boolean usePlacement) throws WorldEditException {
        Deform deform = new Deform(expression);
        if (useRawCoords) {
            deform.setMode(Deform.Mode.RAW_COORD);
        } else if (usePlacement) {
            deform.setMode(Deform.Mode.OFFSET);
            deform.setOffset(localSession.getPlacementPosition(player).toVector3());
        }
        BrushCommands.setOperationBasedBrush(player, localSession, radius, deform, shape, "worldedit.brush.deform");
    }

    @Command(name="set", desc="Set brush, sets all blocks in the area")
    @CommandPermissions(value={"worldedit.brush.set"})
    public void set(Player player, LocalSession localSession, RegionFactory shape, double radius, Pattern pattern) throws WorldEditException {
        BrushCommands.setOperationBasedBrush(player, localSession, radius, new Apply(new ReplaceFactory(pattern)), shape, "worldedit.brush.set");
    }

    @Command(name="forest", desc="Forest brush, creates a forest in the area")
    @CommandPermissions(value={"worldedit.brush.forest"})
    public void forest(Player player, LocalSession localSession, RegionFactory shape, double radius, double density, TreeGenerator.TreeType type) throws WorldEditException {
        BrushCommands.setOperationBasedBrush(player, localSession, radius, new Paint(new TreeGeneratorFactory(type), density / 100.0), shape, "worldedit.brush.forest");
    }

    @Command(name="raise", desc="Raise brush, raise all blocks by one")
    @CommandPermissions(value={"worldedit.brush.raise"})
    public void raise(Player player, LocalSession localSession, RegionFactory shape, double radius) throws WorldEditException {
        BrushCommands.setOperationBasedBrush(player, localSession, radius, new Deform("y-=1"), shape, "worldedit.brush.raise");
    }

    @Command(name="lower", desc="Lower brush, lower all blocks by one")
    @CommandPermissions(value={"worldedit.brush.lower"})
    public void lower(Player player, LocalSession localSession, RegionFactory shape, double radius) throws WorldEditException {
        BrushCommands.setOperationBasedBrush(player, localSession, radius, new Deform("y+=1"), shape, "worldedit.brush.lower");
    }

    static void setOperationBasedBrush(Player player, LocalSession session, double radius, Contextual<? extends Operation> factory, RegionFactory shape, String permission) throws WorldEditException {
        WorldEdit.getInstance().checkMaxBrushRadius(radius);
        BrushTool tool = session.getBrushTool(player.getItemInHand(HandSide.MAIN_HAND).getType());
        tool.setSize(radius);
        tool.setFill(null);
        tool.setBrush(new OperationFactoryBrush(factory, shape, session), permission);
        player.print("Set brush to " + factory);
    }
}

