/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.BrushCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.regions.factory.RegionFactory;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandPart;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class BrushCommandsRegistration
implements CommandRegistration<BrushCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<Pattern> pattern_Key = Key.of(Pattern.class);
    private static final Key<Double> double_Key = Key.of(Double.class);
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Mask> mask_Key = Key.of(Mask.class);
    private static final Key<RegionFactory> regionFactory_Key = Key.of(RegionFactory.class);
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<TreeGenerator.TreeType> treeType_Key = Key.of(TreeGenerator.TreeType.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private CommandManager commandManager;
    private BrushCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument patternPart = CommandParts.arg(TranslatableComponent.of("pattern"), TextComponent.of("The pattern of blocks to set")).defaultsTo((Iterable<String>)ImmutableList.of()).ofTypes((Collection<Key<?>>)ImmutableList.of(pattern_Key)).build();
    private final CommandArgument radiusPart = CommandParts.arg(TranslatableComponent.of("radius"), TextComponent.of("The radius of the sphere")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"2")).ofTypes((Collection<Key<?>>)ImmutableList.of(double_Key)).build();
    private final NoArgCommandFlag hollowPart = CommandParts.flag('h', TextComponent.of("Create hollow spheres instead")).build();
    private final CommandArgument radiusPart2 = CommandParts.arg(TranslatableComponent.of("radius"), TextComponent.of("The radius of the cylinder")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"2")).ofTypes((Collection<Key<?>>)ImmutableList.of(double_Key)).build();
    private final CommandArgument heightPart = CommandParts.arg(TranslatableComponent.of("height"), TextComponent.of("The height of the cylinder")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"1")).ofTypes((Collection<Key<?>>)ImmutableList.of(integer_Key)).build();
    private final NoArgCommandFlag hollowPart2 = CommandParts.flag('h', TextComponent.of("Create hollow cylinders instead")).build();
    private final NoArgCommandFlag ignoreAirPart = CommandParts.flag('a', TextComponent.of("Don't paste air from the clipboard")).build();
    private final NoArgCommandFlag usingOriginPart = CommandParts.flag('o', TextComponent.of("Paste using clipboard origin, instead of being centered at the target location")).build();
    private final NoArgCommandFlag pasteEntitiesPart = CommandParts.flag('e', TextComponent.of("Paste entities if available")).build();
    private final NoArgCommandFlag pasteBiomesPart = CommandParts.flag('b', TextComponent.of("Paste biomes if available")).build();
    private final ArgAcceptingCommandFlag sourceMaskPart = CommandParts.flag('m', TextComponent.of("Skip blocks matching this mask in the clipboard")).withRequiredArg().argNamed(TranslatableComponent.of("sourceMask")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"")).ofTypes((Collection<Key<?>>)ImmutableList.of(mask_Key)).build();
    private final CommandArgument radiusPart3 = CommandParts.arg(TranslatableComponent.of("radius"), TextComponent.of("The radius to sample for softening")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"2")).ofTypes((Collection<Key<?>>)ImmutableList.of(double_Key)).build();
    private final CommandArgument iterationsPart = CommandParts.arg(TranslatableComponent.of("iterations"), TextComponent.of("The number of iterations to perform")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"4")).ofTypes((Collection<Key<?>>)ImmutableList.of(integer_Key)).build();
    private final CommandArgument maskPart = CommandParts.arg(TranslatableComponent.of("mask"), TextComponent.of("The mask of blocks to use for the heightmap")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"")).ofTypes((Collection<Key<?>>)ImmutableList.of(mask_Key)).build();
    private final CommandArgument radiusPart4 = CommandParts.arg(TranslatableComponent.of("radius"), TextComponent.of("The radius to extinguish")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"5")).ofTypes((Collection<Key<?>>)ImmutableList.of(double_Key)).build();
    private final CommandArgument radiusPart5 = CommandParts.arg(TranslatableComponent.of("radius"), TextComponent.of("The radius to apply gravity in")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"5")).ofTypes((Collection<Key<?>>)ImmutableList.of(double_Key)).build();
    private final NoArgCommandFlag fromMaxYPart = CommandParts.flag('h', TextComponent.of("Affect blocks starting at max Y, rather than the target location Y + radius")).build();
    private final CommandArgument radiusPart6 = CommandParts.arg(TranslatableComponent.of("radius"), TextComponent.of("Radius to kill mobs in")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"5")).ofTypes((Collection<Key<?>>)ImmutableList.of(double_Key)).build();
    private final NoArgCommandFlag killPetsPart = CommandParts.flag('p', TextComponent.of("Also kill pets")).build();
    private final NoArgCommandFlag killNpcsPart = CommandParts.flag('n', TextComponent.of("Also kill NPCs")).build();
    private final NoArgCommandFlag killGolemsPart = CommandParts.flag('g', TextComponent.of("Also kill golems")).build();
    private final NoArgCommandFlag killAnimalsPart = CommandParts.flag('a', TextComponent.of("Also kill animals")).build();
    private final NoArgCommandFlag killAmbientPart = CommandParts.flag('b', TextComponent.of("Also kill ambient mobs")).build();
    private final NoArgCommandFlag killWithNamePart = CommandParts.flag('t', TextComponent.of("Also kill mobs with name tags")).build();
    private final NoArgCommandFlag killFriendlyPart = CommandParts.flag('f', TextComponent.of("Also kill all friendly mobs (Applies the flags `-abgnpt`)")).build();
    private final NoArgCommandFlag killArmorStandsPart = CommandParts.flag('r', TextComponent.of("Also destroy armor stands")).build();
    private final CommandArgument shapePart = CommandParts.arg(TranslatableComponent.of("shape"), TextComponent.of("The shape of the region")).defaultsTo((Iterable<String>)ImmutableList.of()).ofTypes((Collection<Key<?>>)ImmutableList.of(regionFactory_Key)).build();
    private final CommandArgument radiusPart7 = CommandParts.arg(TranslatableComponent.of("radius"), TextComponent.of("The size of the brush")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"5")).ofTypes((Collection<Key<?>>)ImmutableList.of(double_Key)).build();
    private final CommandArgument expressionPart = CommandParts.arg(TranslatableComponent.of("expression"), TextComponent.of("Expression to apply")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"y-=0.2")).ofTypes((Collection<Key<?>>)ImmutableList.of(string_Key)).build();
    private final NoArgCommandFlag useRawCoordsPart = CommandParts.flag('r', TextComponent.of("Use the game's coordinate origin")).build();
    private final NoArgCommandFlag usePlacementPart = CommandParts.flag('o', TextComponent.of("Use the placement position as the origin")).build();
    private final CommandArgument densityPart = CommandParts.arg(TranslatableComponent.of("density"), TextComponent.of("The density of the brush")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"20")).ofTypes((Collection<Key<?>>)ImmutableList.of(double_Key)).build();
    private final CommandArgument typePart = CommandParts.arg(TranslatableComponent.of("type"), TextComponent.of("The type of tree to use")).defaultsTo((Iterable<String>)ImmutableList.of()).ofTypes((Collection<Key<?>>)ImmutableList.of(treeType_Key)).build();

    private BrushCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static BrushCommandsRegistration builder() {
        return new BrushCommandsRegistration();
    }

    public BrushCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public BrushCommandsRegistration containerInstance(BrushCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public BrushCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public BrushCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    @Override
    public void build() {
        this.commandManager.register("sphere", b -> {
            b.aliases((Collection<String>)ImmutableList.of((Object)"s"));
            b.description(TextComponent.of("Choose the sphere brush"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.patternPart, (Object)this.radiusPart, (Object)this.hollowPart));
            b.action(this::sphere);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, "sphereBrush", Player.class, LocalSession.class, Pattern.class, Double.TYPE, Boolean.TYPE);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("cylinder", b -> {
            b.aliases((Collection<String>)ImmutableList.of((Object)"cyl", (Object)"c"));
            b.description(TextComponent.of("Choose the cylinder brush"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.patternPart, (Object)this.radiusPart2, (Object)this.heightPart, (Object)this.hollowPart2));
            b.action(this::cylinder);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, "cylinderBrush", Player.class, LocalSession.class, Pattern.class, Double.TYPE, Integer.TYPE, Boolean.TYPE);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("clipboard", b -> {
            b.aliases((Collection<String>)ImmutableList.of((Object)"copy"));
            b.description(TextComponent.of("Choose the clipboard brush"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.ignoreAirPart, (Object)this.usingOriginPart, (Object)this.pasteEntitiesPart, (Object)this.pasteBiomesPart, (Object)this.sourceMaskPart));
            b.action(this::clipboard);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, "clipboardBrush", Player.class, LocalSession.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Mask.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("smooth", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Choose the terrain softener brush"));
            b.footer(TextComponent.of("Example: '/brush smooth 2 4 grass_block,dirt,stone'"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.radiusPart3, (Object)this.iterationsPart, (Object)this.maskPart));
            b.action(this::smooth);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, "smoothBrush", Player.class, LocalSession.class, Double.TYPE, Integer.TYPE, Mask.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("extinguish", b -> {
            b.aliases((Collection<String>)ImmutableList.of((Object)"ex"));
            b.description(TextComponent.of("Shortcut fire extinguisher brush"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.radiusPart4));
            b.action(this::extinguish);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, "extinguishBrush", Player.class, LocalSession.class, Double.TYPE);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("gravity", b -> {
            b.aliases((Collection<String>)ImmutableList.of((Object)"grav"));
            b.description(TextComponent.of("Gravity brush, simulates the effect of gravity"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.radiusPart5, (Object)this.fromMaxYPart));
            b.action(this::gravity);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, "gravityBrush", Player.class, LocalSession.class, Double.TYPE, Boolean.TYPE);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("butcher", b -> {
            b.aliases((Collection<String>)ImmutableList.of((Object)"kill"));
            b.description(TextComponent.of("Butcher brush, kills mobs within a radius"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.radiusPart6, (Object)this.killPetsPart, (Object)this.killNpcsPart, (Object)this.killGolemsPart, (Object)this.killAnimalsPart, (Object)this.killAmbientPart, (Object)this.killWithNamePart, (Object)this.killFriendlyPart, (Object)this.killArmorStandsPart));
            b.action(this::butcher);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, "butcherBrush", Player.class, LocalSession.class, Double.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("deform", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Deform brush, applies an expression to an area"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.shapePart, (Object)this.radiusPart7, (Object)this.expressionPart, (Object)this.useRawCoordsPart, (Object)this.usePlacementPart));
            b.action(this::deform);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, "deform", Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, String.class, Boolean.TYPE, Boolean.TYPE);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("set", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Set brush, sets all blocks in the area"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.shapePart, (Object)this.radiusPart7, (Object)this.patternPart));
            b.action(this::set);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, "set", Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, Pattern.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("forest", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Forest brush, creates a forest in the area"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.shapePart, (Object)this.radiusPart7, (Object)this.densityPart, (Object)this.typePart));
            b.action(this::forest);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, "forest", Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, Double.TYPE, TreeGenerator.TreeType.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("raise", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Raise brush, raise all blocks by one"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.shapePart, (Object)this.radiusPart7));
            b.action(this::raise);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, "raise", Player.class, LocalSession.class, RegionFactory.class, Double.TYPE);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("lower", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Lower brush, lower all blocks by one"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.shapePart, (Object)this.radiusPart7));
            b.action(this::lower);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, "lower", Player.class, LocalSession.class, RegionFactory.class, Double.TYPE);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int sphere(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, "sphereBrush", Player.class, LocalSession.class, Pattern.class, Double.TYPE, Boolean.TYPE);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.sphereBrush(this.player(parameters), this.session(parameters), this.pattern(parameters), this.radius(parameters), this.hollow(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int cylinder(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, "cylinderBrush", Player.class, LocalSession.class, Pattern.class, Double.TYPE, Integer.TYPE, Boolean.TYPE);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.cylinderBrush(this.player(parameters), this.session(parameters), this.pattern(parameters), this.radius2(parameters), this.height(parameters), this.hollow2(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int clipboard(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, "clipboardBrush", Player.class, LocalSession.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Mask.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.clipboardBrush(this.player(parameters), this.session(parameters), this.ignoreAir(parameters), this.usingOrigin(parameters), this.pasteEntities(parameters), this.pasteBiomes(parameters), this.sourceMask(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int smooth(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, "smoothBrush", Player.class, LocalSession.class, Double.TYPE, Integer.TYPE, Mask.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.smoothBrush(this.player(parameters), this.session(parameters), this.radius3(parameters), this.iterations(parameters), this.mask(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int extinguish(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, "extinguishBrush", Player.class, LocalSession.class, Double.TYPE);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.extinguishBrush(this.player(parameters), this.session(parameters), this.radius4(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int gravity(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, "gravityBrush", Player.class, LocalSession.class, Double.TYPE, Boolean.TYPE);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.gravityBrush(this.player(parameters), this.session(parameters), this.radius5(parameters), this.fromMaxY(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int butcher(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, "butcherBrush", Player.class, LocalSession.class, Double.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.butcherBrush(this.player(parameters), this.session(parameters), this.radius6(parameters), this.killPets(parameters), this.killNpcs(parameters), this.killGolems(parameters), this.killAnimals(parameters), this.killAmbient(parameters), this.killWithName(parameters), this.killFriendly(parameters), this.killArmorStands(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int deform(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, "deform", Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, String.class, Boolean.TYPE, Boolean.TYPE);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.deform(this.player(parameters), this.localSession(parameters), this.shape(parameters), this.radius7(parameters), this.expression(parameters), this.useRawCoords(parameters), this.usePlacement(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int set(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, "set", Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, Pattern.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.set(this.player(parameters), this.localSession(parameters), this.shape(parameters), this.radius7(parameters), this.pattern(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int forest(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, "forest", Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, Double.TYPE, TreeGenerator.TreeType.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.forest(this.player(parameters), this.localSession(parameters), this.shape(parameters), this.radius7(parameters), this.density(parameters), this.type(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int raise(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, "raise", Player.class, LocalSession.class, RegionFactory.class, Double.TYPE);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.raise(this.player(parameters), this.localSession(parameters), this.shape(parameters), this.radius7(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int lower(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, "lower", Player.class, LocalSession.class, RegionFactory.class, Double.TYPE);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.lower(this.player(parameters), this.localSession(parameters), this.shape(parameters), this.radius7(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private Pattern pattern(CommandParameters parameters) {
        return this.patternPart.value(parameters).asSingle(pattern_Key);
    }

    private Player player(CommandParameters parameters) {
        return RegistrationUtil.requireOptional(player_Key, "player", parameters.injectedValue(player_Key));
    }

    private int height(CommandParameters parameters) {
        return this.heightPart.value(parameters).asSingle(integer_Key);
    }

    private LocalSession session(CommandParameters parameters) {
        return RegistrationUtil.requireOptional(localSession_Key, "session", parameters.injectedValue(localSession_Key));
    }

    private Mask sourceMask(CommandParameters parameters) {
        return this.sourceMaskPart.value(parameters).asSingle(mask_Key);
    }

    private RegionFactory shape(CommandParameters parameters) {
        return this.shapePart.value(parameters).asSingle(regionFactory_Key);
    }

    private double density(CommandParameters parameters) {
        return this.densityPart.value(parameters).asSingle(double_Key);
    }

    private boolean killAnimals(CommandParameters parameters) {
        return this.killAnimalsPart.in(parameters);
    }

    private boolean killNpcs(CommandParameters parameters) {
        return this.killNpcsPart.in(parameters);
    }

    private double radius4(CommandParameters parameters) {
        return this.radiusPart4.value(parameters).asSingle(double_Key);
    }

    private boolean usingOrigin(CommandParameters parameters) {
        return this.usingOriginPart.in(parameters);
    }

    private boolean killFriendly(CommandParameters parameters) {
        return this.killFriendlyPart.in(parameters);
    }

    private boolean fromMaxY(CommandParameters parameters) {
        return this.fromMaxYPart.in(parameters);
    }

    private boolean pasteEntities(CommandParameters parameters) {
        return this.pasteEntitiesPart.in(parameters);
    }

    private double radius5(CommandParameters parameters) {
        return this.radiusPart5.value(parameters).asSingle(double_Key);
    }

    private double radius3(CommandParameters parameters) {
        return this.radiusPart3.value(parameters).asSingle(double_Key);
    }

    private double radius2(CommandParameters parameters) {
        return this.radiusPart2.value(parameters).asSingle(double_Key);
    }

    private boolean pasteBiomes(CommandParameters parameters) {
        return this.pasteBiomesPart.in(parameters);
    }

    private int iterations(CommandParameters parameters) {
        return this.iterationsPart.value(parameters).asSingle(integer_Key);
    }

    private double radius6(CommandParameters parameters) {
        return this.radiusPart6.value(parameters).asSingle(double_Key);
    }

    private boolean killArmorStands(CommandParameters parameters) {
        return this.killArmorStandsPart.in(parameters);
    }

    private String expression(CommandParameters parameters) {
        return this.expressionPart.value(parameters).asSingle(string_Key);
    }

    private double radius7(CommandParameters parameters) {
        return this.radiusPart7.value(parameters).asSingle(double_Key);
    }

    private TreeGenerator.TreeType type(CommandParameters parameters) {
        return this.typePart.value(parameters).asSingle(treeType_Key);
    }

    private boolean hollow2(CommandParameters parameters) {
        return this.hollowPart2.in(parameters);
    }

    private boolean killPets(CommandParameters parameters) {
        return this.killPetsPart.in(parameters);
    }

    private boolean hollow(CommandParameters parameters) {
        return this.hollowPart.in(parameters);
    }

    private double radius(CommandParameters parameters) {
        return this.radiusPart.value(parameters).asSingle(double_Key);
    }

    private boolean killWithName(CommandParameters parameters) {
        return this.killWithNamePart.in(parameters);
    }

    private boolean useRawCoords(CommandParameters parameters) {
        return this.useRawCoordsPart.in(parameters);
    }

    private boolean ignoreAir(CommandParameters parameters) {
        return this.ignoreAirPart.in(parameters);
    }

    private boolean killGolems(CommandParameters parameters) {
        return this.killGolemsPart.in(parameters);
    }

    private boolean killAmbient(CommandParameters parameters) {
        return this.killAmbientPart.in(parameters);
    }

    private boolean usePlacement(CommandParameters parameters) {
        return this.usePlacementPart.in(parameters);
    }

    private Mask mask(CommandParameters parameters) {
        return this.maskPart.value(parameters).asSingle(mask_Key);
    }

    private LocalSession localSession(CommandParameters parameters) {
        return RegistrationUtil.requireOptional(localSession_Key, "localSession", parameters.injectedValue(localSession_Key));
    }
}

