/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.Lists;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.Logging;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.function.block.BlockReplace;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.annotation.Direction;
import com.sk89q.worldedit.internal.annotation.Selection;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.selector.CuboidRegionSelector;
import com.sk89q.worldedit.session.ClipboardHolder;
import java.util.ArrayList;
import org.enginehub.piston.annotation.Command;

public class ClipboardCommands {
    @Command(name="/copy", desc="Copy the selection to the clipboard")
    @CommandPermissions(value={"worldedit.clipboard.copy"})
    public void copy(Player player, LocalSession session, EditSession editSession, @Selection Region region, boolean copyEntities, boolean copyBiomes, Mask mask) throws WorldEditException {
        BlockArrayClipboard clipboard = new BlockArrayClipboard(region);
        clipboard.setOrigin(session.getPlacementPosition(player));
        ForwardExtentCopy copy = new ForwardExtentCopy(editSession, region, clipboard, region.getMinimumPoint());
        copy.setCopyingEntities(copyEntities);
        copy.setCopyingBiomes(copyBiomes);
        if (mask != null) {
            copy.setSourceMask(mask);
        }
        Operations.completeLegacy(copy);
        session.setClipboard(new ClipboardHolder(clipboard));
        ArrayList messages = Lists.newArrayList();
        copy.addStatusMessages(messages);
        messages.forEach(player::print);
    }

    @Command(name="/cut", desc="Cut the selection to the clipboard", descFooter="WARNING: Cutting and pasting entities cannot be undone!")
    @CommandPermissions(value={"worldedit.clipboard.cut"})
    @Logging(value=Logging.LogMode.REGION)
    public void cut(Player player, LocalSession session, EditSession editSession, @Selection Region region, Pattern leavePattern, boolean copyEntities, boolean copyBiomes, Mask mask) throws WorldEditException {
        BlockArrayClipboard clipboard = new BlockArrayClipboard(region);
        clipboard.setOrigin(session.getPlacementPosition(player));
        ForwardExtentCopy copy = new ForwardExtentCopy(editSession, region, clipboard, region.getMinimumPoint());
        copy.setSourceFunction(new BlockReplace(editSession, leavePattern));
        copy.setCopyingEntities(copyEntities);
        copy.setRemovingEntities(true);
        copy.setCopyingBiomes(copyBiomes);
        if (mask != null) {
            copy.setSourceMask(mask);
        }
        Operations.completeLegacy(copy);
        session.setClipboard(new ClipboardHolder(clipboard));
        ArrayList messages = Lists.newArrayList();
        copy.addStatusMessages(messages);
        messages.forEach(player::print);
    }

    @Command(name="/paste", desc="Paste the clipboard's contents")
    @CommandPermissions(value={"worldedit.clipboard.paste"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void paste(Player player, LocalSession session, EditSession editSession, boolean ignoreAirBlocks, boolean atOrigin, boolean selectPasted, boolean pasteEntities, boolean pasteBiomes, Mask sourceMask) throws WorldEditException {
        ClipboardHolder holder = session.getClipboard();
        Clipboard clipboard = holder.getClipboard();
        Region region = clipboard.getRegion();
        BlockVector3 to = atOrigin ? clipboard.getOrigin() : session.getPlacementPosition(player);
        Operation operation = holder.createPaste(editSession).to(to).ignoreAirBlocks(ignoreAirBlocks).copyBiomes(pasteBiomes).copyEntities(pasteEntities).maskSource(sourceMask).build();
        Operations.completeLegacy(operation);
        if (selectPasted) {
            BlockVector3 clipboardOffset = clipboard.getRegion().getMinimumPoint().subtract(clipboard.getOrigin());
            Vector3 realTo = to.toVector3().add(holder.getTransform().apply(clipboardOffset.toVector3()));
            Vector3 max = realTo.add(holder.getTransform().apply(region.getMaximumPoint().subtract(region.getMinimumPoint()).toVector3()));
            CuboidRegionSelector selector = new CuboidRegionSelector(player.getWorld(), realTo.toBlockPoint(), max.toBlockPoint());
            session.setRegionSelector(player.getWorld(), selector);
            selector.learnChanges();
            selector.explainRegionAdjust(player, session);
        }
        player.print("The clipboard has been pasted at " + to);
        ArrayList messages = Lists.newArrayList();
        operation.addStatusMessages(messages);
        messages.forEach(player::print);
    }

    @Command(name="/rotate", desc="Rotate the contents of the clipboard", descFooter="Non-destructively rotate the contents of the clipboard.\nAngles are provided in degrees and a positive angle will result in a clockwise rotation. Multiple rotations can be stacked. Interpolation is not performed so angles should be a multiple of 90 degrees.\n")
    @CommandPermissions(value={"worldedit.clipboard.rotate"})
    public void rotate(Player player, LocalSession session, double yRotate, double xRotate, double zRotate) throws WorldEditException {
        if (Math.abs(yRotate % 90.0) > 0.001 || Math.abs(xRotate % 90.0) > 0.001 || Math.abs(zRotate % 90.0) > 0.001) {
            player.printDebug("Note: Interpolation is not yet supported, so angles that are multiples of 90 is recommended.");
        }
        ClipboardHolder holder = session.getClipboard();
        AffineTransform transform = new AffineTransform();
        transform = transform.rotateY(-yRotate);
        transform = transform.rotateX(-xRotate);
        transform = transform.rotateZ(-zRotate);
        holder.setTransform(holder.getTransform().combine(transform));
        player.print("The clipboard copy has been rotated.");
    }

    @Command(name="/flip", desc="Flip the contents of the clipboard across the origin")
    @CommandPermissions(value={"worldedit.clipboard.flip"})
    public void flip(Player player, LocalSession session, @Direction BlockVector3 direction) throws WorldEditException {
        ClipboardHolder holder = session.getClipboard();
        AffineTransform transform = new AffineTransform();
        transform = transform.scale(direction.abs().multiply(-2).add(1, 1, 1).toVector3());
        holder.setTransform(holder.getTransform().combine(transform));
        player.print("The clipboard copy has been flipped.");
    }

    @Command(name="clearclipboard", desc="Clear your clipboard")
    @CommandPermissions(value={"worldedit.clipboard.clear"})
    public void clearClipboard(Player player, LocalSession session) throws WorldEditException {
        session.setClipboard(null);
        player.print("Clipboard cleared.");
    }
}

