/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.entity.Player;
import org.enginehub.piston.annotation.Command;

public class HistoryCommands {
    private final WorldEdit worldEdit;

    public HistoryCommands(WorldEdit worldEdit) {
        Preconditions.checkNotNull((Object)worldEdit);
        this.worldEdit = worldEdit;
    }

    @Command(name="undo", aliases={"/undo"}, desc="Undoes the last action (from history)")
    @CommandPermissions(value={"worldedit.history.undo"})
    public void undo(Player player, LocalSession session, int times, String playerName) throws WorldEditException {
        times = Math.max(1, times);
        for (int i = 0; i < times; ++i) {
            EditSession undone;
            LocalSession undoSession = session;
            if (playerName != null) {
                player.checkPermission("worldedit.history.undo.other");
                LocalSession sess = this.worldEdit.getSessionManager().findByName(playerName);
                if (sess == null) {
                    player.printError("Unable to find session for " + playerName);
                    break;
                }
                undoSession = session;
            }
            if ((undone = undoSession.undo(undoSession.getBlockBag(player), player)) == null) {
                player.printError("Nothing left to undo.");
                break;
            }
            player.print("Undo successful.");
            this.worldEdit.flushBlockBag(player, undone);
        }
    }

    @Command(name="redo", aliases={"/redo"}, desc="Redoes the last action (from history)")
    @CommandPermissions(value={"worldedit.history.redo"})
    public void redo(Player player, LocalSession session, int times, String playerName) throws WorldEditException {
        times = Math.max(1, times);
        for (int i = 0; i < times; ++i) {
            EditSession redone;
            LocalSession redoSession = session;
            if (playerName != null) {
                player.checkPermission("worldedit.history.redo.other");
                LocalSession sess = this.worldEdit.getSessionManager().findByName(playerName);
                if (sess == null) {
                    player.printError("Unable to find session for " + playerName);
                    break;
                }
                redoSession = session;
            }
            if ((redone = redoSession.redo(redoSession.getBlockBag(player), player)) == null) {
                player.printError("Nothing left to redo.");
                break;
            }
            player.print("Redo successful.");
            this.worldEdit.flushBlockBag(player, redone);
        }
    }

    @Command(name="clearhistory", aliases={"/clearhistory"}, desc="Clear your history")
    @CommandPermissions(value={"worldedit.history.clear"})
    public void clearHistory(Player player, LocalSession session) throws WorldEditException {
        session.clearHistory();
        player.print("History cleared.");
    }
}

