/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.world.snapshot.InvalidSnapshotException;
import com.sk89q.worldedit.world.snapshot.Snapshot;
import com.sk89q.worldedit.world.storage.MissingWorldException;
import java.io.File;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.enginehub.piston.annotation.Command;

public class SnapshotCommands {
    private static final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z");
    private final WorldEdit we;

    public SnapshotCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(name="list", desc="List snapshots")
    @CommandPermissions(value={"worldedit.snapshots.list"})
    public void list(Player player, int num) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        if (config.snapshotRepo == null) {
            player.printError("Snapshot/backup restore is not configured.");
            return;
        }
        try {
            List<Snapshot> snapshots = config.snapshotRepo.getSnapshots(true, player.getWorld().getName());
            if (!snapshots.isEmpty()) {
                num = Math.min(40, Math.max(5, num));
                player.print("Snapshots for world: '" + player.getWorld().getName() + "'");
                for (int i = 0; i < Math.min(num, snapshots.size()); i = (int)((byte)(i + 1))) {
                    player.print(i + 1 + ". " + snapshots.get(i).getName());
                }
                player.print("Use /snap use [snapshot] or /snap use latest.");
            } else {
                player.printError("No snapshots are available. See console for details.");
                File dir = config.snapshotRepo.getDirectory();
                try {
                    WorldEdit.logger.info("WorldEdit found no snapshots: looked in: " + dir.getCanonicalPath());
                }
                catch (IOException e) {
                    WorldEdit.logger.info("WorldEdit found no snapshots: looked in (NON-RESOLVABLE PATH - does it exist?): " + dir.getPath());
                }
            }
        }
        catch (MissingWorldException ex) {
            player.printError("No snapshots were found for this world.");
        }
    }

    @Command(name="use", desc="Choose a snapshot to use")
    @CommandPermissions(value={"worldedit.snapshots.restore"})
    public void use(Player player, LocalSession session, String name) throws WorldEditException {
        block8: {
            LocalConfiguration config = this.we.getConfiguration();
            if (config.snapshotRepo == null) {
                player.printError("Snapshot/backup restore is not configured.");
                return;
            }
            if (name.equalsIgnoreCase("latest")) {
                try {
                    Snapshot snapshot = config.snapshotRepo.getDefaultSnapshot(player.getWorld().getName());
                    if (snapshot != null) {
                        session.setSnapshot(null);
                        player.print("Now using newest snapshot.");
                        break block8;
                    }
                    player.printError("No snapshots were found.");
                }
                catch (MissingWorldException ex) {
                    player.printError("No snapshots were found for this world.");
                }
            } else {
                try {
                    session.setSnapshot(config.snapshotRepo.getSnapshot(name));
                    player.print("Snapshot set to: " + name);
                }
                catch (InvalidSnapshotException e) {
                    player.printError("That snapshot does not exist or is not available.");
                }
            }
        }
    }

    @Command(name="sel", desc="Choose the snapshot based on the list id")
    @CommandPermissions(value={"worldedit.snapshots.restore"})
    public void sel(Player player, LocalSession session, int index) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        if (config.snapshotRepo == null) {
            player.printError("Snapshot/backup restore is not configured.");
            return;
        }
        if (index < 1) {
            player.printError("Invalid index, must be equal or higher then 1.");
            return;
        }
        try {
            List<Snapshot> snapshots = config.snapshotRepo.getSnapshots(true, player.getWorld().getName());
            if (snapshots.size() < index) {
                player.printError("Invalid index, must be between 1 and " + snapshots.size() + ".");
                return;
            }
            Snapshot snapshot = snapshots.get(index - 1);
            if (snapshot == null) {
                player.printError("That snapshot does not exist or is not available.");
                return;
            }
            session.setSnapshot(snapshot);
            player.print("Snapshot set to: " + snapshot.getName());
        }
        catch (MissingWorldException e) {
            player.printError("No snapshots were found for this world.");
        }
    }

    @Command(name="before", desc="Choose the nearest snapshot before a date")
    @CommandPermissions(value={"worldedit.snapshots.restore"})
    public void before(Player player, LocalSession session, ZonedDateTime date) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        if (config.snapshotRepo == null) {
            player.printError("Snapshot/backup restore is not configured.");
            return;
        }
        try {
            Snapshot snapshot = config.snapshotRepo.getSnapshotBefore(date, player.getWorld().getName());
            if (snapshot == null) {
                player.printError("Couldn't find a snapshot before " + dateFormat.withZone(session.getTimeZone()).format(date) + ".");
            } else {
                session.setSnapshot(snapshot);
                player.print("Snapshot set to: " + snapshot.getName());
            }
        }
        catch (MissingWorldException ex) {
            player.printError("No snapshots were found for this world.");
        }
    }

    @Command(name="after", desc="Choose the nearest snapshot after a date")
    @CommandPermissions(value={"worldedit.snapshots.restore"})
    public void after(Player player, LocalSession session, ZonedDateTime date) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        if (config.snapshotRepo == null) {
            player.printError("Snapshot/backup restore is not configured.");
            return;
        }
        try {
            Snapshot snapshot = config.snapshotRepo.getSnapshotAfter(date, player.getWorld().getName());
            if (snapshot == null) {
                player.printError("Couldn't find a snapshot after " + dateFormat.withZone(session.getTimeZone()).format(date) + ".");
            } else {
                session.setSnapshot(snapshot);
                player.print("Snapshot set to: " + snapshot.getName());
            }
        }
        catch (MissingWorldException ex) {
            player.printError("No snapshots were found for this world.");
        }
    }
}

