/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.argument;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.entity.Player;
import java.util.concurrent.locks.StampedLock;

public class EditSessionHolder {
    private final StampedLock lock = new StampedLock();
    private final WorldEdit worldEdit;
    private final Player player;
    private EditSession session;

    public EditSessionHolder(WorldEdit worldEdit, Player player) {
        this.worldEdit = worldEdit;
        this.player = player;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EditSession getSession() {
        long stamp = this.lock.tryOptimisticRead();
        EditSession result = this.session;
        if (!this.lock.validate(stamp)) {
            stamp = this.lock.readLock();
            try {
                result = this.session;
            }
            finally {
                this.lock.unlockRead(stamp);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EditSession getOrCreateSession() {
        EditSession result = this.getSession();
        if (result != null) {
            return result;
        }
        long stamp = this.lock.writeLock();
        try {
            result = this.session;
            if (result != null) {
                EditSession editSession = result;
                return editSession;
            }
            LocalSession localSession = this.worldEdit.getSessionManager().get(this.player);
            EditSession editSession = localSession.createEditSession(this.player);
            editSession.enableStandardMode();
            localSession.tellVersion(this.player);
            EditSession editSession2 = this.session = editSession;
            return editSession2;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }
}

