/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.argument;

import com.google.common.collect.ImmutableSet;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.command.argument.SelectorChoice;
import com.sk89q.worldedit.util.TreeGenerator;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.converter.ArgumentConverter;
import org.enginehub.piston.converter.MultiKeyConverter;
import org.enginehub.piston.inject.Key;

public class EnumConverter {
    public static void register(CommandManager commandManager) {
        commandManager.registerConverter(Key.of(SelectorChoice.class), EnumConverter.basic(SelectorChoice.class, SelectorChoice.UNKNOWN));
        commandManager.registerConverter(Key.of(TreeGenerator.TreeType.class), EnumConverter.full(TreeGenerator.TreeType.class, t -> ImmutableSet.copyOf(t.lookupKeys), null));
        commandManager.registerConverter(Key.of(EditSession.ReorderMode.class), EnumConverter.full(EditSession.ReorderMode.class, r -> ImmutableSet.of((Object)r.getDisplayName()), null));
    }

    private static <E extends Enum<E>> ArgumentConverter<E> basic(Class<E> enumClass) {
        return EnumConverter.full(enumClass, e -> ImmutableSet.of((Object)e.name()), null);
    }

    private static <E extends Enum<E>> ArgumentConverter<E> basic(Class<E> enumClass, E unknownValue) {
        return EnumConverter.full(enumClass, e -> ImmutableSet.of((Object)e.name()), unknownValue);
    }

    private static <E extends Enum<E>> ArgumentConverter<E> full(Class<E> enumClass, Function<E, Set<String>> lookupKeys, @Nullable E unknownValue) {
        return MultiKeyConverter.from(EnumSet.allOf(enumClass), lookupKeys, unknownValue);
    }

    private EnumConverter() {
    }
}

