/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.buffer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.Masks;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.Map;

public class ExtentBuffer
extends AbstractDelegateExtent {
    private final Map<BlockVector3, BaseBlock> buffer = Maps.newHashMap();
    private final Mask mask;

    public ExtentBuffer(Extent delegate) {
        this(delegate, Masks.alwaysTrue());
    }

    public ExtentBuffer(Extent delegate, Mask mask) {
        super(delegate);
        Preconditions.checkNotNull((Object)delegate);
        Preconditions.checkNotNull((Object)mask);
        this.mask = mask;
    }

    @Override
    public BlockState getBlock(BlockVector3 position) {
        if (this.mask.test(position)) {
            return this.getOrDefault(position).toImmutableState();
        }
        return super.getBlock(position);
    }

    @Override
    public BaseBlock getFullBlock(BlockVector3 position) {
        if (this.mask.test(position)) {
            return this.getOrDefault(position);
        }
        return super.getFullBlock(position);
    }

    private BaseBlock getOrDefault(BlockVector3 position) {
        return this.buffer.computeIfAbsent(position, pos -> this.getExtent().getFullBlock((BlockVector3)pos));
    }

    @Override
    public <T extends BlockStateHolder<T>> boolean setBlock(BlockVector3 location, T block) throws WorldEditException {
        if (this.mask.test(location)) {
            this.buffer.put(location, block.toBaseBlock());
            return true;
        }
        return false;
    }
}

