/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.reorder;

import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.RunContext;
import com.sk89q.worldedit.function.operation.SetLocatedBlocks;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.collection.LocatedBlockList;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class ChunkBatchingExtent
extends AbstractDelegateExtent {
    private static final Comparator<BlockVector2> REGION_OPTIMIZED_SORT = Comparator.comparing(vec -> vec.divide(32), BlockVector2.COMPARING_GRID_ARRANGEMENT).thenComparing(BlockVector2.COMPARING_GRID_ARRANGEMENT);
    private final SortedMap<BlockVector2, LocatedBlockList> batches = new TreeMap<BlockVector2, LocatedBlockList>(REGION_OPTIMIZED_SORT);
    private boolean enabled;

    public ChunkBatchingExtent(Extent extent) {
        this(extent, true);
    }

    public ChunkBatchingExtent(Extent extent, boolean enabled) {
        super(extent);
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean commitRequired() {
        return this.enabled;
    }

    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 location, B block) throws WorldEditException {
        if (!this.enabled) {
            return this.getExtent().setBlock(location, block);
        }
        BlockVector2 chunkPos = BlockVector2.at(location.getBlockX() >> 4, location.getBlockZ() >> 4);
        this.batches.computeIfAbsent(chunkPos, k -> new LocatedBlockList()).add(location, block);
        return true;
    }

    @Override
    protected Operation commitBefore() {
        if (!this.commitRequired()) {
            return null;
        }
        return new Operation(){
            private Iterator<LocatedBlockList> batchIterator;

            @Override
            public Operation resume(RunContext run) throws WorldEditException {
                if (this.batchIterator == null) {
                    this.batchIterator = ChunkBatchingExtent.this.batches.values().iterator();
                }
                if (!this.batchIterator.hasNext()) {
                    return null;
                }
                new SetLocatedBlocks(ChunkBatchingExtent.this.getExtent(), this.batchIterator.next()).resume(run);
                this.batchIterator.remove();
                return this;
            }

            @Override
            public void cancel() {
            }

            @Override
            public void addStatusMessages(List<String> messages) {
            }
        };
    }
}

