/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.sk89q.worldedit.forge.ForgeAdapter;
import com.sk89q.worldedit.forge.ForgeBlockMaterial;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.registry.BlockMaterial;
import com.sk89q.worldedit.world.registry.BundledBlockRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.state.IProperty;
import net.minecraftforge.fml.loading.FMLLoader;

public class ForgeBlockRegistry
extends BundledBlockRegistry {
    private Map<Material, ForgeBlockMaterial> materialMap = new HashMap<Material, ForgeBlockMaterial>();

    @Override
    @Nullable
    public String getName(BlockType blockType) {
        Block block = ForgeAdapter.adapt(blockType);
        if (block != null && FMLLoader.getDist().isClient()) {
            return block.func_200291_n().func_150254_d();
        }
        return super.getName(blockType);
    }

    @Override
    public BlockMaterial getMaterial(BlockType blockType) {
        Block block = ForgeAdapter.adapt(blockType);
        if (block == null) {
            return super.getMaterial(blockType);
        }
        return this.materialMap.computeIfAbsent(block.func_176223_P().func_185904_a(), m -> new ForgeBlockMaterial((Material)m, super.getMaterial(blockType)));
    }

    @Override
    public Map<String, ? extends Property<?>> getProperties(BlockType blockType) {
        Block block = ForgeAdapter.adapt(blockType);
        TreeMap map = new TreeMap();
        Collection propertyKeys = block.func_176223_P().func_206869_a();
        for (IProperty key : propertyKeys) {
            map.put(key.func_177701_a(), ForgeAdapter.adaptProperty(key));
        }
        return map;
    }
}

