/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.metadata.EntityProperties;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.forge.ForgeAdapter;
import com.sk89q.worldedit.forge.ForgeEntityProperties;
import com.sk89q.worldedit.forge.NBTConverter;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.NullWorld;
import com.sk89q.worldedit.world.entity.EntityTypes;
import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

class ForgeEntity
implements com.sk89q.worldedit.entity.Entity {
    private final WeakReference<Entity> entityRef;

    ForgeEntity(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        this.entityRef = new WeakReference<Entity>(entity);
    }

    @Override
    public BaseEntity getState() {
        Entity entity = (Entity)this.entityRef.get();
        if (entity != null) {
            ResourceLocation id = entity.func_200600_R().getRegistryName();
            if (id != null) {
                NBTTagCompound tag = new NBTTagCompound();
                entity.func_189511_e(tag);
                return new BaseEntity(EntityTypes.get(id.toString()), NBTConverter.fromNative(tag));
            }
            return null;
        }
        return null;
    }

    @Override
    public Location getLocation() {
        Entity entity = (Entity)this.entityRef.get();
        if (entity != null) {
            Vector3 position = Vector3.at(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            float yaw = entity.field_70177_z;
            float pitch = entity.field_70125_A;
            return new Location((Extent)ForgeAdapter.adapt(entity.field_70170_p), position, yaw, pitch);
        }
        return new Location(NullWorld.getInstance());
    }

    @Override
    public boolean setLocation(Location location) {
        return false;
    }

    @Override
    public Extent getExtent() {
        Entity entity = (Entity)this.entityRef.get();
        if (entity != null) {
            return ForgeAdapter.adapt(entity.field_70170_p);
        }
        return NullWorld.getInstance();
    }

    @Override
    public boolean remove() {
        Entity entity = (Entity)this.entityRef.get();
        if (entity != null) {
            entity.func_70106_y();
        }
        return true;
    }

    @Override
    @Nullable
    public <T> T getFacet(Class<? extends T> cls) {
        Entity entity = (Entity)this.entityRef.get();
        if (entity != null) {
            if (EntityProperties.class.isAssignableFrom(cls)) {
                return (T)new ForgeEntityProperties(entity);
            }
            return null;
        }
        return null;
    }
}

