/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.forge.ForgeAdapter;
import com.sk89q.worldedit.forge.ForgeEntity;
import com.sk89q.worldedit.forge.NBTConverter;
import com.sk89q.worldedit.forge.TileEntityUtils;
import com.sk89q.worldedit.forge.WorldEditFakePlayer;
import com.sk89q.worldedit.internal.Constants;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.world.AbstractWorld;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.item.ItemTypes;
import com.sk89q.worldedit.world.weather.WeatherType;
import com.sk89q.worldedit.world.weather.WeatherTypes;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.AnvilSaveHandler;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.feature.BigBrownMushroomFeature;
import net.minecraft.world.gen.feature.BigRedMushroomFeature;
import net.minecraft.world.gen.feature.BigTreeFeature;
import net.minecraft.world.gen.feature.BirchTreeFeature;
import net.minecraft.world.gen.feature.CanopyTreeFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.JungleTreeFeature;
import net.minecraft.world.gen.feature.MegaJungleFeature;
import net.minecraft.world.gen.feature.MegaPineTree;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.PointyTaigaTreeFeature;
import net.minecraft.world.gen.feature.SavannaTreeFeature;
import net.minecraft.world.gen.feature.ShrubFeature;
import net.minecraft.world.gen.feature.SwampTreeFeature;
import net.minecraft.world.gen.feature.TallTaigaTreeFeature;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;

public class ForgeWorld
extends AbstractWorld {
    private static final Random random = new Random();
    private static final int UPDATE = 1;
    private static final int NOTIFY = 2;
    private static final IBlockState JUNGLE_LOG = Blocks.field_196620_N.func_176223_P();
    private static final IBlockState JUNGLE_LEAF = (IBlockState)Blocks.field_196648_Z.func_176223_P().func_206870_a((IProperty)BlockLeaves.field_208495_b, (Comparable)Boolean.TRUE);
    private static final IBlockState JUNGLE_SHRUB = (IBlockState)Blocks.field_196642_W.func_176223_P().func_206870_a((IProperty)BlockLeaves.field_208495_b, (Comparable)Boolean.TRUE);
    private final WeakReference<World> worldRef;

    ForgeWorld(World world) {
        Preconditions.checkNotNull((Object)world);
        this.worldRef = new WeakReference<World>(world);
    }

    public World getWorldChecked() throws WorldEditException {
        World world = (World)this.worldRef.get();
        if (world != null) {
            return world;
        }
        throw new WorldReferenceLostException("The reference to the world was lost (i.e. the world may have been unloaded)");
    }

    public World getWorld() {
        World world = (World)this.worldRef.get();
        if (world != null) {
            return world;
        }
        throw new RuntimeException("The reference to the world was lost (i.e. the world may have been unloaded)");
    }

    @Override
    public String getName() {
        return this.getWorld().func_72912_H().func_76065_j();
    }

    @Override
    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 position, B block, boolean notifyAndLight) throws WorldEditException {
        CompoundTag tag;
        boolean successful;
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull(block);
        World world = this.getWorldChecked();
        int x = position.getBlockX();
        int y = position.getBlockY();
        int z = position.getBlockZ();
        Chunk chunk = world.func_72964_e(x >> 4, z >> 4);
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState old = chunk.func_180495_p(pos);
        IBlockState newState = ForgeAdapter.adapt(block.toImmutableState());
        IBlockState successState = chunk.func_177436_a(pos, newState, false);
        boolean bl = successful = successState != null;
        if ((successful || old == newState) && block instanceof BaseBlock && (tag = ((BaseBlock)block).getNbtData()) != null) {
            NBTTagCompound nativeTag = NBTConverter.toNative(tag);
            nativeTag.func_74778_a("id", ((BaseBlock)block).getNbtId());
            TileEntityUtils.setTileEntity(world, position, nativeTag);
        }
        if (successful && notifyAndLight) {
            world.func_175664_x(pos);
            world.markAndNotifyBlock(pos, chunk, old, newState, 3);
        }
        return successful;
    }

    @Override
    public boolean notifyAndLightBlock(BlockVector3 position, BlockState previousType) throws WorldEditException {
        BlockPos pos = new BlockPos(position.getX(), position.getY(), position.getZ());
        this.getWorld().func_184138_a(pos, ForgeAdapter.adapt(previousType), this.getWorld().func_180495_p(pos), 3);
        return true;
    }

    @Override
    public int getBlockLightLevel(BlockVector3 position) {
        Preconditions.checkNotNull((Object)position);
        return this.getWorld().func_201696_r(ForgeAdapter.toBlockPos(position));
    }

    @Override
    public boolean clearContainerBlockContents(BlockVector3 position) {
        Preconditions.checkNotNull((Object)position);
        TileEntity tile = this.getWorld().func_175625_s(ForgeAdapter.toBlockPos(position));
        if (tile instanceof IInventory) {
            IInventory inv = (IInventory)tile;
            int size = inv.func_70302_i_();
            for (int i = 0; i < size; ++i) {
                inv.func_70299_a(i, ItemStack.field_190927_a);
            }
            return true;
        }
        return false;
    }

    @Override
    public BiomeType getBiome(BlockVector2 position) {
        Preconditions.checkNotNull((Object)position);
        return ForgeAdapter.adapt(this.getWorld().getBiomeBody(new BlockPos(position.getBlockX(), 0, position.getBlockZ())));
    }

    @Override
    public boolean setBiome(BlockVector2 position, BiomeType biome) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)biome);
        Chunk chunk = this.getWorld().func_175726_f(new BlockPos(position.getBlockX(), 0, position.getBlockZ()));
        if (chunk.func_177410_o()) {
            chunk.func_201590_e()[(position.getBlockZ() & 0xF) << 4 | position.getBlockX() & 0xF] = ForgeAdapter.adapt(biome);
            return true;
        }
        return false;
    }

    @Override
    public boolean useItem(BlockVector3 position, BaseItem item, Direction face) {
        ItemStack stack = ForgeAdapter.adapt(new BaseItemStack(item.getType(), item.getNbtData(), 1));
        World world = this.getWorld();
        WorldEditFakePlayer fakePlayer = new WorldEditFakePlayer((WorldServer)world);
        fakePlayer.func_184611_a(EnumHand.MAIN_HAND, stack);
        fakePlayer.func_70012_b(position.getBlockX(), position.getBlockY(), position.getBlockZ(), (float)face.toVector().toYaw(), (float)face.toVector().toPitch());
        BlockPos blockPos = ForgeAdapter.toBlockPos(position);
        EnumFacing enumFacing = ForgeAdapter.adapt(face);
        ItemUseContext itemUseContext = new ItemUseContext((EntityPlayer)fakePlayer, stack, blockPos, enumFacing, (float)blockPos.func_177958_n(), (float)blockPos.func_177956_o(), (float)blockPos.func_177952_p());
        EnumActionResult used = stack.func_196084_a(itemUseContext);
        if (used != EnumActionResult.SUCCESS) {
            used = this.getWorld().func_180495_p(blockPos).func_196943_a(world, blockPos, (EntityPlayer)fakePlayer, EnumHand.MAIN_HAND, enumFacing, (float)blockPos.func_177958_n(), (float)blockPos.func_177956_o(), (float)blockPos.func_177952_p()) ? EnumActionResult.SUCCESS : stack.func_77973_b().func_77659_a(world, (EntityPlayer)fakePlayer, EnumHand.MAIN_HAND).func_188397_a();
        }
        return used == EnumActionResult.SUCCESS;
    }

    @Override
    public void dropItem(Vector3 position, BaseItemStack item) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull((Object)item);
        if (item.getType() == ItemTypes.AIR) {
            return;
        }
        EntityItem entity = new EntityItem(this.getWorld(), position.getX(), position.getY(), position.getZ(), ForgeAdapter.adapt(item));
        entity.func_174867_a(10);
        this.getWorld().func_72838_d((Entity)entity);
    }

    @Override
    public void simulateBlockMine(BlockVector3 position) {
        BlockPos pos = ForgeAdapter.toBlockPos(position);
        IBlockState state = this.getWorld().func_180495_p(pos);
        state.func_196949_c(this.getWorld(), pos, 0);
        this.getWorld().func_175698_g(pos);
    }

    @Override
    public boolean regenerate(Region region, EditSession editSession) {
        IChunkProvider provider = this.getWorld().func_72863_F();
        if (!(provider instanceof ChunkProviderServer)) {
            return false;
        }
        File saveFolder = Files.createTempDir();
        saveFolder.deleteOnExit();
        try {
            WorldServer originalWorld = (WorldServer)this.getWorld();
            MinecraftServer server = originalWorld.func_73046_m();
            AnvilSaveHandler saveHandler = new AnvilSaveHandler(saveFolder, originalWorld.func_72860_G().func_75765_b().getName(), server, server.func_195563_aC());
            WorldServer freshWorld = new WorldServer(server, (ISaveHandler)saveHandler, originalWorld.func_175693_T(), originalWorld.func_72912_H(), originalWorld.field_73011_w.func_186058_p(), originalWorld.field_72984_F).func_212251_i__();
            CuboidRegion expandedPreGen = new CuboidRegion(region.getMinimumPoint().subtract(16, 0, 16), region.getMaximumPoint().add(16, 0, 16));
            for (BlockVector2 chunk : expandedPreGen.getChunks()) {
                freshWorld.func_72964_e(chunk.getBlockX(), chunk.getBlockZ());
            }
            ForgeWorld from = new ForgeWorld((World)freshWorld);
            for (BlockVector3 vec : region) {
                editSession.setBlock(vec, from.getFullBlock(vec));
            }
        }
        catch (MaxChangedBlocksException e) {
            throw new RuntimeException(e);
        }
        finally {
            saveFolder.delete();
        }
        return true;
    }

    @Nullable
    private static Feature<NoFeatureConfig> createTreeFeatureGenerator(TreeGenerator.TreeType type) {
        switch (type) {
            case TREE: {
                return new TreeFeature(true);
            }
            case BIG_TREE: {
                return new BigTreeFeature(true);
            }
            case PINE: 
            case REDWOOD: {
                return new PointyTaigaTreeFeature();
            }
            case TALL_REDWOOD: {
                return new TallTaigaTreeFeature(true);
            }
            case BIRCH: {
                return new BirchTreeFeature(true, false);
            }
            case JUNGLE: {
                return new MegaJungleFeature(true, 10, 20, JUNGLE_LOG, JUNGLE_LEAF);
            }
            case SMALL_JUNGLE: {
                return new JungleTreeFeature(true, 4 + random.nextInt(7), JUNGLE_LOG, JUNGLE_LEAF, false);
            }
            case SHORT_JUNGLE: {
                return new JungleTreeFeature(true, 4 + random.nextInt(7), JUNGLE_LOG, JUNGLE_LEAF, true);
            }
            case JUNGLE_BUSH: {
                return new ShrubFeature(JUNGLE_LOG, JUNGLE_SHRUB);
            }
            case RED_MUSHROOM: {
                return new BigBrownMushroomFeature();
            }
            case BROWN_MUSHROOM: {
                return new BigRedMushroomFeature();
            }
            case SWAMP: {
                return new SwampTreeFeature();
            }
            case ACACIA: {
                return new SavannaTreeFeature(true);
            }
            case DARK_OAK: {
                return new CanopyTreeFeature(true);
            }
            case MEGA_REDWOOD: {
                return new MegaPineTree(false, random.nextBoolean());
            }
            case TALL_BIRCH: {
                return new BirchTreeFeature(true, true);
            }
            case RANDOM: {
                return ForgeWorld.createTreeFeatureGenerator(TreeGenerator.TreeType.values()[ThreadLocalRandom.current().nextInt(TreeGenerator.TreeType.values().length)]);
            }
        }
        return null;
    }

    @Override
    public boolean generateTree(TreeGenerator.TreeType type, EditSession editSession, BlockVector3 position) throws MaxChangedBlocksException {
        Feature<NoFeatureConfig> generator = ForgeWorld.createTreeFeatureGenerator(type);
        return generator != null && generator.func_212245_a((IWorld)this.getWorld(), this.getWorld().func_72863_F().func_201711_g(), random, ForgeAdapter.toBlockPos(position), (IFeatureConfig)new NoFeatureConfig());
    }

    @Override
    public void checkLoadedChunk(BlockVector3 pt) {
        this.getWorld().func_175726_f(ForgeAdapter.toBlockPos(pt));
    }

    @Override
    public void fixAfterFastMode(Iterable<BlockVector2> chunks) {
        this.fixLighting(chunks);
    }

    @Override
    public void fixLighting(Iterable<BlockVector2> chunks) {
        World world = this.getWorld();
        for (BlockVector2 chunk : chunks) {
            world.func_72964_e(chunk.getBlockX(), chunk.getBlockZ()).func_76613_n();
        }
    }

    @Override
    public boolean playEffect(Vector3 position, int type, int data) {
        this.getWorld().func_175718_b(type, ForgeAdapter.toBlockPos(position.toBlockPoint()), data);
        return true;
    }

    @Override
    public WeatherType getWeather() {
        WorldInfo info = this.getWorld().func_72912_H();
        if (info.func_76061_m()) {
            return WeatherTypes.THUNDER_STORM;
        }
        if (info.func_76059_o()) {
            return WeatherTypes.RAIN;
        }
        return WeatherTypes.CLEAR;
    }

    @Override
    public long getRemainingWeatherDuration() {
        WorldInfo info = this.getWorld().func_72912_H();
        if (info.func_76061_m()) {
            return info.func_76071_n();
        }
        if (info.func_76059_o()) {
            return info.func_76083_p();
        }
        return info.func_176133_A();
    }

    @Override
    public void setWeather(WeatherType weatherType) {
        this.setWeather(weatherType, 0L);
    }

    @Override
    public void setWeather(WeatherType weatherType, long duration) {
        WorldInfo info = this.getWorld().func_72912_H();
        if (weatherType == WeatherTypes.THUNDER_STORM) {
            info.func_176142_i(0);
            info.func_76069_a(true);
            info.func_76090_f((int)duration);
        } else if (weatherType == WeatherTypes.RAIN) {
            info.func_176142_i(0);
            info.func_76084_b(true);
            info.func_76080_g((int)duration);
        } else if (weatherType == WeatherTypes.CLEAR) {
            info.func_76084_b(false);
            info.func_76069_a(false);
            info.func_176142_i((int)duration);
        }
    }

    @Override
    public int getMaxY() {
        return this.getWorld().func_72800_K() - 1;
    }

    @Override
    public BlockVector3 getSpawnPosition() {
        return ForgeAdapter.adapt(this.getWorld().func_175694_M());
    }

    @Override
    public BlockState getBlock(BlockVector3 position) {
        IBlockState mcState = this.getWorld().func_72964_e(position.getBlockX() >> 4, position.getBlockZ() >> 4).func_186032_a(position.getBlockX(), position.getBlockY(), position.getBlockZ());
        return ForgeAdapter.adapt(mcState);
    }

    @Override
    public BaseBlock getFullBlock(BlockVector3 position) {
        BlockPos pos = new BlockPos(position.getBlockX(), position.getBlockY(), position.getBlockZ());
        TileEntity tile = this.getWorld().func_175625_s(pos);
        if (tile != null) {
            return this.getBlock(position).toBaseBlock(NBTConverter.fromNative(TileEntityUtils.copyNbtData(tile)));
        }
        return this.getBlock(position).toBaseBlock();
    }

    @Override
    public int hashCode() {
        return this.getWorld().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof ForgeWorld) {
            ForgeWorld other = (ForgeWorld)o;
            World otherWorld = (World)other.worldRef.get();
            World thisWorld = (World)this.worldRef.get();
            return otherWorld != null && otherWorld.equals(thisWorld);
        }
        if (o instanceof com.sk89q.worldedit.world.World) {
            return ((com.sk89q.worldedit.world.World)o).getName().equals(this.getName());
        }
        return false;
    }

    @Override
    public List<? extends com.sk89q.worldedit.entity.Entity> getEntities(Region region) {
        ArrayList<ForgeEntity> entities = new ArrayList<ForgeEntity>();
        for (Entity entity : this.getWorld().field_72996_f) {
            if (!region.contains(BlockVector3.at(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v))) continue;
            entities.add(new ForgeEntity(entity));
        }
        return entities;
    }

    @Override
    public List<? extends com.sk89q.worldedit.entity.Entity> getEntities() {
        ArrayList<ForgeEntity> entities = new ArrayList<ForgeEntity>();
        for (Entity entity : this.getWorld().field_72996_f) {
            entities.add(new ForgeEntity(entity));
        }
        return entities;
    }

    @Override
    @Nullable
    public com.sk89q.worldedit.entity.Entity createEntity(Location location, BaseEntity entity) {
        World world = this.getWorld();
        Entity createdEntity = EntityType.func_200714_a((World)world, (ResourceLocation)new ResourceLocation(entity.getType().getId()));
        if (createdEntity != null) {
            CompoundTag nativeTag = entity.getNbtData();
            if (nativeTag != null) {
                NBTTagCompound tag = NBTConverter.toNative(entity.getNbtData());
                for (String name : Constants.NO_COPY_ENTITY_NBT_FIELDS) {
                    tag.func_82580_o(name);
                }
                createdEntity.func_70020_e(tag);
            }
            createdEntity.func_70012_b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            world.func_72838_d(createdEntity);
            return new ForgeEntity(createdEntity);
        }
        return null;
    }

    private static class WorldReferenceLostException
    extends WorldEditException {
        private WorldReferenceLostException(String message) {
            super(message);
        }
    }
}

