/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.math.BlockVector3;
import javax.annotation.Nullable;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

final class TileEntityUtils {
    private TileEntityUtils() {
    }

    private static void updateForSet(NBTTagCompound tag, BlockVector3 position) {
        Preconditions.checkNotNull((Object)tag);
        Preconditions.checkNotNull((Object)position);
        tag.func_74782_a("x", (INBTBase)new NBTTagInt(position.getBlockX()));
        tag.func_74782_a("y", (INBTBase)new NBTTagInt(position.getBlockY()));
        tag.func_74782_a("z", (INBTBase)new NBTTagInt(position.getBlockZ()));
    }

    static void setTileEntity(World world, BlockVector3 position, @Nullable NBTTagCompound tag) {
        if (tag != null) {
            TileEntityUtils.updateForSet(tag, position);
            TileEntity tileEntity = TileEntity.func_203403_c((NBTTagCompound)tag);
            if (tileEntity != null) {
                world.func_175690_a(new BlockPos(position.getBlockX(), position.getBlockY(), position.getBlockZ()), tileEntity);
            }
        }
    }

    public static NBTTagCompound copyNbtData(TileEntity tile) {
        NBTTagCompound tag = new NBTTagCompound();
        tile.func_189515_b(tag);
        return tag;
    }
}

