/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge.net.handler;

import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.forge.ForgeAdapter;
import com.sk89q.worldedit.forge.ForgePlayer;
import com.sk89q.worldedit.forge.ForgeWorldEdit;
import com.sk89q.worldedit.forge.net.handler.PacketHandlerUtil;
import java.nio.charset.Charset;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.ThreadQuickExitException;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.event.EventNetworkChannel;

public final class WECUIPacketHandler {
    public static final Charset UTF_8_CHARSET = Charset.forName("UTF-8");
    private static final int PROTOCOL_VERSION = 1;
    private static EventNetworkChannel HANDLER = PacketHandlerUtil.buildLenientHandler("cui", 1).eventNetworkChannel();

    private WECUIPacketHandler() {
    }

    public static void init() {
        HANDLER.addListener(WECUIPacketHandler::onPacketData);
        HANDLER.addListener(WECUIPacketHandler::callProcessPacket);
    }

    public static void onPacketData(NetworkEvent.ServerCustomPayloadEvent event) {
        EntityPlayerMP player = ((NetworkEvent.Context)event.getSource().get()).getSender();
        LocalSession session = ForgeWorldEdit.inst.getSession(player);
        if (session.hasCUISupport()) {
            return;
        }
        String text = event.getPayload().toString(UTF_8_CHARSET);
        ForgePlayer actor = ForgeAdapter.adaptPlayer(player);
        session.handleCUIInitializationMessage(text, actor);
        session.describeCUI(actor);
    }

    public static void callProcessPacket(NetworkEvent.ClientCustomPayloadEvent event) {
        try {
            new SPacketCustomPayload(new ResourceLocation("worldedit", "cui"), event.getPayload()).func_148833_a((INetHandlerPlayClient)Minecraft.func_71410_x().field_71439_g.field_71174_a);
        }
        catch (ThreadQuickExitException threadQuickExitException) {
            // empty catch block
        }
    }
}

