/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.generator;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.function.pattern.BlockPattern;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.pattern.RandomPattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;

public class FloraGenerator
implements RegionFunction {
    private final EditSession editSession;
    private boolean biomeAware = false;
    private final Pattern desertPattern = FloraGenerator.getDesertPattern();
    private final Pattern temperatePattern = FloraGenerator.getTemperatePattern();

    public FloraGenerator(EditSession editSession) {
        this.editSession = editSession;
    }

    public boolean isBiomeAware() {
        return this.biomeAware;
    }

    public void setBiomeAware(boolean biomeAware) {
        if (biomeAware) {
            throw new IllegalArgumentException("Cannot enable biome-aware mode; not yet implemented");
        }
    }

    public static Pattern getDesertPattern() {
        RandomPattern pattern = new RandomPattern();
        pattern.add(new BlockPattern(BlockTypes.DEAD_BUSH.getDefaultState()), 30.0);
        pattern.add(new BlockPattern(BlockTypes.CACTUS.getDefaultState()), 20.0);
        pattern.add(new BlockPattern(BlockTypes.AIR.getDefaultState()), 300.0);
        return pattern;
    }

    public static Pattern getTemperatePattern() {
        RandomPattern pattern = new RandomPattern();
        pattern.add(new BlockPattern(BlockTypes.GRASS.getDefaultState()), 300.0);
        pattern.add(new BlockPattern(BlockTypes.POPPY.getDefaultState()), 5.0);
        pattern.add(new BlockPattern(BlockTypes.DANDELION.getDefaultState()), 5.0);
        return pattern;
    }

    @Override
    public boolean apply(BlockVector3 position) throws WorldEditException {
        BlockState block = this.editSession.getBlock(position);
        if (block.getBlockType() == BlockTypes.GRASS_BLOCK) {
            this.editSession.setBlock(position.add(0, 1, 0), this.temperatePattern.apply(position));
            return true;
        }
        if (block.getBlockType() == BlockTypes.SAND) {
            this.editSession.setBlock(position.add(0, 1, 0), this.desertPattern.apply(position));
            return true;
        }
        return false;
    }
}

