/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.internal.cui;

import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.regions.selector.CuboidRegionSelector;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.HashMap;
import javax.annotation.Nullable;

public class ServerCUIHandler {
    private ServerCUIHandler() {
    }

    @Nullable
    public static BaseBlock createStructureBlock(Player player) {
        int length;
        int height;
        int width;
        int posZ;
        int posY;
        int posX;
        LocalSession session = WorldEdit.getInstance().getSessionManager().get(player);
        RegionSelector regionSelector = session.getRegionSelector(player.getWorld());
        if (regionSelector instanceof CuboidRegionSelector) {
            CuboidRegion region;
            if (regionSelector.isDefined()) {
                try {
                    region = ((CuboidRegionSelector)regionSelector).getRegion();
                    posX = region.getMinimumPoint().getBlockX();
                    posY = region.getMinimumPoint().getBlockY();
                    posZ = region.getMinimumPoint().getBlockZ();
                    width = region.getWidth();
                    height = region.getHeight();
                    length = region.getLength();
                }
                catch (IncompleteRegionException e) {
                    e.printStackTrace();
                    return null;
                }
            } else {
                BlockVector3 point;
                region = ((CuboidRegionSelector)regionSelector).getIncompleteRegion();
                if (region.getPos1() != null) {
                    point = region.getPos1();
                } else if (region.getPos2() != null) {
                    point = region.getPos2();
                } else {
                    return null;
                }
                posX = point.getBlockX();
                posY = point.getBlockY();
                posZ = point.getBlockZ();
                width = 1;
                height = 1;
                length = 1;
            }
        } else {
            return null;
        }
        if (width > 32 || length > 32 || height > 32) {
            return null;
        }
        double rotX = player.getLocation().getYaw();
        double rotY = player.getLocation().getPitch();
        double xz = Math.cos(Math.toRadians(rotY));
        int x = (int)(player.getLocation().getX() - -xz * Math.sin(Math.toRadians(rotX)) * 12.0);
        int z = (int)(player.getLocation().getZ() - xz * Math.cos(Math.toRadians(rotX)) * 12.0);
        int y = Math.max(0, Math.min(Math.min(255, posY + 32), posY + 3));
        HashMap<String, Tag> structureTag = new HashMap<String, Tag>();
        if (Math.abs(posX -= x) > 32 || Math.abs(posY -= y) > 32 || Math.abs(posZ -= z) > 32) {
            return null;
        }
        structureTag.put("name", new StringTag("worldedit:" + player.getName()));
        structureTag.put("author", new StringTag(player.getName()));
        structureTag.put("metadata", new StringTag(""));
        structureTag.put("x", new IntTag(x));
        structureTag.put("y", new IntTag(y));
        structureTag.put("z", new IntTag(z));
        structureTag.put("posX", new IntTag(posX));
        structureTag.put("posY", new IntTag(posY));
        structureTag.put("posZ", new IntTag(posZ));
        structureTag.put("sizeX", new IntTag(width));
        structureTag.put("sizeY", new IntTag(height));
        structureTag.put("sizeZ", new IntTag(length));
        structureTag.put("rotation", new StringTag("NONE"));
        structureTag.put("mirror", new StringTag("NONE"));
        structureTag.put("mode", new StringTag("SAVE"));
        structureTag.put("ignoreEntities", new ByteTag(1));
        structureTag.put("showboundingbox", new ByteTag(1));
        structureTag.put("id", new StringTag(BlockTypes.STRUCTURE_BLOCK.getId()));
        return BlockTypes.STRUCTURE_BLOCK.getDefaultState().toBaseBlock(new CompoundTag(structureTag));
    }
}

