/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.internal.util;

import java.util.Objects;

public final class Substring {
    private final String substring;
    private final int start;
    private final int end;

    public static Substring from(String original, int start) {
        return Substring.wrap(original.substring(start), start, original.length());
    }

    public static Substring from(String original, int start, int end) {
        return Substring.wrap(original.substring(start, end), start, end);
    }

    public static Substring wrap(String substring, int start, int end) {
        return new Substring(substring, start, end);
    }

    private Substring(String substring, int start, int end) {
        this.substring = substring;
        this.start = start;
        this.end = end;
    }

    public String getSubstring() {
        return this.substring;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Substring substring1 = (Substring)o;
        return this.start == substring1.start && this.end == substring1.end && this.substring.equals(substring1.substring);
    }

    public int hashCode() {
        return Objects.hash(this.substring, this.start, this.end);
    }

    public String toString() {
        return "Substring{substring='" + this.substring + "',start=" + this.start + ",end=" + this.end + "}";
    }
}

