/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.formatting.component;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.sk89q.worldedit.internal.command.CommandUtil;
import com.sk89q.worldedit.util.formatting.component.InvalidComponentException;
import com.sk89q.worldedit.util.formatting.component.MessageBox;
import com.sk89q.worldedit.util.formatting.component.TextComponentProducer;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.event.ClickEvent;
import com.sk89q.worldedit.util.formatting.text.event.HoverEvent;
import com.sk89q.worldedit.util.formatting.text.format.TextDecoration;
import java.util.List;
import javax.annotation.Nullable;
import org.enginehub.piston.ColorConfig;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.util.HelpGenerator;

public class CommandUsageBox
extends TextComponentProducer {
    public CommandUsageBox(List<Command> commands, String commandString) throws InvalidComponentException {
        this(commands, commandString, null);
    }

    public CommandUsageBox(List<Command> commands, String commandString, @Nullable CommandParameters parameters) throws InvalidComponentException {
        Preconditions.checkNotNull(commands);
        Preconditions.checkNotNull((Object)commandString);
        this.attachCommandUsage(commands, commandString);
    }

    private void attachCommandUsage(List<Command> commands, String commandString) {
        TextComponentProducer boxContent = new TextComponentProducer().append(HelpGenerator.create(commands).getFullHelp());
        if (CommandUtil.getSubCommands((Command)Iterables.getLast(commands)).size() > 0) {
            boxContent.append(TextComponent.newline()).append((Component)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder("> ").color(ColorConfig.getHelpText())).append((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder("List Subcommands").color(ColorConfig.getMainText())).decoration(TextDecoration.ITALIC, true)).clickEvent(ClickEvent.runCommand("//help -s " + commandString))).hoverEvent(HoverEvent.showText(TextComponent.of("List all subcommands of this command")))).build())).build());
        }
        MessageBox box = new MessageBox("Help for " + commandString, boxContent);
        this.append(box.create());
    }
}

