/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.formatting.component;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.util.formatting.component.PaginationBox;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.event.ClickEvent;
import com.sk89q.worldedit.util.formatting.text.event.HoverEvent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import java.io.File;
import java.util.regex.Pattern;

public class SchematicPaginationBox
extends PaginationBox {
    private final String prefix;
    private final File[] files;

    public SchematicPaginationBox(String rootDir, File[] files, String pageCommand) {
        super("Available schematics", pageCommand);
        this.prefix = rootDir == null ? "" : rootDir;
        this.files = files;
    }

    @Override
    public Component getComponent(int number) {
        Preconditions.checkArgument((number < this.files.length && number >= 0 ? 1 : 0) != 0);
        File file = this.files[number];
        Multimap<String, ClipboardFormat> exts = ClipboardFormats.getFileExtensionMap();
        String format = exts.get((Object)Files.getFileExtension((String)file.getName())).stream().findFirst().map(ClipboardFormat::getName).orElse("Unknown");
        boolean inRoot = file.getParentFile().getName().equals(this.prefix);
        String path = inRoot ? file.getName() : file.getPath().split(Pattern.quote(this.prefix + File.separator))[1];
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder().content("").append(((TextComponent)((TextComponent)TextComponent.of("[L]").color(TextColor.GOLD)).clickEvent(ClickEvent.of(ClickEvent.Action.RUN_COMMAND, "/schem load " + path))).hoverEvent(HoverEvent.of(HoverEvent.Action.SHOW_TEXT, TextComponent.of("Click to load"))))).append(TextComponent.space())).append(((TextComponent)TextComponent.of(path).color(TextColor.DARK_GREEN)).hoverEvent(HoverEvent.of(HoverEvent.Action.SHOW_TEXT, TextComponent.of(format))))).build();
    }

    @Override
    public int getComponentsSize() {
        return this.files.length;
    }
}

