/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableSet;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.ExpandCommandsRegistration;
import com.sk89q.worldedit.command.util.Logging;
import com.sk89q.worldedit.command.util.PermissionCondition;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.internal.annotation.MultiDirection;
import com.sk89q.worldedit.internal.command.CommandRegistrationHandler;
import com.sk89q.worldedit.internal.command.CommandUtil;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionOperationException;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandManagerService;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.part.CommandPart;
import org.enginehub.piston.part.SubCommandPart;

public class ExpandCommands {
    public static void register(CommandRegistrationHandler registration, CommandManager commandManager, CommandManagerService commandManagerService) {
        CommandManager collect = commandManagerService.newCommandManager();
        registration.register(collect, ExpandCommandsRegistration.builder(), new ExpandCommands());
        org.enginehub.piston.Command expandBaseCommand = collect.getCommand("/expand").orElseThrow(() -> new IllegalStateException("No /expand command"));
        commandManager.register("/expand", command -> {
            command.condition(new PermissionCondition((Set<String>)ImmutableSet.of((Object)"worldedit.selection.expand")));
            command.addPart(SubCommandPart.builder(TranslatableComponent.of("vert"), TextComponent.of("Vertical expansion sub-command")).withCommands((Collection<org.enginehub.piston.Command>)ImmutableSet.of((Object)ExpandCommands.createVertCommand(commandManager))).optional().build());
            command.addParts((Iterable<CommandPart>)expandBaseCommand.getParts());
            command.action(expandBaseCommand.getAction());
            command.description(expandBaseCommand.getDescription());
        });
    }

    private static org.enginehub.piston.Command createVertCommand(CommandManager commandManager) {
        return commandManager.newCommand("vert").description(TextComponent.of("Vertically expand the selection to world limits.")).action(parameters -> {
            ExpandCommands.expandVert(CommandUtil.requireIV(Key.of(LocalSession.class), "localSession", parameters), CommandUtil.requireIV(Key.of(Player.class), "localSession", parameters));
            return 1;
        }).build();
    }

    private static void expandVert(LocalSession session, Player player) throws IncompleteRegionException {
        Region region = session.getSelection(player.getWorld());
        try {
            int oldSize = region.getArea();
            region.expand(BlockVector3.at(0, player.getWorld().getMaxY() + 1, 0), BlockVector3.at(0, -(player.getWorld().getMaxY() + 1), 0));
            session.getRegionSelector(player.getWorld()).learnChanges();
            int newSize = region.getArea();
            session.getRegionSelector(player.getWorld()).explainRegionAdjust(player, session);
            player.print("Region expanded " + (newSize - oldSize) + " blocks [top-to-bottom].");
        }
        catch (RegionOperationException e) {
            player.printError(e.getMessage());
        }
    }

    @Command(name="/expand", desc="Expand the selection area")
    @Logging(value=Logging.LogMode.REGION)
    public void expand(Player player, LocalSession session, int amount, int reverseAmount, @MultiDirection List<BlockVector3> direction) throws WorldEditException {
        Region region = session.getSelection(player.getWorld());
        int oldSize = region.getArea();
        if (reverseAmount == 0) {
            for (BlockVector3 dir : direction) {
                region.expand(dir.multiply(amount));
            }
        } else {
            for (BlockVector3 dir : direction) {
                region.expand(dir.multiply(amount), dir.multiply(-reverseAmount));
            }
        }
        session.getRegionSelector(player.getWorld()).learnChanges();
        int newSize = region.getArea();
        session.getRegionSelector(player.getWorld()).explainRegionAdjust(player, session);
        player.print("Region expanded " + (newSize - oldSize) + " block(s).");
    }
}

