/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.SchematicCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.io.file.FilenameException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandPart;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class SchematicCommandsRegistration
implements CommandRegistration<SchematicCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private static final Key<Actor> actor_Key = Key.of(Actor.class);
    private CommandManager commandManager;
    private SchematicCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument filenamePart = CommandParts.arg(TranslatableComponent.of("filename"), TextComponent.of("File name.")).defaultsTo((Iterable<String>)ImmutableList.of()).ofTypes((Collection<Key<?>>)ImmutableList.of(string_Key)).build();
    private final CommandArgument formatNamePart = CommandParts.arg(TranslatableComponent.of("formatName"), TextComponent.of("Format name.")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"sponge")).ofTypes((Collection<Key<?>>)ImmutableList.of(string_Key)).build();
    private final NoArgCommandFlag allowOverwritePart = CommandParts.flag('f', TextComponent.of("Overwrite an existing file.")).build();
    private final ArgAcceptingCommandFlag pagePart = CommandParts.flag('p', TextComponent.of("Page to view.")).withRequiredArg().argNamed(TranslatableComponent.of("page")).defaultsTo((Iterable<String>)ImmutableList.of((Object)"1")).ofTypes((Collection<Key<?>>)ImmutableList.of(integer_Key)).build();
    private final NoArgCommandFlag oldFirstPart = CommandParts.flag('d', TextComponent.of("Sort by date, oldest first")).build();
    private final NoArgCommandFlag newFirstPart = CommandParts.flag('n', TextComponent.of("Sort by date, newest first")).build();

    private SchematicCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static SchematicCommandsRegistration builder() {
        return new SchematicCommandsRegistration();
    }

    public SchematicCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public SchematicCommandsRegistration containerInstance(SchematicCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public SchematicCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public SchematicCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    @Override
    public void build() {
        this.commandManager.register("load", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Load a schematic into your clipboard"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.filenamePart, (Object)this.formatNamePart));
            b.action(this::load);
            Method commandMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, "load", Player.class, LocalSession.class, String.class, String.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("save", b -> {
            b.aliases((Collection<String>)ImmutableList.of());
            b.description(TextComponent.of("Save a schematic into your clipboard"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.filenamePart, (Object)this.formatNamePart, (Object)this.allowOverwritePart));
            b.action(this::save);
            Method commandMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, "save", Player.class, LocalSession.class, String.class, String.class, Boolean.TYPE);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("delete", b -> {
            b.aliases((Collection<String>)ImmutableList.of((Object)"d"));
            b.description(TextComponent.of("Delete a saved schematic"));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.filenamePart));
            b.action(this::delete);
            Method commandMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, "delete", Actor.class, String.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("formats", b -> {
            b.aliases((Collection<String>)ImmutableList.of((Object)"listformats", (Object)"f"));
            b.description(TextComponent.of("List available formats"));
            b.parts((Collection<CommandPart>)ImmutableList.of());
            b.action(this::formats);
            Method commandMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, "formats", Actor.class);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("list", b -> {
            b.aliases((Collection<String>)ImmutableList.of((Object)"all", (Object)"ls"));
            b.description(TextComponent.of("List saved schematics"));
            b.footer(TextComponent.of("Note: Format is not fully verified until loading."));
            b.parts((Collection<CommandPart>)ImmutableList.of((Object)this.pagePart, (Object)this.oldFirstPart, (Object)this.newFirstPart));
            b.action(this::list);
            Method commandMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, "list", Actor.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int load(CommandParameters parameters) throws FilenameException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, "load", Player.class, LocalSession.class, String.class, String.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.load(this.player(parameters), this.session(parameters), this.filename(parameters), this.formatName(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int save(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, "save", Player.class, LocalSession.class, String.class, String.class, Boolean.TYPE);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.save(this.player(parameters), this.session(parameters), this.filename(parameters), this.formatName(parameters), this.allowOverwrite(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int delete(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, "delete", Actor.class, String.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.delete(this.actor(parameters), this.filename(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int formats(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, "formats", Actor.class);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.formats(this.actor(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private int list(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, "list", Actor.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
        RegistrationUtil.listenersBeforeCall(this.listeners, cmdMethod, parameters);
        try {
            this.containerInstance.list(this.actor(parameters), this.page(parameters), this.oldFirst(parameters), this.newFirst(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, cmdMethod, parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, cmdMethod, parameters, t);
            throw t;
        }
    }

    private boolean oldFirst(CommandParameters parameters) {
        return this.oldFirstPart.in(parameters);
    }

    private Player player(CommandParameters parameters) {
        return RegistrationUtil.requireOptional(player_Key, "player", parameters.injectedValue(player_Key));
    }

    private boolean allowOverwrite(CommandParameters parameters) {
        return this.allowOverwritePart.in(parameters);
    }

    private String formatName(CommandParameters parameters) {
        return this.formatNamePart.value(parameters).asSingle(string_Key);
    }

    private LocalSession session(CommandParameters parameters) {
        return RegistrationUtil.requireOptional(localSession_Key, "session", parameters.injectedValue(localSession_Key));
    }

    private boolean newFirst(CommandParameters parameters) {
        return this.newFirstPart.in(parameters);
    }

    private Actor actor(CommandParameters parameters) {
        return RegistrationUtil.requireOptional(actor_Key, "actor", parameters.injectedValue(actor_Key));
    }

    private int page(CommandParameters parameters) {
        return this.pagePart.value(parameters).asSingle(integer_Key);
    }

    private String filename(CommandParameters parameters) {
        return this.filenamePart.value(parameters).asSingle(string_Key);
    }
}

