/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.Logging;
import com.sk89q.worldedit.entity.Player;
import java.io.File;
import java.util.List;
import java.util.stream.Stream;
import org.enginehub.piston.annotation.Command;

public class ScriptingCommands {
    private final WorldEdit worldEdit;

    public ScriptingCommands(WorldEdit worldEdit) {
        Preconditions.checkNotNull((Object)worldEdit);
        this.worldEdit = worldEdit;
    }

    @Command(name="cs", desc="Execute a CraftScript")
    @CommandPermissions(value={"worldedit.scripting.execute"})
    @Logging(value=Logging.LogMode.ALL)
    public void execute(Player player, LocalSession session, String filename, List<String> args) throws WorldEditException {
        if (!player.hasPermission("worldedit.scripting.execute." + filename)) {
            player.printError("You don't have permission to use that script.");
            return;
        }
        session.setLastScript(filename);
        File dir = this.worldEdit.getWorkingDirectoryFile(this.worldEdit.getConfiguration().scriptsDir);
        File f = this.worldEdit.getSafeOpenFile(player, dir, filename, "js", "js");
        this.worldEdit.runScript(player, f, (String[])Stream.concat(Stream.of(filename), args.stream()).toArray(String[]::new));
    }

    @Command(name=".s", desc="Execute last CraftScript")
    @CommandPermissions(value={"worldedit.scripting.execute"})
    @Logging(value=Logging.LogMode.ALL)
    public void executeLast(Player player, LocalSession session, List<String> args) throws WorldEditException {
        String lastScript = session.getLastScript();
        if (!player.hasPermission("worldedit.scripting.execute." + lastScript)) {
            player.printError("You don't have permission to use that script.");
            return;
        }
        if (lastScript == null) {
            player.printError("Use /cs with a script name first.");
            return;
        }
        File dir = this.worldEdit.getWorkingDirectoryFile(this.worldEdit.getConfiguration().scriptsDir);
        File f = this.worldEdit.getSafeOpenFile(player, dir, lastScript, "js", "js");
        this.worldEdit.runScript(player, f, (String[])Stream.concat(Stream.of(lastScript), args.stream()).toArray(String[]::new));
    }
}

