/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.tool.AreaPickaxe;
import com.sk89q.worldedit.command.tool.RecursivePickaxe;
import com.sk89q.worldedit.command.tool.SinglePickaxe;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.entity.Player;
import org.enginehub.piston.annotation.Command;

public class SuperPickaxeCommands {
    private final WorldEdit we;

    public SuperPickaxeCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(name="single", desc="Enable the single block super pickaxe mode")
    @CommandPermissions(value={"worldedit.superpickaxe"})
    public void single(Player player, LocalSession session) throws WorldEditException {
        session.setSuperPickaxe(new SinglePickaxe());
        session.enableSuperPickAxe();
        player.print("Mode changed. Left click with a pickaxe. // to disable.");
    }

    @Command(name="area", desc="Enable the area super pickaxe pickaxe mode")
    @CommandPermissions(value={"worldedit.superpickaxe.area"})
    public void area(Player player, LocalSession session, int range) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        if (range > config.maxSuperPickaxeSize) {
            player.printError("Maximum range: " + config.maxSuperPickaxeSize);
            return;
        }
        session.setSuperPickaxe(new AreaPickaxe(range));
        session.enableSuperPickAxe();
        player.print("Mode changed. Left click with a pickaxe. // to disable.");
    }

    @Command(name="recursive", aliases={"recur"}, desc="Enable the recursive super pickaxe pickaxe mode")
    @CommandPermissions(value={"worldedit.superpickaxe.recursive"})
    public void recursive(Player player, LocalSession session, double range) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        if (range > (double)config.maxSuperPickaxeSize) {
            player.printError("Maximum range: " + config.maxSuperPickaxeSize);
            return;
        }
        session.setSuperPickaxe(new RecursivePickaxe(range));
        session.enableSuperPickAxe();
        player.print("Mode changed. Left click with a pickaxe. // to disable.");
    }
}

